{
  lib,
  buildPythonApplication,
  fetchFromGitHub,

  # build-system
  setuptools,

  # dependencies
  aiohttp,
  beautifulsoup4,
  brotlipy,
  cvss,
  distro,
  filetype,
  jinja2,
  jsonschema,
  lib4sbom,
  lib4vex,
  packageurl-python,
  packaging,
  plotly,
  python-gnupg,
  pyyaml,
  requests,
  rich,
  rpmfile,
  xmlschema,
  zipp,
  zstandard,

  # optional-dependencies
  reportlab,

  # runtime-dependencies
  google-cloud-sdk,

  # tests
  versionCheckHook,
}:

buildPythonApplication rec {
  pname = "cve-bin-tool";
  version = "3.4";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "intel";
    repo = "cve-bin-tool";
    tag = "v${version}";
    hash = "sha256-pv8XjKjZBUw5FmmUn1dakGeS1uw2xzF3wSIZOYQ2/3c=";
  };

  build-system = [ setuptools ];

  dependencies = [
    aiohttp
    beautifulsoup4
    brotlipy
    cvss
    distro
    filetype
    jinja2
    jsonschema
    lib4sbom
    lib4vex
    packageurl-python
    packaging
    plotly
    python-gnupg
    pyyaml
    requests
    rich
    rpmfile
    setuptools
    xmlschema
    zipp
    zstandard
  ]
  ++ aiohttp.optional-dependencies.speedups;

  optional-dependencies = {
    pdf = [ reportlab ];
  };

  pythonRemoveDeps = [
    # gsutil is only called as a binary at runtime instead of being used as a library
    "gsutil"
  ];

  # don't run pytestCheckHook because it wants to open a sqlite database, access the internet, etc
  nativeCheckInputs = [
    versionCheckHook
  ]
  ++ lib.concatAttrValues optional-dependencies;

  pythonImportsCheck = [
    "cve_bin_tool"
    "cve_bin_tool.mismatch_loader"
  ];

  # provide gsutil
  makeWrapperArgs = [
    "--prefix"
    "PATH"
    ":"
    (lib.makeBinPath [ google-cloud-sdk ])
  ];

  meta = {
    description = "CVE Binary Checker Tool";
    homepage = "https://github.com/intel/cve-bin-tool";
    changelog = "https://github.com/intel/cve-bin-tool/releases/tag/${src.tag}";
    license = lib.licenses.gpl3Plus;
    maintainers = [ ];
  };
}
