{
  lib,
  fetchurl,
  fetchpatch,
  buildDunePackage,
  replaceVars,
  dot-merlin-reader,
  dune_2,
  yojson,
  csexp,
  result,
  seq,
  menhirSdk,
}:

buildDunePackage rec {
  pname = "merlin";
  version = "3.8.0";

  src = fetchurl {
    url = "https://github.com/ocaml/merlin/releases/download/v${version}/merlin-${version}.tbz";
    sha256 = "sha256-wmBGNwXL3BduF4o1sUXtAOUHJ4xmMvsWAxl/QdNj/28=";
  };

  minimalOCamlVersion = "4.02.3";

  patches = [
    (replaceVars ./fix-paths.patch {
      dot-merlin-reader = "${dot-merlin-reader}/bin/dot-merlin-reader";
      dune = "${dune_2}/bin/dune";
    })
    # https://github.com/ocaml/merlin/pull/1798
    (fetchpatch {
      name = "vim-python-12-syntax-warning-fix.patch";
      url = "https://github.com/ocaml/merlin/commit/9e0c47b0d5fd0c4edc37c4c7ce927b155877557d.patch";
      hash = "sha256-HmdTISE/s45C5cwLgsCHNUW6OAPSsvQ/GcJE6VDEobs=";
    })
  ];

  strictDeps = true;

  buildInputs = [
    dot-merlin-reader
    yojson
    csexp
    result
    seq
    menhirSdk
  ];

  meta = {
    description = "Editor-independent tool to ease the development of programs in OCaml";
    homepage = "https://github.com/ocaml/merlin";
    license = lib.licenses.mit;
    maintainers = [ lib.maintainers.vbgl ];
  };
}
