{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  requests,
  setuptools,
}:

buildPythonPackage (finalAttrs: {
  pname = "pyexploitdb";
  version = "0.3.10";
  pyproject = true;

  src = fetchPypi {
    inherit (finalAttrs) pname version;
    hash = "sha256-EZX2eCNc46UuqbBEypjp6NcHOAI6C7SiFu+AZPXcSg8=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyexploitdb" ];

  meta = {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ fab ];
  };
})
