{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  setuptools-scm,
}:

buildPythonPackage rec {
  pname = "napari-plugin-engine";
  version = "0.2.0";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "napari";
    repo = "napari-plugin-engine";
    tag = "v${version}";
    hash = "sha256-cKpCAEYYRq3UPje7REjzhEe1J9mmrtXs8TBnxWukcNE=";
  };

  nativeBuildInputs = [ setuptools-scm ];

  # Circular dependency: napari
  doCheck = false;

  pythonImportsCheck = [ "napari_plugin_engine" ];

  meta = {
    description = "First generation napari plugin engine";
    homepage = "https://github.com/napari/napari-plugin-engine";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ SomeoneSerge ];
  };
}
