{
  buildPythonPackage,
  fetchPypi,
  ply,
  lib,
}:

buildPythonPackage rec {
  pname = "cppheaderparser";
  version = "2.7.4";
  format = "setuptools";

  src = fetchPypi {
    pname = "CppHeaderParser";
    inherit version;
    hash = "sha256-OCswQW2VsKXoUCshSBDcrCpWQykX4mUUR9Or4lPjzEI=";
  };

  propagatedBuildInputs = [ ply ];

  pythonImportsCheck = [ "CppHeaderParser" ];

  meta = {
    description = "Parse C++ header files using ply.lex to generate navigable class tree representing the class structure";
    homepage = "https://sourceforge.net/projects/cppheaderparser/";
    license = lib.licenses.bsdOriginal;
    maintainers = with lib.maintainers; [ pamplemousse ];
  };
}
