{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  pydantic,
  pytestCheckHook,
  srsly,
}:

buildPythonPackage rec {
  pname = "confection";
  version = "0.1.5";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "explosion";
    repo = "confection";
    tag = "v${version}";
    hash = "sha256-1XIo9Hg4whYS1AkFeX8nVnpv+IvnpmyydHYdVYS0xZc=";
  };

  propagatedBuildInputs = [
    pydantic
    srsly
  ];

  nativeCheckInputs = [ pytestCheckHook ];

  pythonImportsCheck = [ "confection" ];

  meta = {
    description = "Library that offers a configuration system";
    homepage = "https://github.com/explosion/confection";
    changelog = "https://github.com/explosion/confection/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
}
