# FIXME: make gdk-pixbuf dependency optional
{
  stdenv,
  buildPythonPackage,
  fetchPypi,
  lib,
  replaceVars,
  pikepdf,
  pytestCheckHook,
  cairo,
  cffi,
  flit-core,
  numpy,
  withXcffib ? false,
  xcffib,
  glib,
  gdk-pixbuf,
}:

buildPythonPackage rec {
  pname = "cairocffi";
  version = "1.7.1";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-LkjuhkiE7Eo6NL+oyauZmfaIKG63FKFaQ+ydBow2VXs=";
  };

  patches = [
    # OSError: dlopen() failed to load a library: gdk-pixbuf-2.0 / gdk-pixbuf-2.0-0
    (replaceVars ./dlopen-paths.patch {
      ext = stdenv.hostPlatform.extensions.sharedLibrary;
      cairo = cairo.out;
      glib = glib.out;
      gdk_pixbuf = gdk-pixbuf.out;
    })
    ./fix_test_scaled_font.patch
  ];

  nativeBuildInputs = [ flit-core ];

  propagatedBuildInputs = [
    cairo
    cffi
  ]
  ++ lib.optional withXcffib xcffib;

  nativeCheckInputs = [
    numpy
    pikepdf
    pytestCheckHook
  ];

  pythonImportsCheck = [ "cairocffi" ];

  # Cairo tries to load system fonts by default.
  # It's surfaced as a Cairo "out of memory" error in tests.
  __impureHostDeps = [ "/System/Library/Fonts" ];

  meta = {
    changelog = "https://github.com/Kozea/cairocffi/blob/v${version}/NEWS.rst";
    homepage = "https://github.com/SimonSapin/cairocffi";
    license = lib.licenses.bsd3;
    maintainers = [ ];
    description = "cffi-based cairo bindings for Python";
  };
}
