{
  lib,
  pkgs,
  erlang,
}:

let
  inherit (lib) makeExtensible;

  # FIXME: add support for overrideScope
  callPackageWithScope =
    scope: drv: args:
    lib.callPackageWith scope drv args;
  mkScope = scope: pkgs // scope;

  packages =
    self:
    let
      defaultScope = mkScope self;
      callPackage = drv: args: callPackageWithScope defaultScope drv args;
    in
    rec {
      inherit callPackage erlang;
      beamPackages = self;

      inherit (callPackage ../tools/build-managers/rebar3 { }) rebar3 rebar3WithPlugins;
      rebar = callPackage ../tools/build-managers/rebar { };

      pc = callPackage ./pc { };
      rebar3-proper = callPackage ./rebar3-proper { };
      rebar3-nix = callPackage ./rebar3-nix { };

      fetchHex = callPackage ./fetch-hex.nix { };

      fetchRebar3Deps = callPackage ./fetch-rebar-deps.nix { };
      rebar3Relx = callPackage ./rebar3-release.nix { };

      buildRebar3 = callPackage ./build-rebar3.nix { };
      buildHex = callPackage ./build-hex.nix { };
      buildErlangMk = callPackage ./build-erlang-mk.nix { };
      buildMix = callPackage ./build-mix.nix { };
      fetchMixDeps = callPackage ./fetch-mix-deps.nix { };
      mixRelease = callPackage ./mix-release.nix { };

      erlfmt = callPackage ./erlfmt { };
      elvis-erlang = callPackage ./elvis-erlang { };

      # BEAM-based languages.
      elixir = elixir_1_18;

      elixir_1_20 = callPackage ../interpreters/elixir/1.20.nix {
        inherit erlang;
        debugInfo = true;
      };

      elixir_1_19 = callPackage ../interpreters/elixir/1.19.nix {
        inherit erlang;
        debugInfo = true;
      };

      elixir_1_18 = callPackage ../interpreters/elixir/1.18.nix {
        inherit erlang;
        debugInfo = true;
      };

      elixir_1_17 = callPackage ../interpreters/elixir/1.17.nix {
        inherit erlang;
        debugInfo = true;
      };

      elixir_1_16 = callPackage ../interpreters/elixir/1.16.nix {
        inherit erlang;
        debugInfo = true;
      };

      elixir_1_15 = callPackage ../interpreters/elixir/1.15.nix {
        inherit erlang;
        debugInfo = true;
      };

      # Remove old versions of elixir, when the supports fades out:
      # https://hexdocs.pm/elixir/compatibility-and-deprecations.html

      ex_doc = callPackage ./ex_doc {
        inherit fetchMixDeps mixRelease;
      };

      elixir-ls = callPackage ./elixir-ls { inherit elixir; };

      lfe = callPackage ../interpreters/lfe { inherit erlang buildRebar3 buildHex; };

      livebook = callPackage ./livebook { inherit beamPackages; };

      # Non hex packages. Examples how to build Rebar/Mix packages with and
      # without helper functions buildRebar3 and buildMix.
      hex = callPackage ./hex { };
      webdriver = callPackage ./webdriver { };
    };
in
makeExtensible packages
