# Clear dependency_libs in libtool files for shared libraries.

# Shared libraries already encode their dependencies with locations.  .la
# files do not always encode those locations, and sometimes encode the
# locations in the wrong Nix output. .la files are not needed for shared
# libraries, but without dependency_libs they do not hurt either.

fixupOutputHooks+=(_pruneLibtoolFiles)

_pruneLibtoolFiles() {
    if [ "${dontPruneLibtoolFiles-}" ] || [ ! -e "$prefix" ]; then
       return
    fi

    # Libtool uses "dlname" and "library_names" fields for shared libraries and
    # the "old_library" field for static libraries.  We are processing only
    # those .la files that do not describe static libraries.
    find "$prefix" -type f -name '*.la' \
         -exec grep -q '^# Generated by .*libtool' {} \; \
         -exec grep -q "^old_library=''" {} \; \
         -exec sed -i {} -e "/^dependency_libs='[^']/ c dependency_libs='' #pruned" \;
}
