# Release 25.11 ("Xantusia", 2025.11/30) {#sec-release-25.11}

## Highlights {#sec-release-25.11-highlights}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- Added `nixos-init`, a Rust-based bashless initialization system for systemd initrd. This allows to build NixOS systems without any interpreter. Enable via `system.nixos-init.enable = true;`.

- COSMIC DE has been updated to the beta version, bringing it closer to its first stable release. This includes updates to its core components, applications, and overall stability.

- FirewallD support has been added. It can be configured both as a standalone service (through `services.firewalld`), and as a backend to the existing `networking.firewall` options.

- GNOME has been updated to version 49.

  - Removes X11 session support. Though you can still run X11 apps using XWayland.
  - gnome-session’s custom service manager was removed in favour of using systemd.
  - GDM now allows multiple seats, which is useful for e.g. remote logins. Though we currently [limit this to five greeter instances](https://github.com/NixOS/nixpkgs/issues/458058).
  - `papers` document viewer is now installed by default, replacing `evince`. Though we still include `evince` transitively by `sushi` (quick previewer used by Files/Nautilus) You can disable either using [](#opt-environment.gnome.excludePackages) and restore `evince` with [](#opt-programs.evince.enable).
  - `showtime` video player is now installed by default, replacing `totem`. You can disable it using [](#opt-environment.gnome.excludePackages) and restore `totem` with [](#opt-environment.systemPackages).
  - The `ibus` input method is now enabled by default, to ensure that dead keys continue to work like in GNOME <= 48. To change it, see [](#opt-i18n.inputMethod.enable) and [](#opt-i18n.inputMethod.type).

  Refer to the [GNOME release notes](https://release.gnome.org/49/) for more details.

- `networking.firewall` now has a `backend` option for choosing which backend to use.

- `nixos-rebuild-ng`, a full rewrite of `nixos-rebuild` in Python, is enabled by default from this release. You can disable it by setting {option}`system.rebuild.enableNg` to `false` in your configuration if you need, but please report any issues. It is expected that the next major version of NixOS (26.05) will remove the {option}`system.rebuild.enableNg` option.

- `rEFInd`, a graphical boot manager for UEFI systems, can now be used through [](#opt-boot.loader.refind.enable).

- Secure boot support can now be enabled for the Limine bootloader through {option}`boot.loader.limine.secureBoot.enable`. Bootloader install script signs the bootloader, then kernels are hashed during system rebuild and written to a config. This allows Limine to boot only the kernels installed through NixOS system.

- Syncthing has been updated to version 2.0.0.

- The default PostgreSQL version for new NixOS installations (i.e. with `system.stateVersion >= 25.11`) is v17.

- The NetworkManager module does not ship with a default set of VPN plugins anymore. All required VPN plugins must now be explicitly configured in [`networking.networkmanager.plugins`](#opt-networking.networkmanager.plugins).

- The Qt 5-based versions of KDE Gear, Plasma, Maui and Deepin have been removed. Users are advised to migrate to Plasma 6 and Gear 25.08, available under `kdePackages`.

## New Modules {#sec-release-25.11-new-modules}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- Added `nixos-init`, a Rust-based bashless initialization system for systemd initrd. This allows to build NixOS systems without any interpreter. Enable via `system.nixos-init.enable = true;`.

- [angrr](https://github.com/linyinfeng/angrr), a service that automatically cleans up old auto GC roots. Available as [services.angrr](#opt-services.angrr.enable).

- Auto-scrub support for Bcachefs filesystems can now be enabled through [services.bcachefs.autoScrub.enable](#opt-services.bcachefs.autoScrub.enable) to periodically check for data corruption. If there's a correct copy available, it will automatically repair corrupted blocks.

- [Beszel](https://beszel.dev), a lightweight server monitoring hub with historical data, docker stats, and alerts. Available as [`services.beszel.agent`](options.html#opt-services.beszel.agent.enable) and [`services.beszel.hub`](options.html#opt-services.beszel.hub.enable).

- [boot.kernel.sysfs](options.html#opt-boot.kernel.sysfs), a new way to set of sysfs attributes.

- [Broadcast Box](https://github.com/Glimesh/broadcast-box), a WebRTC broadcast server. Available as [services.broadcast-box](options.html#opt-services.broadcast-box.enable).

- [byedpi](https://github.com/hufrea/byedpi), a DPI bypass service. Available as [services.byedpi](#opt-services.byedpi.enable).

- [Chrysalis](https://github.com/keyboardio/Chrysalis), a graphical configurator for Kaleidoscope-powered keyboards. Available as [programs.chrysalis](#opt-programs.chrysalis.enable).

- [Chhoto URL](https://github.com/SinTan1729/chhoto-url), a simple, blazingly fast, selfhosted URL shortener with no unnecessary features, written in Rust. Available as [services.chhoto-url](#opt-services.chhoto-url.enable).

- [conman](https://github.com/dun/conman), a serial console management program. Available as [services.conman](#opt-services.conman.enable).

- [Corteza](https://cortezaproject.org/), a low-code platform. Available as [services.corteza](#opt-services.corteza.enable).

- [crowdsec](https://www.crowdsec.net/), a free, open-source and collaborative IPS. Available as [services.crowdsec](#opt-services.crowdsec.enable).

- [crowdsec-firewall-bouncer](https://www.crowdsec.net/), the CrowdSec Remediation Component for fetching new and old decisions from a CrowdSec API and adding them to a blocklist used by supported firewalls. Available as [services.crowdsec-firewall-bouncer](#opt-services.crowdsec-firewall-bouncer.enable).

- Docker now defaults to 28.x, because version 27.x stopped receiving security updates and bug fixes after [May 2, 2025](https://github.com/moby/moby/pull/49910).

- [docuseal](https://github.com/docusealco/docuseal), a DocuSign alternative. Create, fill, and sign digital documents. Available at [services.docuseal](#opt-services.docuseal.enable).

- [Draupnir](https://github.com/the-draupnir-project/draupnir), a Matrix moderation bot. Available as [services.draupnir](#opt-services.draupnir.enable).

- [dwl](https://codeberg.org/dwl/dwl), a compact, hackable compositor for Wayland based on wlroots. Available as [programs.dwl](#opt-programs.dwl.enable).

- [ente](https://github.com/ente-io/ente), a service that provides a fully open source, end-to-end encrypted platform for photos and videos. Available as [services.ente.api](#opt-services.ente.api.enable) and [services.ente.web](#opt-services.ente.web.enable).

- [ErsatzTV](https://ersatztv.org), a personal IPTV server. Available as [services.ersatztv](#opt-services.ersatztv.enable).

- [Fediwall](https://fediwall.social), a web application for live displaying toots from mastodon, inspired by mastowall. Available as [services.fediwall](#opt-services.fediwall.enable).

- [FileBrowser](https://filebrowser.org/), a web application for managing and sharing files. Available as [services.filebrowser](#opt-services.filebrowser.enable).

- [FirewallD](https://firewalld.org/), a firewall daemon with D-Bus interface providing a dynamic firewall. Available as [services.firewalld](#opt-services.firewalld.enable) and a [networking.firewall.backend](#opt-networking.firewall.backend).

- [fw-fanctrl](https://github.com/TamtamHero/fw-fanctrl), a simple systemd service to better control Framework Laptop's fan(s). Available as [hardware.fw-fanctrl](#opt-hardware.fw-fanctrl.enable).

- [go-httpbin](https://github.com/mccutchen/go-httpbin), a reasonably complete and well-tested golang port of httpbin, with zero dependencies outside the go stdlib. Available as [services.go-httpbin](#opt-services.go-httpbin.enable).

- [gtklock](https://github.com/jovanlanik/gtklock), a GTK-based lockscreen for Wayland. Available as [programs.gtklock](#opt-programs.gtklock.enable).

- [Homebridge](https://github.com/homebridge/homebridge), a lightweight Node.js server you can run on your home network that emulates the iOS HomeKit API. Available as [services.homebridge](#opt-services.homebridge.enable).

- [IfState](https://ifstate.net), manage host interface settings in a declarative manner. Available as [networking.ifstate](options.html#opt-networking.ifstate.enable) and [boot.initrd.network.ifstate](options.html#opt-boot.initrd.network.ifstate.enable).

- [KMinion](https://github.com/redpanda-data/kminion), feature-rich Prometheus exporter for Apache Kafka. Available as [services.prometheus.exporters.kafka](options.html#opt-services.prometheus.exporters.kafka).

- [LACT](https://github.com/ilya-zlobintsev/LACT), a GPU monitoring and configuration tool, can now be enabled through [services.lact.enable](#opt-services.lact.enable).
  Note that for LACT to work properly on AMD GPU systems, you need to enable [hardware.amdgpu.overdrive.enable](#opt-hardware.amdgpu.overdrive.enable).

- [lemurs](https://github.com/coastalwhite/lemurs), a customizable TUI display/login manager. Available at [services.displayManager.lemurs](#opt-services.displayManager.lemurs.enable).

- [LibreTranslate](https://libretranslate.com), a free and open source machine translation API. Available as [services.libretranslate](#opt-services.libretranslate.enable).

- [Linkwarden](https://linkwarden.app/) a self-hosted collaborative bookmark manager to collect, read, annotate, and fully preserve what matters, all in one place. Available as [services.linkwarden](#opt-services.linkwarden.enable).

- [Linyaps](https://linyaps.org.cn/), a cross-distribution package manager with sandboxed apps and shared runtime. Available as [services.linyaps](#opt-services.linyaps.enable).

- [llama-swap](https://github.com/mostlygeek/llama-swap), a light weight transparent proxy server that provides automatic model swapping to llama.cpp's server (or any server with an OpenAI compatible endpoint). Available as [](#opt-services.llama-swap.enable).

- [local-content-share](https://github.com/Tanq16/local-content-share), a simple web-app for storing/sharing text snippets and files in your local network. Available as [services.local-content-share](#opt-services.local-content-share.enable).

- [LubeLogger](https://lubelogger.com/), a vehicle maintenance and fuel mileage tracker.
  Available as [services.lubelogger](#opt-services.lubelogger.enable).

- [mautrix-discord](https://github.com/mautrix/discord), a Matrix-Discord puppeting/relay bridge. Available as [services.mautrix-discord](#opt-services.mautrix-discord.enable).

- [Neat IP Address Planner](https://spritelink.github.io/NIPAP/) (NIPAP), a sleek, intuitive and powerful IP address management system. Available as [services.nipap.enable](#opt-services.nipap.enable).

- [nebula-lighthouse-service](https://github.com/manuels/nebula-lighthouse-service), a public Nebula VPN lighthouse service. Available as [services.nebula-lighthouse-service](#opt-services.nebula-lighthouse-service.enable).

- [Newt](https://github.com/fosrl/newt), a fully user space WireGuard tunnel client and TCP/UDP proxy, designed to securely expose private resources controlled by Pangolin. Available as [services.newt](options.html#opt-services.newt.enable).

- [nixbit](https://github.com/pbek/nixbit), a GUI application for updating your NixOS system from a Nix Flakes Git repository. Available as [programs.nixbit](#opt-programs.nixbit.enable).

- [nix-store-veritysetup](https://github.com/nikstur/nix-store-veritysetup-generator), a systemd generator to unlock the Nix Store as a dm-verity protected block device. Available as [boot.initrd.nix-store-veritysetup](options.html#opt-boot.initrd.nix-store-veritysetup.enable).

- [nvme-rs](https://github.com/liberodark/nvme-rs), NVMe monitoring [services.nvme-rs](#opt-services.nvme-rs.enable).

- [Overseerr](https://overseerr.dev), a request management and media discovery tool for the Plex ecosystem. Available as [services.overseerr](#opt-services.overseerr.enable).

- [PairDrop](https://github.com/schlagmichdoch/pairdrop), a peer-to-peer file transfer web app. Available as [services.pairdrop](#opt-services.pairdrop.enable).

- [paisa](https://github.com/ananthakumaran/paisa), a personal finance tracker and dashboard. Available as [services.paisa](#opt-services.paisa.enable).

- [Pangolin](https://github.com/fosrl/pangolin), a tunneled reverse proxy server with access control. Available as [services.pangolin](#opt-services.pangolin.enable).

- [Pi-hole](https://pi-hole.net/), a DNS sinkhole for advertisements based on Dnsmasq. Available as [services.pihole-ftl](#opt-services.pihole-ftl.enable), and [services.pihole-web](#opt-services.pihole-web.enable) for the web GUI and API.

- [pmount](https://salsa.debian.org/debian/pmount), a tool that allows normal users to mount removable devices without requiring root privileges Available at [programs.pmount](#opt-programs.pmount.enable).

- [postfix-tlspol](https://github.com/Zuplu/postfix-tlspol), a MTA-STS and DANE resolver and TLS policy server for Postfix. Available as [services.postfix-tlspol](#opt-services.postfix-tlspol.enable).

- [Prometheus Tailscale Exporter](https://github.com/adinhodovic/tailscale-exporter), a Prometheus exporter for Tailscale Tailnet metrics.

- [Prometheus Storagebox Exporter](https://github.com/fleaz/prometheus-storagebox-exporter), a Prometheus exporter for Hetzner storage boxes.

- [qBittorrent](https://www.qbittorrent.org/), a bittorrent client programmed in C++ / Qt that uses libtorrent by Arvid Norberg. Available as [services.qbittorrent](#opt-services.qbittorrent.enable).

- [radicle-ci-broker](https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:zwTxygwuz5LDGBq255RA2CbNGrz8), a tool for running CI for repositories in the local [Radicle](https://radicle.xyz/) node. Available as [services.radicle.ci.broker.enable](#opt-services.radicle.ci.broker.enable).

- [radicle-native-ci](https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:z3qg5TKmN83afz2fj9z3fQjU8vaYE), an adapter for the [Radicle CI broker](https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:zwTxygwuz5LDGBq255RA2CbNGrz8), for performing CI runs locally. Available as [services.radicle.ci.adapters.native](#opt-services.radicle.ci.adapters.native.instances).

- [rauc](https://rauc.io/) (the Robust Auto-Update Controller), a daemon that allows reliable and secure software updates in embedded Linux systems. Available at [services.rauc](#opt-services.rauc.enable).

- [ringboard](https://github.com/SUPERCILEX/clipboard-history), a fast, efficient, and composable clipboard manager for Linux. Available for x11 as [services.ringboard](#opt-services.ringboard.x11.enable) and for Wayland as [services.ringboard](#opt-services.ringboard.wayland.enable).

- [rsync](https://rsync.samba.org/), an open source utility that provides fast incremental file transfer. Available as [services.rsync](options.html#opt-services.rsync).

- [Sharkey](https://joinsharkey.org), a Sharkish microblogging platform. Available as [services.sharkey](#opt-services.sharkey.enable).

- [SillyTavern](https://sillytavern.app/), an LLM Frontend for Power Users. Available as [services.sillytavern](#opt-services.sillytavern.enable).

- [SuiteNumérique Docs](https://github.com/suitenumerique/docs), a collaborative note taking, wiki and documentation web platform and alternative to Notion or Outline. Available as [services.lasuite-docs](#opt-services.lasuite-docs.enable).

- [SuiteNumérique Meet](https://github.com/suitenumerique/meet), an open source alternative to Google Meet and Zoom powered by LiveKit. It features HD video calls, screen sharing, and chat features. Available as [services.lasuite-meet](#opt-services.lasuite-meet.enable).

- [Speedify](https://speedify.com/), a proprietary VPN which allows combining multiple internet connections (Wi-Fi, 4G, 5G, Ethernet, Starlink, Satellite, and more) to improve the stability, speed, and security of online experiences. Available as [services.speedify](#opt-services.speedify.enable).

- [Spoolman](https://github.com/Donkie/Spoolman), a inventory management system for Filament spools. Available as [services.spoolman](#opt-services.spoolman.enable).

- [Sshwifty](https://github.com/nirui/sshwifty), a Telnet and SSH client for your browser. Available as [services.sshwifty](#opt-services.sshwifty.enable).

- [Szurubooru](https://github.com/rr-/szurubooru), an image board engine inspired by services such as Danbooru, dedicated for small and medium communities. Available as [services.szurubooru](#opt-services.szurubooru.enable).

- [Temporal](https://temporal.io/), a durable execution platform that enables
  developers to build scalable applications without sacrificing productivity or
  reliability. Available as [services.temporal](#opt-services.temporal.enable).

- [Timekpr-nExT](https://mjasnik.gitlab.io/timekpr-next/), a time managing application that helps optimizing time spent at computer for your subordinates, children or even for yourself. Available as [](#opt-services.timekpr.enable).

- [tlsrpt-reporter](https://github.com/sys4/tlsrpt-reporter), an application suite to generate and deliver TLSRPT reports. Available as [services.tlsrpt](#opt-services.tlsrpt.enable).

- [tsidp](https://github.com/tailscale/tsidp), a simple OIDC / OAuth Identity Provider (IdP) server for your tailnet. Available as [services.tsidp](#opt-services.tsidp.enable).

- [TuneD](https://tuned-project.org/), a system tuning service for Linux. Available as [services.tuned](#opt-services.tuned.enable).

- [tuwunel](https://matrix-construct.github.io/tuwunel/), a federated chat server implementing the Matrix protocol, forked from Conduwuit. Available as [services.matrix-tuwunel](#opt-services.matrix-tuwunel.enable).

- [umami](https://github.com/umami-software/umami), a simple, fast, privacy-focused alternative to Google Analytics. Available with [services.umami](#opt-services.umami.enable).

- [wayvnc](https://github.com/any1/wayvnc), a VNC server for wlroots based Wayland compositors. Available as [programs.wayvnc](#opt-programs.wayvnc.enable).

- [XPPen](https://www.xp-pen.com/), an official closed-source driver for XP Pen tablets. Available as [programs.xppen](#opt-programs.xppen.enable).

- [Warpgate](https://warpgate.null.page), an SSH, HTTPS, MySQL and Postgres bastion. Available as [services.warpgate](#opt-services.warpgate.enable). Note that you need to run `warpgate recover-access` to recover builtin admin account, as the initialisation script uses a throwaway value to initialise its database.

- [yubikey-manager](https://github.com/Yubico/yubikey-manager), a tool for configuring YubiKey devices. Available as [programs.yubikey-manager](#opt-programs.yubikey-manager.enable).

- [rumno](https://gitlab.com/ivanmalison/rumno), a visual pop-up notification manager. Available as [services.rumno](#opt-services.rumno.enable).

## Backward Incompatibilities {#sec-release-25.11-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `boot.enableContainers` is only turned on when a declarative NixOS container is defined in `containers`.
  If you use the `nixos-container` tool for imperative container management, set `boot.enableContainers = true;` explicitly.

- Configurations with `boot.initrd.systemd.enable && !boot.initrd.enable` will have their `init` script at `$toplevel/init` instead of `$toplevel/prepare-root`. This is because it does not make sense for systemd stage 1 to affect the `init` script when stage 1 is entirely disabled (e.g. containers).

- `command-not-found` package is now disabled by default; it works only for nix-channels based systems, and requires setup for it to work.

- `hardware.amdgpu.amdvlk` and the `amdvlk` package have been removed, as they have been deprecated by AMD. These have been replaced with the RADV driver from Mesa, which is enabled by default.

- `firezone` has changed how the `Everyone` group behaves. Service Accounts are no longer considered part of `Everyone`.

- `i18n.inputMethod.fcitx5.plasma6Support` has been removed because qt6 is the only one used for fcitx5-configtool now.

- Linux 5.4 and all its variants have been removed since mainline will reach its end of life within the support-span of 25.11.

- `miniflux` no longer uses the hstore PostgreSQL extension. Having the extension would prevent Miniflux from starting. In case you are managing your `miniflux` PostgreSQL database externally, disable the extension with `DROP EXTENSION IF EXISTS hstore;`.

- `netbox-manage` script created by the `netbox` module no longer uses `sudo -u netbox` internally. It can be run as root and will change it's user to `netbox` using `runuser`.

- NixOS display manager modules now strictly use tty1, where many of them previously used tty7. Options to configure display managers' VT have been dropped. A configuration with a display manager enabled will not start `getty@tty1.service`, even if the system is forced to boot into `multi-user.target` instead of `graphical.target`.

- `programs.cardboard` was removed due to the package having been broken since at least November 2024.

- `programs.goldwarden` has been removed, due to the software not working with newer versions of the Bitwarden and Vaultwarden servers, as well as it being abandoned upstream.

- `programs.skim.fuzzyCompletions` has been removed in favor of adding the completions to the package itself.

- `Prosody` has been updated to major release 13 which removed some obsoleted modules and brought a couple of major and breaking changes:
  - The `http_files` module is now disabled by default because it now requires `http_files_dir` to be configured.
  - The `vcard_muc` module has been removed and got replaced by the inbuilt `muc_vcard` module.
  - The `http_upload` module has been removed and you must migrate to the `http_file_share` module to stay XEP-0423 compliant. The `httpFileShare` options got expanded to better facility that.
  - The `admin_shell` module is now always being loaded to make `prosodyctl` functional.
  - The `mime_types_file` setting is now set to `"${pkgs.mailcap}/etc/mime.types"` to prevent errors.
  For a complete list of changes, please see [their announcement](https://blog.prosody.im/prosody-13.0.0-released/).

- `programs.river` has been renamed to `programs.river-classic` following an upstream decision.

- `services.chatgpt-retrieval-plugin` was removed due to the package having been broken since at least November 2024.

- `services.dwm-status.extraConfig` was replaced by [RFC0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md)-compliant [](#opt-services.dwm-status.settings), which is used to generate the config file. `services.dwm-status.order` is now moved to [](#opt-services.dwm-status.settings.order), as it's a part of the config file.

- `services.forgejo.dump.age` now defaults to `4w`, which deletes dumps older than 4 weeks. This new behaviour could result in older backups being deleted.

- `services.gateone` has been removed as the package was removed such that it does not work.

- `services.journald.gateway.user` and `services.journald.gateway.system` now defaults to `false`. This new behaviour matches the default behaviour of the [`systemd-journal-gatewayd`](https://www.freedesktop.org/software/systemd/man/latest/systemd-journal-gatewayd.service.html) service itself.

- `services.nextcloud.notify_push.enable` now installs the notify_push app. Therefore the appstore is now disabled when using `notify_push`. See `services.nextcloud.appstoreEnable`.

- `services.nixseparatedebuginfod.enable = true;` has been replaced by `services.nixseparatedebuginfod2.enable = true`. If you only use the official binary cache `https://cache.nixos.org` then no further configuration should be needed. If you have other https substituters, you can add them to `services.nixseparatedebuginfod2.subsituters`. SSH substituters are not supported by nixseparatedebuginfod2. Consider running nixseparatedebuginfod2 on the substituter instead, and pointing to it with the new option `environment.debuginfodServers`.

- `services.parsoid` and the `nodePackages.parsoid` package have been removed, as the JavaScript-based version this module uses is not compatible with modern MediaWiki versions.

- `services.private-gpt` has been removed by lack of maintenance upstream.

- `services.quorum` has been removed as the `quorum` package was broken and abandoned upstream.

- `services.seafile` has been removed, as it is unmaintained and outdated.
  See [the manual](https://manual.seafile.com/13.0/upgrade/upgrade_notes_for_13.0.x/#important-release-changes)
  for details and next steps.

- `services.tor.torsocks.enable` no longer defaults to true if Tor and Tor client functionality is enabled.

- The `boot.readOnlyNixStore` has been removed. Control over bind mount options on `/nix/store` is now offered by the `boot.nixStoreMountOpts` option.

- The `dovecot` systemd service was renamed from `dovecot2` to `dovecot`. The former is now just an alias. Update any overrides on the systemd unit to the new name.

- The `NIXOS_EXTRA_MODULE_PATH` variable from configuration evaluation has been deprecated.
  We recommend a workflow where you update the expression files instead, but if you wish to continue
  to use this variable, you may do so with a module like:

  ```nix
  {
    imports = [
      (builtins.getEnv "NIXOS_EXTRA_MODULE_PATH")
    ];
  }
  ```

  This has the benefit that your configuration hints at the non-standard workflow.

- The `file-roller` module has been removed due to not being required for function, file roller itself has also been removed from the `services.desktopManager.gnome` module as it's not part of GNOME core applications.

- The Perl implementation of the `switch-to-configuration` program is removed. All switchable systems now use the Rust rewrite. Any prior usage of `system.switch.enableNg` must now be removed. If you have any outstanding issues with the new implementation, please open an issue on GitHub.

- The Pocket ID module ([`services.pocket-id`](#opt-services.pocket-id.enable)) and package (`pocket-id`) has been updated to 1.0.0. Some environment variables have been changed or removed, see the [migration guide](https://pocket-id.org/docs/setup/migrate-to-v1/).

- The Postfix module has been updated and likely requires configuration changes:
  - The `services.postfix.sslCert` and `sslKey` options were removed and you now need to configure
    - [services.postfix.settings.main.smtpd_tls_chain_files](#opt-services.postfix.settings.main.smtpd_tls_chain_files) for server certificates,
    - [services.postfix.settings.main.smtp_tls_chain_files](#opt-services.postfix.settings.main) for client certificates.

- The `services.meilisearch` module now always defaults to the latest version of meilisearch, as the previous `meilisearch_1_11` package was removed. This is only an issue if you were using the old version.

- The `services.mysql` module now restarts the database `on-abnormal`, which means that it now will be restarted in certain situations, it wasn't before. For example an OOM-kill.

- The `services.nginx.sso` module has switched to generating its configuration
  file in `/run`. You should manually delete `/var/lib/nginx-sso/config.yaml` to
  avoid storing secret values to disk.

- The `services.postgresql` module now sets up a systemd unit `postgresql.target`. Depending on `postgresql.target` guarantees that postgres is in read-write mode and initial/ensure scripts were executed. Depending on `postgresql.service` only guarantees a read-only connection.

- The `services.polipo` module has been removed as `polipo` is unmaintained and archived upstream.

- The `services.postfixadmin` module has been removed due to a lack of active maintainers.

- The `services.siproxd` module has been removed as `siproxd` is unmaintained and broken with libosip 5.x.

- The `services.snapserver` module has been migrated to use the settings option and render a configuration file instead of passing every option over the command line.

- []{#sec-release-25.11-incompatibilities-sourcehut-removed} The `services.sourcehut` module and corresponding `sourcehut` packages were removed due to being broken and unmaintained.

- The `services.traccar.settings` attribute has been reworked. Instead of the previous flat attribute set the new implementation uses nested attribute sets. You need to update you configuration manually. For instance, `services.traccar.settings.loggerConsole` becomes `services.traccar.settings.logger.console`.

- The `services.tt-rss` module and package have been removed as upstream development ceased on 2025-11-01, and the source is no longer available officially.

- The systemd target `kbrequest.target` is now unset by default, instead of being forcibly symlinked to `rescue.target`. In case you were relying on this behavior (Alt + ArrowUp on the tty causing the current target to be changed to `rescue.target`), you can restore it by setting `systemd.targets.rescue.aliases = [ "kbrequest.target" ];` in your configuration.

- The `wstunnel` module was converted to RFC42-style settings, you will need to update your NixOS config if you make use of this module.

- `services.xserver.windowManager.yeahwm` was removed due to the package being broken and unmaintained upstream.

- The zookeeper project changed their logging tool to logback, therefore `services.zookeeper.logging` option has been updated to expect a logback compatible string.

- `virtualisation.lxd` has been removed due to lack of Nixpkgs maintenance. Users can migrate to `virtualisation.incus`, a fork of LXD, as a replacement. See [Incus migration documentation](https://linuxcontainers.org/incus/docs/main/howto/server_migrate_lxd/) for migration information.

- `virtualisation.libvirtd` now uses OVMF images shipped with QEMU for UEFI machines. `virtualisation.libvirtd.qemu.ovmf` has been removed.
  - OVMF images from underlying QEMU package are now made available under '/run/libvirt/nix-ovmf', fixing prior issues when using QEMU's automatic EFI firmware and feature handling, relied upon by GNOME Boxes, virsh, virt-manager, etc.
  - Domains that rely on automatic firmware and feature handling, i.e. `<os firmware='efi'>` need to trigger an update to `<loader>` and `<nvram>` entries.
    Using `virsh edit <domain>` and deleting aforementioned tags will cause libvirt to replace them with the new paths.
  - Configurations that relied on `virtualisation.libvirtd.qemu.ovmf` and had domains that did not use automatic firmware and feature handling, require a manual change to their domain configuration, updating `<loader>` and `<nvram>` entries from old path to the new path.
    | Old Path                               | New Path                                         |
    |----------------------------------------|--------------------------------------------------|
    | /run/libvirt/nix-ovmf/OVMF_CODE.fd     | /run/libvirt/nix-ovmf/edk2-x86_64-code.fd        |
    | /run/libvirt/nix-ovmf/OVMF_VARS.fd     | /run/libvirt/nix-ovmf/edk2-i386-vars.fd          |
    | /run/libvirt/nix-ovmf/OVMF_CODE.ms.fd  | /run/libvirt/nix-ovmf/edk2-x86_64-secure-code.fd |
    | /run/libvirt/nix-ovmf/OVMF_VARS.ms.fd  | /run/libvirt/nix-ovmf/edk2-i386-vars.fd          |
    | /run/libvirt/nix-ovmf/AAVMF_CODE.fd    | /run/libvirt/nix-ovmf/edk2-aarch64-code.fd       |
    | /run/libvirt/nix-ovmf/AAVMF_VARS.fd    | /run/libvirt/nix-ovmf/edk2-arm-vars.fd           |
    | /run/libvirt/nix-ovmf/AAVMF_CODE.ms.fd | /run/libvirt/nix-ovmf/edk2-aarch64-code.fd       |
    | /run/libvirt/nix-ovmf/AAVMF_VARS.ms.fd | /run/libvirt/nix-ovmf/edk2-arm-vars.fd           |

- `vmalert` now supports multiple instances with the option `services.vmalert.instances."".enable`

- [`virtualisation.waydroid.package`](#opt-virtualisation.waydroid.package) now defaults to `waydroid-nftables` on systems with nftables enabled.

- [`services.victorialogs.package`](#opt-services.victorialogs.package) now defaults to `victorialogs`, as `victoriametrics` no longer contains the VictoriaLogs binaries.

## Other Notable Changes {#sec-release-25.11-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- A new option [](#opt-boot.isNspawnContainer) has been added. This option will be used to guard nspawn-specific configuration in NixOS since [](#opt-boot.isContainer) is also used for different container-runtimes such as LXC.
  - The new option is automatically set to `true` by the declarative container module and `nixos-container` when not using flakes.
    - Existing setups can be migrated by running either
      - `nixos-container update <container-name> --config-file /path/to/the/config-file-in-use.nix`
      - `nixos-container update <container-name> --config '/* config code */'`
      - Setting the option by hand in your configuration when using flakes.
  - In all other cases, you'll need to set this option to `true` yourself.
  - `boot.isNspawnContainer` being `true` implies [](#opt-boot.isContainer) being `true`.

- `amdgpu` kernel driver overdrive mode can now be enabled by setting [hardware.amdgpu.overdrive.enable](#opt-hardware.amdgpu.overdrive.enable) and customized through [hardware.amdgpu.overdrive.ppfeaturemask](#opt-hardware.amdgpu.overdrive.ppfeaturemask).
  This allows for fine-grained control over the GPU's performance and maybe required by overclocking softwares like Corectrl and Lact. These new options replace old options such as {option}`programs.corectrl.gpuOverclock.enable` and {option}`programs.tuxclocker.enableAMD`.

- `bcachefs` file systems will now use the out-of-tree module for supported kernels. The in-tree module has been removed, and users will need to switch to kernels that support the out-of-tree module.

- `boot.plymouth` now has a [`package`](#opt-boot.plymouth.package) option to specify the package used in the module.

- Drivers and utlities for [Tenstorrent](https://tenstorrent.com) have been added. Available as [hardware.tenstorrent](#opt-hardware.tenstorrent.enable).

- Due to [deprecation of gnome-session X11 support](https://blogs.gnome.org/alatiera/2025/06/08/the-x11-session-removal/), `services.desktopManager.pantheon` now defaults to pantheon-wayland session. The X11 session has been removed, see [this issue](https://github.com/elementary/session-settings/issues/91) for details.

- `libvirt` now supports using `nftables` backend.
  - The `virtualisation.libvirtd.firewallBackend` option can be used to configure the firewall backend used by libvirtd.

- `linux_libre` & `linux_latest_libre` have been removed due to a lack of maintenance.

- Immich now has support for [VectorChord](https://github.com/tensorchord/VectorChord) when using the PostgreSQL configuration provided by `services.immich.database.enable`, which replaces `pgvecto-rs`. VectorChord support can be toggled with the option `services.immich.database.enableVectorChord`. Additionally, `pgvecto-rs` support is now disabled from NixOS 25.11 onwards using the option `services.immich.database.enableVectors`. This option will be removed fully in the future once Immich drops support for `pgvecto-rs` fully. See [Immich migration instructions](#module-services-immich-vectorchord-migration).

- It is now possible to configure the default source address using the new options [networking.defaultGateway.source](#opt-networking.defaultGateway.source),
  [networking.defaultGateway6.source](#opt-networking.defaultGateway6.source).

- mate-wayland-session 1.28.4 is now using the default wayfire decorator instead of firedecor, thus `services.xserver.desktopManager.mate.enableWaylandSession` is no longer shipping firedecor. If you are experiencing broken window decorations after upgrade, backup and remove `~/.config/mate/wayfire.ini` and re-login.

- `networking.wireless.networks.<name>` now has an option to specify SSID, hence allowing duplicated SSID setup. The BSSID option is added alongside with this.

- Options under [networking.getaddrinfo](#opt-networking.getaddrinfo.enable) are now allowed to declaratively configure address selection and sorting behavior of `getaddrinfo` in dual-stack networks.

- Potential race conditions in the network setup when using `networking.interfaces` have been fixed by disabling duplicate address detection (DAD)
  for statically configured IPv6 addresses.

- `prosody` gained a config check option named `services.prosody.checkConfig` which runs `prosodyctl check config` and is turned on by default.

- Revamp of the ACME certificate acquisition and renewal process to help scale systems with lots (100+) of certificates.

  Units and targets have been reshaped to better support more specific dependency propagation and avoid
  superfluously triggering unchanged units:

  If a service requires a syntactically valid certificate to start it should now depend on the `acme-{certname}.service` unit.

  We now always generate initial self-signed certificates as this drastically simplifies the dependency structure. As a result, the option `security.acme.preliminarySelfsigned` has been removed.

  Instead of the previous `acme-finished-{certname}.target`s there are now `acme-order-renew-{certname}.service`s that will be activated
  in a delayed fashion to ensure that bootstrapping with servers like nginx that take part in the acquisition/renewal process works
  smoothly. Dependencies on `acme-finished` units should move to `acme-order-renew`.

  Note that system activation will complete before all certificates may have been renewed or acquired.

- `services.clamsmtp` is unmaintained and was removed from Nixpkgs.

- `services.clickhouse` has added the `serverConfig` and `userConfig` options. You may also use `extraServerConfig` and `extraUserConfig` to pass plain text XML.

- `services.dependency-track` removed its configuration of the JVM heap size. This lets the JVM choose its maximum heap size automatically, which should work much better in practice for most users. For deployments on systems with little RAM, it may now be necessary to manually configure a maximum heap size using  {option}`services.dependency-track.javaArgs`.

- `services.dnscrypt-proxy2` was renamed to `services.dnscrypt-proxy` to match the package name. The systemd service is now also `dnscrypt-proxy`, but the old name is still provided as an alias for backwards compatibility.

- `services.dnscrypt-proxy` gains a `package` option to specify dnscrypt-proxy package to use.

- `services.eris-server` was removed from Nixpkgs due to a hostile upstream.

- `services.filesender` and the package `filesender` have been removed because they depend on `simplesamlphp`.

- `services.gitea` supports sending notifications with sendmail again. To do this, activate the parameter `services.gitea.mailerUseSendmail` and configure SMTP server.

- [services.gnome.gnome-keyring](#opt-services.gnome.gnome-keyring.enable) does not ship with an SSH agent anymore, as this is now handled by the `gcr_4` package instead of `gnome-keyring`. A new module has been added to support this, under [](#opt-services.gnome.gcr-ssh-agent.enable) (its default value has been set to [](#opt-services.gnome.gnome-keyring.enable) to ensure a smooth transition). See the [relevant upstream PR](https://gitlab.gnome.org/GNOME/gcr/-/merge_requests/67) for more details.

- `services.grafana` does no longer send usage statistics by default.

- `services.k3s` now shares most of its code with `services.rke2`. The merge resulted in both modules providing more options, with `services.rke2` receiving the most improvements.
  Existing configurations for either module should not be affected.

- [services.libvirtd.autoSnapshot](options.html#opt-services.libvirtd.autoSnapshot.enable) has been added as a backup service for libvirt managed VMs.

- `services.limesurvey` now supports nginx as reverse-proxy. Available through [services.limesurvey.webserver](#opt-services.limesurvey.webserver).

- `services.mattermost` has been updated to use the 10.11 ESR instead of 10.5. While this shouldn't break anyone, we also now package Mattermost 11 as mattermostLatest. Note that Mattermost 11 drops support for MySQL. The Mattermost module will assertion fail if you try to use MySQL with Mattermost 11; support for using MySQL with Mattermost will fully be removed in NixOS 26.

- `services.matter-server` now hosts a debug dashboard on the configured port. Open the port on the firewall with `services.matter-server.openFirewall`.

- `services.monero` now includes the `environmentFile` option for adding secrets to the Monero daemon config.

- `services.nebula.networks.<name>` will now store configuration files in `/etc/nebula/<name>.yml` and supports config reloading.

- `services.logind.extraConfig` was converted to RFC42-style `services.logind.settings.Login`.

- `services.nginx.recommendedProxySettings` now sets `X-Forwarded-Server` to the hostname of nginx instead of the original host.

- `services.netbird.server` now uses dedicated packages split out due to relicensing of server components to AGPLv3 with version `0.53.0`,

- `services.nextcloud.configureRedis` now defaults to `true` in accordance with upstream recommendations to have caching for file locking. See the [upstream doc](https://docs.nextcloud.com/server/31/admin_manual/configuration_files/files_locking_transactional.html) for further details.

- `services.ntpd-rs` now performs configuration validation.

- `services.opentelemetry-collector` has a new option `validateConfigFile` option that checks the configuration file during build. It is enabled by default if the configuration file is in the Nix store.

- `services.restic.backups` now includes a `command` option for passing a command to the [--stdin-from-command](https://github.com/restic/restic/pull/4410) flag.

- `services.pds` has been renamed to `services.bluesky-pds`.

- `services.pfix-srsd` now automatically integrates with the local Postfix instance, when enabled. This behavior can disabled using the [services.pfix-srsd.configurePostfix](#opt-services.pfix-srsd.configurePostfix) option.

- `services.postsrsd` now automatically integrates with the local Postfix instance, when enabled. This behavior can disabled using the [services.postsrsd.configurePostfix](#opt-services.postsrsd.configurePostfix) option.

- `services.varnish.http_address` has been superseeded by `services.varnish.listen` which is now
  structured config for all of varnish's `-a` variations.

- `services.xserver.desktopManager.deepin` and associated packages have been removed due to being unmaintained. See issue [#422090](https://github.com/NixOS/nixpkgs/issues/422090) for more details.

- `systemd.extraConfig` and `boot.initrd.systemd.extraConfig` was converted to RFC42-style `systemd.settings.Manager` and `boot.initrd.systemd.settings.Manager` respectively.
  - `systemd.watchdog.runtimeTime` was renamed to `systemd.settings.Manager.RuntimeWatchdogSec`
  - `systemd.watchdog.device` was renamed to `systemd.settings.Manager.WatchdogDevice`
  - `systemd.watchdog.rebootTime` was renamed to `systemd.settings.Manager.RebootWatchdogSec`
  - `systemd.watchdog.kexecTime` was renamed to `systemd.settings.Manager.KExecWatchdogSec`
  - `systemd.enableCgroupAccounting` was removed. Cgroup accounting now needs to be disabled directly using `systemd.settings.Manager.*Accounting`.

- The `ksycoca` cache in Plasma 6 will no longer be re-built when `$XDG_CACHE_HOME` is not set to `$HOME/.cache`.

- The latest available version of Nextcloud is v32 (available as `pkgs.nextcloud32`). The installation logic is as follows:
  - If [`services.nextcloud.package`](#opt-services.nextcloud.package) is specified explicitly, this package will be installed (**recommended**)
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=25.05, `pkgs.nextcloud32` will be installed by default.
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=24.11, `pkgs.nextcloud31` will be installed by default.
  - `nextcloud30` is EOL and was thus removed.
  - Please note that an upgrade from v30 (or older) to v32 directly is not possible. Please upgrade to `nextcloud31` (or earlier) first. Nextcloud prohibits skipping major versions while upgrading. You can upgrade by declaring [`services.nextcloud.package = pkgs.nextcloud30;`](#opt-services.nextcloud.package).

- The `nettools` package (ifconfig, arp, mii-tool, netstat, route) is not installed by default anymore. The suite is unmaintained and users should migrate to `iproute2` and `ethtool` instead.

- The new option [networking.ipips](#opt-networking.ipips) has been added to create IP within IP kind of tunnels (including 4in6, ip6ip6 and ipip).
  With the existing [networking.sits](#opt-networking.sits) option (6in4), it is now possible to create all combinations of IPv4 and IPv6 encapsulation.

- [tpm2-totp](https://github.com/tpm2-software/tpm2-totp) can now be used to show a TOTP during boot using Plymouth. Available as [boot.plymouth.tpm2-totp](#opt-boot.plymouth.tpm2-totp.enable).

- `users.users.*.linger` now defaults to `null` rather than `false`, meaning NixOS will not attempt to enable or disable lingering for that user account, instead allowing for imperative control over lingering using the `loginctl` commands. In practice, this is unlikely to make a difference for most people, as new users are created without lingering configured. There is a new, related option, `users.manageLingering`, which can be used to prevent NixOS attempting to manage lingering entirely.
