# Release 20.09 ("Nightingale", 2020.10/27) {#sec-release-20.09}

Support is planned until the end of June 2021, handing over to 21.05. (Plans [ have shifted](https://github.com/NixOS/rfcs/blob/master/rfcs/0080-nixos-release-schedule.md#core-changes) by two months since release of 20.09.)

## Highlights {#sec-release-20.09-highlights}

In addition to 7349 new, 14442 updated, and 8181 removed packages, this release has the following highlights:

- Core version changes:

  - gcc: 9.2.0 -\> 9.3.0

  - glibc: 2.30 -\> 2.31

  - linux: still defaults to 5.4.x, all supported kernels available

  - mesa: 19.3.5 -\> 20.1.7

- Desktop Environments:

  - plasma5: 5.17.5 -\> 5.18.5

  - kdeApplications: 19.12.3 -\> 20.08.1

  - gnome3: 3.34 -\> 3.36, see its [release notes](https://help.gnome.org/misc/release-notes/3.36/)

  - cinnamon: added at 4.6

  - NixOS now distributes an official [GNOME ISO](https://nixos.org/download.html#nixos-iso)

- Programming Languages and Frameworks:

  - Agda ecosystem was heavily reworked (see more details below)

  - PHP now defaults to PHP 7.4, updated from 7.3

  - PHP 7.2 is no longer supported due to upstream not supporting this version for the entire lifecycle of the 20.09 release

  - Python 3 now defaults to Python 3.8 instead of 3.7

  - Python 3.5 reached its upstream EOL at the end of September 2020: it has been removed from the list of available packages

- Databases and Service Monitoring:

  - MariaDB has been updated to 10.4, MariaDB Galera to 26.4. Please read the related upgrade instructions under [backwards incompatibilities](#sec-release-20.09-incompatibilities) before upgrading.

  - Zabbix now defaults to 5.0, updated from 4.4. Please read related sections under [backwards compatibilities](#sec-release-20.09-incompatibilities) before upgrading.

- Major module changes:

  - Quickly configure a complete, private, self-hosted video conferencing solution with the new Jitsi Meet module.

  - Two new options, [authorizedKeysCommand](options.html#opt-services.openssh.authorizedKeysCommand) and [authorizedKeysCommandUser](options.html#opt-services.openssh.authorizedKeysCommandUser), have been added to the `openssh` module. If you have `AuthorizedKeysCommand` in your [services.openssh.extraConfig](options.html#opt-services.openssh.extraConfig) you should make use of these new options instead.

  - There is a new module for Podman (`virtualisation.podman`), a drop-in replacement for the Docker command line.

  - The new `virtualisation.containers` module manages configuration shared by the CRI-O and Podman modules.

  - Declarative Docker containers are renamed from `docker-containers` to `virtualisation.oci-containers.containers`. This is to make it possible to use `podman` instead of `docker`.

  - The new option [documentation.man.generateCaches](options.html#opt-documentation.man.generateCaches) has been added to automatically generate the `man-db` caches, which are needed by utilities like `whatis` and `apropos`. The caches are generated during the build of the NixOS configuration: since this can be expensive when a large number of packages are installed, the feature is disabled by default.

  - `services.postfix.sslCACert` was replaced by `services.postfix.tlsTrustedAuthorities` which now defaults to system certificate authorities.

  - The various documented workarounds to use steam have been converted to a module. `programs.steam.enable` enables steam, controller support and the workarounds.

  - Support for built-in LCDs in various pieces of Logitech hardware (keyboards and USB speakers). `hardware.logitech.lcd.enable` enables support for all hardware supported by the [g15daemon project](https://sourceforge.net/projects/g15daemon/).

  - The GRUB module gained support for basic password protection, which allows to restrict non-default entries in the boot menu to one or more users. The users and passwords are defined via the option `boot.loader.grub.users`. Note: Password support is only available in GRUB version 2.

- NixOS module changes:

  - The NixOS module system now supports freeform modules as a mix between `types.attrsOf` and `types.submodule`. These allow you to explicitly declare a subset of options while still permitting definitions without an associated option. See [](#sec-freeform-modules) for how to use them.

  - Following its deprecation in 20.03, the Perl NixOS test driver has been removed. All remaining tests have been ported to the Python test framework. Code outside nixpkgs using `make-test.nix` or `testing.nix` needs to be ported to `make-test-python.nix` and `testing-python.nix` respectively.

  - Subordinate GID and UID mappings are now set up automatically for all normal users. This will make container tools like Podman work as non-root users out of the box.

- Starting with this release, the hydra-build-result `nixos-YY.MM` branches no longer exist in the [deprecated nixpkgs-channels repository](https://github.com/nixos/nixpkgs-channels). These branches are now in [the main nixpkgs repository](https://github.com/nixos/nixpkgs).

## New Services {#sec-release-20.09-new-services}

In addition to 1119 new, 118 updated, and 476 removed options; 61 new modules were added since the last release:

- Hardware:

  - [hardware.system76.firmware-daemon.enable](options.html#opt-hardware.system76.firmware-daemon.enable) adds easy support of system76 firmware

  - [hardware.uinput.enable](options.html#opt-hardware.uinput.enable) loads uinput kernel module

  - [hardware.video.hidpi.enable](options.html#opt-hardware.video.hidpi.enable) enable good defaults for HiDPI displays

  - [hardware.wooting.enable](options.html#opt-hardware.wooting.enable) support for Wooting keyboards

  - [hardware.xpadneo.enable](options.html#opt-hardware.xpadneo.enable) xpadneo driver for Xbox One wireless controllers

- Programs:

  - [programs.hamster.enable](options.html#opt-programs.hamster.enable) enable hamster time tracking

  - [programs.steam.enable](options.html#opt-programs.steam.enable) adds easy enablement of steam and related system configuration

- Security:

  - [security.doas.enable](options.html#opt-security.doas.enable) alternative to sudo, allows non-root users to execute commands as root

  - [security.tpm2.enable](options.html#opt-security.tpm2.enable) add Trusted Platform Module 2 support

- System:

  - [boot.initrd.network.openvpn.enable](options.html#opt-boot.initrd.network.openvpn.enable) start an OpenVPN client during initrd boot

- Virtualization:

  - [boot.enableContainers](options.html#opt-boot.enableContainers) use nixos-containers

  - [virtualisation.oci-containers.containers](options.html#opt-virtualisation.oci-containers.containers) run OCI (Docker) containers

  - [virtualisation.podman.enable](options.html#opt-virtualisation.podman.enable) daemonless container engine

- Services:

  - `services.ankisyncd.enable` Anki sync server

  - [services.bazarr.enable](options.html#opt-services.bazarr.enable) Subtitle manager for Sonarr and Radarr

  - [services.biboumi.enable](options.html#opt-services.biboumi.enable) Biboumi XMPP gateway to IRC

  - [services.blockbook-frontend](options.html#opt-services.blockbook-frontend) Blockbook-frontend, a service for the Trezor wallet

  - [services.cage.enable](options.html#opt-services.cage.enable) Wayland cage service

  - [services.convos.enable](options.html#opt-services.convos.enable) IRC daemon, which can be accessed through the browser

  - [services.engelsystem.enable](options.html#opt-services.engelsystem.enable) Tool for coordinating volunteers and shifts on large events

  - [services.espanso.enable](options.html#opt-services.espanso.enable) text-expander written in rust

  - [services.foldingathome.enable](options.html#opt-services.foldingathome.enable) Folding\@home client

  - [services.gerrit.enable](options.html#opt-services.gerrit.enable) Web-based team code collaboration tool

  - [services.go-neb.enable](options.html#opt-services.go-neb.enable) Matrix bot

  - [services.hardware.xow.enable](options.html#opt-services.hardware.xow.enable) xow as a systemd service

  - [services.hercules-ci-agent.enable](options.html#opt-services.hercules-ci-agent.enable) Hercules CI build agent

  - [services.jicofo.enable](options.html#opt-services.jicofo.enable) Jitsi Conference Focus, component of Jitsi Meet

  - [services.jirafeau.enable](options.html#opt-services.jirafeau.enable) A web file repository

  - [services.jitsi-meet.enable](options.html#opt-services.jitsi-meet.enable) Secure, simple and scalable video conferences

  - [services.jitsi-videobridge.enable](options.html#opt-services.jitsi-videobridge.enable) Jitsi Videobridge, a WebRTC compatible router

  - [services.jupyterhub.enable](options.html#opt-services.jupyterhub.enable) Jupyterhub development server

  - [services.k3s.enable](options.html#opt-services.k3s.enable) Lightweight Kubernetes distribution

  - [services.magic-wormhole-mailbox-server.enable](options.html#opt-services.magic-wormhole-mailbox-server.enable) Magic Wormhole Mailbox Server

  - [services.malcontent.enable](options.html#opt-services.malcontent.enable) Parental Control support

  - [services.matrix-appservice-discord.enable](options.html#opt-services.matrix-appservice-discord.enable) Matrix and Discord bridge

  - [services.mautrix-telegram.enable](options.html#opt-services.mautrix-telegram.enable) Matrix-Telegram puppeting/relaybot bridge

  - [services.mirakurun.enable](options.html#opt-services.mirakurun.enable) Japanese DTV Tuner Server Service

  - [services.molly-brown.enable](options.html#opt-services.molly-brown.enable) Molly-Brown Gemini server

  - [services.mullvad-vpn.enable](options.html#opt-services.mullvad-vpn.enable) Mullvad VPN daemon

  - [services.ncdns.enable](options.html#opt-services.ncdns.enable) Namecoin to DNS bridge

  - [services.nextdns.enable](options.html#opt-services.nextdns.enable) NextDNS to DoH Proxy service

  - [services.nix-store-gcs-proxy](options.html#opt-services.nix-store-gcs-proxy) Google storage bucket to be used as a nix store

  - [services.onedrive.enable](options.html#opt-services.onedrive.enable) OneDrive sync service

  - [services.pinnwand.enable](options.html#opt-services.pinnwand.enable) Pastebin-like service

  - [services.pixiecore.enable](options.html#opt-services.pixiecore.enable) Manage network booting of machines

  - [services.privacyidea.enable](options.html#opt-services.privacyidea.enable) Privacy authentication server

  - [services.quorum.enable](options.html#opt-services.quorum.enable) Quorum blockchain daemon

  - [services.robustirc-bridge.enable](options.html#opt-services.robustirc-bridge.enable) RobustIRC bridge

  - [services.rss-bridge.enable](options.html#opt-services.rss-bridge.enable) Generate RSS and Atom feeds

  - [services.rtorrent.enable](options.html#opt-services.rtorrent.enable) rTorrent service

  - [services.smartdns.enable](options.html#opt-services.smartdns.enable) SmartDNS DNS server

  - [services.sogo.enable](options.html#opt-services.sogo.enable) SOGo groupware

  - [services.teeworlds.enable](options.html#opt-services.teeworlds.enable) Teeworlds game server

  - [services.torque.mom.enable](options.html#opt-services.torque.mom.enable) torque computing node

  - [services.torque.server.enable](options.html#opt-services.torque.server.enable) torque server

  - [services.tuptime.enable](options.html#opt-services.tuptime.enable) A total uptime service

  - [services.urserver.enable](options.html#opt-services.urserver.enable) X11 remote server

  - [services.wasabibackend.enable](options.html#opt-services.wasabibackend.enable) Wasabi backend service

  - [services.yubikey-agent.enable](options.html#opt-services.yubikey-agent.enable) Yubikey agent

  - [services.zigbee2mqtt.enable](options.html#opt-services.zigbee2mqtt.enable) Zigbee to MQTT bridge

## Backward Incompatibilities {#sec-release-20.09-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- MariaDB has been updated to 10.4, MariaDB Galera to 26.4. Before you upgrade, it would be best to take a backup of your database. For MariaDB Galera Cluster, see [Upgrading from MariaDB 10.3 to MariaDB 10.4 with Galera Cluster](https://mariadb.com/kb/en/upgrading-from-mariadb-103-to-mariadb-104-with-galera-cluster/) instead. Before doing the upgrade read [Incompatible Changes Between 10.3 and 10.4](https://mariadb.com/kb/en/upgrading-from-mariadb-103-to-mariadb-104/#incompatible-changes-between-103-and-104). After the upgrade you will need to run `mysql_upgrade`. MariaDB 10.4 introduces a number of changes to the authentication process, intended to make things easier and more intuitive. See [Authentication from MariaDB 10.4](https://mariadb.com/kb/en/authentication-from-mariadb-104/). unix_socket auth plugin does not use a password, and uses the connecting user's UID instead. When a new MariaDB data directory is initialized, two MariaDB users are created and can be used with new unix_socket auth plugin, as well as traditional mysql_native_password plugin: root\@localhost and mysql\@localhost. To actually use the traditional mysql_native_password plugin method, one must run the following:

  ```nix
  {
    services.mysql.initialScript = pkgs.writeText "mariadb-init.sql" ''
      ALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING PASSWORD("verysecret");
    '';
  }
  ```

  When MariaDB data directory is just upgraded (not initialized), the users are not created or modified.

- MySQL server is now started with additional systemd sandbox/hardening options for better security. The PrivateTmp, ProtectHome, and ProtectSystem options may be problematic when MySQL is attempting to read from or write to your filesystem anywhere outside of its own state directory, for example when calling `LOAD DATA INFILE or SELECT * INTO OUTFILE`. In this scenario a variant of the following may be required: - allow MySQL to read from /home and /tmp directories when using `LOAD DATA INFILE`

  ```nix
  { systemd.services.mysql.serviceConfig.ProtectHome = lib.mkForce "read-only"; }
  ```

  \- allow MySQL to write to custom folder `/var/data` when using `SELECT * INTO OUTFILE`, assuming the mysql user has write access to `/var/data`

  ```nix
  { systemd.services.mysql.serviceConfig.ReadWritePaths = [ "/var/data" ]; }
  ```

  The MySQL service no longer runs its `systemd` service startup script as `root` anymore. A dedicated non `root` super user account is required for operation. This means users with an existing MySQL or MariaDB database server are required to run the following SQL statements as a super admin user before upgrading:

  ```SQL
  CREATE USER IF NOT EXISTS 'mysql'@'localhost' identified with unix_socket;
  GRANT ALL PRIVILEGES ON *.* TO 'mysql'@'localhost' WITH GRANT OPTION;
  ```

  If you use MySQL instead of MariaDB please replace `unix_socket` with `auth_socket`. If you have changed the value of [services.mysql.user](options.html#opt-services.mysql.user) from the default of `mysql` to a different user please change `'mysql'@'localhost'` to the corresponding user instead.

- Zabbix now defaults to 5.0, updated from 4.4. Please carefully read through [the upgrade guide](https://www.zabbix.com/documentation/current/manual/installation/upgrade/sources) and apply any changes required. Be sure to take special note of the section on [enabling extended range of numeric (float) values](https://www.zabbix.com/documentation/current/manual/installation/upgrade_notes_500#enabling_extended_range_of_numeric_float_values) as you will need to apply this database migration manually.

  If you are using Zabbix Server with a MySQL or MariaDB database you should note that using a character set of `utf8` and a collate of `utf8_bin` has become mandatory with this release. See the upstream [issue](https://support.zabbix.com/browse/ZBX-17357) for further discussion. Before upgrading you should check the character set and collation used by your database and ensure they are correct:

  ```SQL
  SELECT
    default_character_set_name,
    default_collation_name
  FROM
    information_schema.schemata
  WHERE
    schema_name = 'zabbix';
  ```

  If these values are not correct you should take a backup of your database and convert the character set and collation as required. Here is an [example](https://www.zabbix.com/forum/zabbix-help/396573-reinstall-after-upgrade?p=396891#post396891) of how to do so, taken from the Zabbix forums:

  ```SQL
  ALTER DATABASE `zabbix` DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;

  -- the following will produce a list of SQL commands you should subsequently execute
  SELECT CONCAT("ALTER TABLE ", TABLE_NAME," CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;") AS ExecuteTheString
  FROM information_schema.`COLUMNS`
  WHERE table_schema = "zabbix" AND COLLATION_NAME = "utf8_general_ci";
  ```

- maxx package removed along with `services.xserver.desktopManager.maxx` module. Please migrate to cdesktopenv and `services.xserver.desktopManager.cde` module.

- The [matrix-synapse](options.html#opt-services.matrix-synapse.enable) module no longer includes optional dependencies by default, they have to be added through the [plugins](options.html#opt-services.matrix-synapse.plugins) option.

- `buildGoModule` now internally creates a vendor directory in the source tree for downloaded modules instead of using go's [module proxy protocol](https://golang.org/cmd/go/#hdr-Module_proxy_protocol). This storage format is simpler and therefore less likely to break with future versions of go. As a result `buildGoModule` switched from `modSha256` to the `vendorSha256` attribute to pin fetched version data.

- Grafana is now built without support for phantomjs by default. Phantomjs support has been [deprecated in Grafana](https://grafana.com/docs/grafana/latest/guides/whats-new-in-v6-4/) and the phantomjs project is [currently unmaintained](https://github.com/ariya/phantomjs/issues/15344#issue-302015362). It can still be enabled by providing `phantomJsSupport = true` to the package instantiation:

  ```nix
  {
    services.grafana.package = pkgs.grafana.overrideAttrs (oldAttrs: rec {
      phantomJsSupport = true;
    });
  }
  ```

- The [supybot](options.html#opt-services.supybot.enable) module now uses `/var/lib/supybot` as its default [stateDir](options.html#opt-services.supybot.stateDir) path if `stateVersion` is 20.09 or higher. It also enables a number of [systemd sandboxing options](https://www.freedesktop.org/software/systemd/man/systemd.exec.html#Sandboxing) which may possibly interfere with some plugins. If this is the case you can disable the options through attributes in `systemd.services.supybot.serviceConfig`.

- The `security.duosec.skey` option, which stored a secret in the nix store, has been replaced by a new [security.duosec.secretKeyFile](options.html#opt-security.duosec.secretKeyFile) option for better security.

  `security.duosec.ikey` has been renamed to [security.duosec.integrationKey](options.html#opt-security.duosec.integrationKey).

- `vmware` has been removed from the `services.x11.videoDrivers` defaults. For VMWare guests set `virtualisation.vmware.guest.enable` to `true` which will include the appropriate drivers.

- The initrd SSH support now uses OpenSSH rather than Dropbear to allow the use of Ed25519 keys and other OpenSSH-specific functionality. Host keys must now be in the OpenSSH format, and at least one pre-generated key must be specified.

  If you used the `boot.initrd.network.ssh.host*Key` options, you'll get an error explaining how to convert your host keys and migrate to the new `boot.initrd.network.ssh.hostKeys` option. Otherwise, if you don't have any host keys set, you'll need to generate some; see the `hostKeys` option documentation for instructions.

- Since this release there's an easy way to customize your PHP install to get a much smaller base PHP with only wanted extensions enabled. See the following snippet installing a smaller PHP with the extensions `imagick`, `opcache`, `pdo` and `pdo_mysql` loaded:

  ```nix
  {
    environment.systemPackages = [
      (pkgs.php.withExtensions (
        { all, ... }:
        with all;
        [
          imagick
          opcache
          pdo
          pdo_mysql
        ]
      ))
    ];
  }
  ```

  The default `php` attribute hasn't lost any extensions. The `opcache` extension has been added. All upstream PHP extensions are available under php.extensions.\<name?\>.

  All PHP `config` flags have been removed for the following reasons:

- The updated `php` attribute is now easily customizable to your liking by using `php.withExtensions` or `php.buildEnv` instead of writing config files or changing configure flags.

- The remaining configuration flags can now be set directly on the `php` attribute. For example, instead of

  ```nix
  php.override {
    config.php.embed = true;
    config.php.apxs2 = false;
  }
  ```

  you should now write

  ```nix
  php.override {
    embedSupport = true;
    apxs2Support = false;
  }
  ```

- The ACME module has been overhauled for simplicity and maintainability. Cert generation now implicitly uses the `acme` user, and the `security.acme.certs._name_.user` option has been removed. Instead, certificate access from other services is now managed through group permissions. The module no longer runs lego twice under certain conditions, and will correctly renew certificates if their configuration is changed. Services which reload nginx and httpd after certificate renewal are now properly configured too so you no longer have to do this manually if you are using HTTPS enabled virtual hosts. A mechanism for regenerating certs on demand has also been added and documented.

- Gollum received a major update to version 5.x and you may have to change some links in your wiki when migrating from gollum 4.x. More information can be found [here](https://github.com/gollum/gollum/wiki/5.0-release-notes#migrating-your-wiki).

- Deluge 2.x was added and is used as default for new NixOS installations where stateVersion is \>= 20.09. If you are upgrading from a previous NixOS version, you can set `service.deluge.package = pkgs.deluge-2_x` to upgrade to Deluge 2.x and migrate the state to the new format. Be aware that backwards state migrations are not supported by Deluge.

- Nginx web server now starting with additional sandbox/hardening options. By default, write access to `/var/log/nginx` and `/var/cache/nginx` is allowed. To allow writing to other folders, use `systemd.services.nginx.serviceConfig.ReadWritePaths`

  ```nix
  { systemd.services.nginx.serviceConfig.ReadWritePaths = [ "/var/www" ]; }
  ```

  Nginx is also started with the systemd option `ProtectHome = mkDefault true;` which forbids it to read anything from `/home`, `/root` and `/run/user` (see [ProtectHome docs](https://www.freedesktop.org/software/systemd/man/systemd.exec.html#ProtectHome=) for details). If you require serving files from home directories, you may choose to set e.g.

  ```nix
  { systemd.services.nginx.serviceConfig.ProtectHome = "read-only"; }
  ```

- The NixOS options `nesting.clone` and `nesting.children` have been deleted, and replaced with named [specialisation](options.html#opt-specialisation) configurations.

  Replace a `nesting.clone` entry with:

  ```nix
  {
    specialisation.example-sub-configuration = {
      configuration = {
        # ...
      };
    };
  }
  ```

  Replace a `nesting.children` entry with:

  ```nix
  {
    specialisation.example-sub-configuration = {
      inheritParentConfig = false;
      configuration = {
        # ...
      };
    };
  }
  ```

  To switch to a specialised configuration at runtime you need to run:

  ```ShellSession
  $ sudo /run/current-system/specialisation/example-sub-configuration/bin/switch-to-configuration test
  ```

  Before you would have used:

  ```ShellSession
  $ sudo /run/current-system/fine-tune/child-1/bin/switch-to-configuration test
  ```

- The Nginx log directory has been moved to `/var/log/nginx`, the cache directory to `/var/cache/nginx`. The option `services.nginx.stateDir` has been removed.

- The httpd web server previously started its main process as root privileged, then ran worker processes as a less privileged identity user. This was changed to start all of httpd as a less privileged user (defined by [services.httpd.user](options.html#opt-services.httpd.user) and [services.httpd.group](options.html#opt-services.httpd.group)). As a consequence, all files that are needed for httpd to run (included configuration fragments, SSL certificates and keys, etc.) must now be readable by this less privileged user/group.

  The default value for [services.httpd.mpm](options.html#opt-services.httpd.mpm) has been changed from `prefork` to `event`. Along with this change the default value for [services.httpd.virtualHosts.\<name\>.http2](options.html#opt-services.httpd.virtualHosts) has been set to `true`.

- The `systemd-networkd` option `systemd.network.networks.<name>.dhcp.CriticalConnection` has been removed following upstream systemd's deprecation of the same. It is recommended to use `systemd.network.networks.<name>.networkConfig.KeepConfiguration` instead. See systemd.network 5 for details.

- The `systemd-networkd` option `systemd.network.networks._name_.dhcpConfig` has been renamed to [systemd.network.networks._name_.dhcpV4Config](options.html#opt-systemd.network.networks._name_.dhcpV4Config) following upstream systemd's documentation change. See systemd.network 5 for details.

- In the `picom` module, several options that accepted floating point numbers encoded as strings (for example [services.picom.activeOpacity](options.html#opt-services.picom.activeOpacity)) have been changed to the (relatively) new native `float` type. To migrate your configuration remove the quotes around the numbers.

- When using `buildBazelPackage` from Nixpkgs, `flat` hash mode is now used for dependencies instead of `recursive`. This is to better allow using hashed mirrors where needed. As a result, these hashes will have changed.

- The syntax of the PostgreSQL configuration file is now checked at build time. If your configuration includes a file inaccessible inside the build sandbox, set `services.postgresql.checkConfig` to `false`.

- The rkt module has been removed, it was archived by upstream.

- The [Bazaar](https://bazaar.canonical.com) VCS is unmaintained and, as consequence of the Python 2 EOL, the packages `bazaar` and `bazaarTools` were removed. Breezy, the backward compatible fork of Bazaar (see the [announcement](https://www.jelmer.uk/breezy-intro.html)), was packaged as `breezy` and can be used instead.

  Regarding Nixpkgs, `fetchbzr`, `nix-prefetch-bzr` and Bazaar support in Hydra will continue to work through Breezy.

- In addition to the hostname, the fully qualified domain name (FQDN), which consists of `${networking.hostName}` and `${networking.domain}` is now added to `/etc/hosts`, to allow local FQDN resolution, as used by the `hostname --fqdn` command and other applications that try to determine the FQDN. These new entries take precedence over entries from the DNS which could cause regressions in some very specific setups. Additionally the hostname is now resolved to `127.0.0.2` instead of `127.0.1.1` to be consistent with what `nss-myhostname` (from systemd) returns. The old behaviour can e.g. be restored by using `networking.hosts = lib.mkForce { "127.0.1.1" = [ config.networking.hostName ]; };`.

- The hostname (`networking.hostName`) must now be a valid DNS label (see RFC 1035, RFC 1123) and as such must not contain the domain part. This means that the hostname must start with a letter or digit, end with a letter or digit, and have as interior characters only letters, digits, and hyphen. The maximum length is 63 characters. Additionally it is recommended to only use lower-case characters. If (e.g. for legacy reasons) a FQDN is required as the Linux kernel network node hostname (`uname --nodename`) the option `boot.kernel.sysctl."kernel.hostname"` can be used as a workaround (but be aware of the 64 character limit).

- The GRUB specific option `boot.loader.grub.extraInitrd` has been replaced with the generic option `boot.initrd.secrets`. This option creates a secondary initrd from the specified files, rather than using a manually created initrd file. Due to an existing bug with `boot.loader.grub.extraInitrd`, it is not possible to directly boot an older generation that used that option. It is still possible to rollback to that generation if the required initrd file has not been deleted.

- The [DNSChain](https://github.com/okTurtles/dnschain) package and NixOS module have been removed from Nixpkgs as the software is unmaintained and can't be built. For more information see issue [\#89205](https://github.com/NixOS/nixpkgs/issues/89205).

- In the `resilio` module, [services.resilio.httpListenAddr](options.html#opt-services.resilio.httpListenAddr) has been changed to listen to `[::1]` instead of `0.0.0.0`.

- `sslh` has been updated to version `1.21`. The `ssl` probe must be renamed to `tls` in [services.sslh.appendConfig](options.html#opt-services.sslh.appendConfig).

- Users of [OpenAFS 1.6](http://openafs.org) must upgrade their services to OpenAFS 1.8! In this release, the OpenAFS package version 1.6.24 is marked broken but can be used during transition to OpenAFS 1.8.x. Use the options `services.openafsClient.packages.module`, `services.openafsClient.packages.programs` and `services.openafsServer.package` to select a different OpenAFS package. OpenAFS 1.6 will be removed in the next release. The package `openafs` and the service options will then silently point to the OpenAFS 1.8 release.

  See also the OpenAFS [Administrator Guide](http://docs.openafs.org/AdminGuide/index.html) for instructions. Beware of the following when updating servers:

  - The storage format of the server key has changed and the key must be converted before running the new release.

  - When updating multiple database servers, turn off the database servers from the highest IP down to the lowest with resting periods in between. Start up in reverse order. Do not concurrently run database servers working with different OpenAFS releases!

  - Update servers first, then clients.

- Radicale's default package has changed from 2.x to 3.x. An upgrade checklist can be found [here](https://github.com/Kozea/Radicale/blob/3.0.x/NEWS.md#upgrade-checklist). You can use the newer version in the NixOS service by setting the `package` to `radicale3`, which is done automatically if `stateVersion` is 20.09 or higher.

- `udpt` experienced a complete rewrite from C++ to rust. The configuration format changed from ini to toml. The new configuration documentation can be found at [the official website](https://naim94a.github.io/udpt/config.html) and example configuration is packaged in `${udpt}/share/udpt/udpt.toml`.

- We now have a unified [services.xserver.displayManager.autoLogin](options.html#opt-services.xserver.displayManager.autoLogin) option interface to be used for every display-manager in NixOS.

- The `bitcoind` module has changed to multi-instance, using submodules. Therefore, it is now mandatory to name each instance. To use this new multi-instance config with an existing bitcoind data directory and user, you have to adjust the original config, e.g.:

  ```nix
  {
    services.bitcoind = {
      enable = true;
      extraConfig = "...";
      # ...
    };
  }
  ```

  To something similar:

  ```nix
  {
    services.bitcoind.mainnet = {
      enable = true;
      dataDir = "/var/lib/bitcoind";
      user = "bitcoin";
      extraConfig = "...";
      # ...
    };
  }
  ```

  The key settings are:

  - `dataDir` - to continue using the same data directory.

  - `user` - to continue using the same user so that bitcoind maintains access to its files.

- Graylog introduced a change in the LDAP server certificate validation behaviour for version 3.3.3 which might break existing setups. When updating Graylog from a version before 3.3.3 make sure to check the Graylog [release info](https://www.graylog.org/post/announcing-graylog-v3-3-3) for information on how to avoid the issue.

- The `dokuwiki` module has changed to multi-instance, using submodules. Therefore, it is now mandatory to name each instance. Moreover, forcing SSL by default has been dropped, so `nginx.forceSSL` and `nginx.enableACME` are no longer set to `true`. To continue using your service with the original SSL settings, you have to adjust the original config, e.g.:

  ```nix
  {
    services.dokuwiki = {
      enable = true;
      # ...
    };
  }
  ```

  To something similar:

  ```nix
  {
    services.dokuwiki."mywiki" = {
      enable = true;
      nginx = {
        forceSSL = true;
        enableACME = true;
      };
      # ...
    };
  }
  ```

  The base package has also been upgraded to the 2020-07-29 "Hogfather" release. Plugins might be incompatible or require upgrading.

- The [services.postgresql.dataDir](options.html#opt-services.postgresql.dataDir) option is now set to `"/var/lib/postgresql/${cfg.package.psqlSchema}"` regardless of your [system.stateVersion](options.html#opt-system.stateVersion). Users with an existing postgresql install that have a [system.stateVersion](options.html#opt-system.stateVersion) of `17.03` or below should double check what the value of their [services.postgresql.dataDir](options.html#opt-services.postgresql.dataDir) option is (`/var/db/postgresql`) and then explicitly set this value to maintain compatibility:

  ```nix
  { services.postgresql.dataDir = "/var/db/postgresql"; }
  ```

  The postgresql module now expects there to be a database super user account called `postgres` regardless of your [system.stateVersion](options.html#opt-system.stateVersion). Users with an existing postgresql install that have a [system.stateVersion](options.html#opt-system.stateVersion) of `17.03` or below should run the following SQL statements as a database super admin user before upgrading:

  ```SQL
  CREATE ROLE postgres LOGIN SUPERUSER;
  ```

- The USBGuard module now removes options and instead hardcodes values for `IPCAccessControlFiles`, `ruleFiles`, and `auditFilePath`. Audit logs can be found in the journal.

- The NixOS module system now evaluates option definitions more strictly, allowing it to detect a larger set of problems. As a result, what previously evaluated may not do so anymore. See [the PR that changed this](https://github.com/NixOS/nixpkgs/pull/82743#issuecomment-674520472) for more info.

- For NixOS configuration options, the type `loaOf`, after its initial deprecation in release 20.03, has been removed. In NixOS and Nixpkgs options using this type have been converted to `attrsOf`. For more information on this change have look at these links: [issue \#1800](https://github.com/NixOS/nixpkgs/issues/1800), [PR \#63103](https://github.com/NixOS/nixpkgs/pull/63103).

- `config.systemd.services.${name}.path` now returns a list of paths instead of a colon-separated string.

- Caddy module now uses Caddy v2 by default. Caddy v1 can still be used by setting [services.caddy.package](options.html#opt-services.caddy.package) to `pkgs.caddy1`.

  New option [services.caddy.adapter](options.html#opt-services.caddy.adapter) has been added.

- The [jellyfin](options.html#opt-services.jellyfin.enable) module will use and stay on the Jellyfin version `10.5.5` if `stateVersion` is lower than `20.09`. This is because significant changes were made to the database schema, and it is highly recommended to backup your instance before upgrading. After making your backup, you can upgrade to the latest version either by setting your `stateVersion` to `20.09` or higher, or set the `services.jellyfin.package` to `pkgs.jellyfin`. If you do not wish to upgrade Jellyfin, but want to change your `stateVersion`, you can set the value of `services.jellyfin.package` to `pkgs.jellyfin_10_5`.

- The `security.rngd` service is now disabled by default. This choice was made because there's krngd in the linux kernel space making it (for most usecases) functionally redundant.

- The `hardware.nvidia.optimus_prime.enable` service has been renamed to `hardware.nvidia.prime.sync.enable` and has many new enhancements. Related nvidia prime settings may have also changed.

- The package nextcloud17 has been removed and nextcloud18 was marked as insecure since both of them will [ will be EOL (end of life) within the lifetime of 20.09](https://docs.nextcloud.com/server/19/admin_manual/release_schedule.html).

  It's necessary to upgrade to nextcloud19:

  - From nextcloud17, you have to upgrade to nextcloud18 first as Nextcloud doesn't allow going multiple major revisions forward in a single upgrade. This is possible by setting [services.nextcloud.package](options.html#opt-services.nextcloud.package) to nextcloud18.

  - From nextcloud18, it's possible to directly upgrade to nextcloud19 by setting [services.nextcloud.package](options.html#opt-services.nextcloud.package) to nextcloud19.

- The GNOME desktop manager no longer default installs gnome3.epiphany. It was chosen to do this as it has a usability breaking issue (see issue [\#98819](https://github.com/NixOS/nixpkgs/issues/98819)) that makes it unsuitable to be a default app.

  ::: {.note}
  Issue [\#98819](https://github.com/NixOS/nixpkgs/issues/98819) is now fixed and gnome3.epiphany is once again installed by default.
  :::

- If you want to manage the configuration of wpa_supplicant outside of NixOS you must ensure that none of [networking.wireless.networks](options.html#opt-networking.wireless.networks), [networking.wireless.extraConfig](options.html#opt-networking.wireless.extraConfig) or [networking.wireless.userControlled.enable](options.html#opt-networking.wireless.userControlled.enable) is being used or `true`. Using any of those options will cause wpa_supplicant to be started with a NixOS generated configuration file instead of your own.

## Other Notable Changes {#sec-release-20.09-notable-changes}

- SD images are now compressed by default using `zstd`. The compression for ISO images has also been changed to `zstd`, but ISO images are still not compressed by default.

- `services.journald.rateLimitBurst` was updated from `1000` to `10000` to follow the new upstream systemd default.

- The notmuch package moves its emacs-related binaries and emacs lisp files to a separate output. They're not part of the default `out` output anymore - if you relied on the `notmuch-emacs-mua` binary or the emacs lisp files, access them via the `notmuch.emacs` output.

- Device tree overlay support was improved in [\#79370](https://github.com/NixOS/nixpkgs/pull/79370) and now uses [hardware.deviceTree.kernelPackage](options.html#opt-hardware.deviceTree.kernelPackage) instead of `hardware.deviceTree.base`. [hardware.deviceTree.overlays](options.html#opt-hardware.deviceTree.overlays) configuration was extended to support `.dts` files with symbols. Device trees can now be filtered by setting [hardware.deviceTree.filter](options.html#opt-hardware.deviceTree.filter) option.

- The default output of `buildGoPackage` is now `$out` instead of `$bin`.

- `buildGoModule` `doCheck` now defaults to `true`.

- Packages built using `buildRustPackage` now use `release` mode for the `checkPhase` by default.

  Please note that Rust packages utilizing a custom build/install procedure (e.g. by using a `Makefile`) or test suites that rely on the structure of the `target/` directory may break due to those assumptions. For further information, please read the Rust section in the Nixpkgs manual.

- The cc- and binutils-wrapper's "infix salt" and `_BUILD_` and `_TARGET_` user infixes have been replaced with a "suffix salt" and suffixes and `_FOR_BUILD` and `_FOR_TARGET`. This matches the autotools convention for env vars which standard for these things, making interfacing with other tools easier.

- Additional Git documentation (HTML and text files) is now available via the `git-doc` package.

- Default algorithm for ZRAM swap was changed to `zstd`.

- The installer now enables sshd by default. This improves installation on headless machines especially ARM single-board-computer. To login through ssh, either a password or an ssh key must be set for the root user or the nixos user.

- The scripted networking system now uses `.link` files in `/etc/systemd/network` to configure mac address and link MTU, instead of the sometimes buggy `network-link-*` units, which have been removed. Bringing the interface up has been moved to the beginning of the `network-addresses-*` unit. Note this doesn't require `systemd-networkd` - it's udev that parses `.link` files. Extra care needs to be taken in the presence of [legacy udev rules](https://wiki.debian.org/NetworkInterfaceNames#THE_.22PERSISTENT_NAMES.22_SCHEME) to rename interfaces, as MAC Address and MTU defined in these options can only match on the original link name. In such cases, you most likely want to create a `10-*.link` file through [systemd.network.links](options.html#opt-systemd.network.links) and set both name and MAC Address / MTU there.

- Grafana received a major update to version 7.x. A plugin is now needed for image rendering support, and plugins must now be signed by default. More information can be found [in the Grafana documentation](https://grafana.com/docs/grafana/latest/installation/upgrading/#upgrading-to-v7-0).

- The `hardware.u2f` module, which was installing udev rules was removed, as udev gained native support to handle FIDO security tokens.

- The `services.transmission` module was enhanced with the new options: [services.transmission.credentialsFile](options.html#opt-services.transmission.credentialsFile), [services.transmission.openFirewall](options.html#opt-services.transmission.openFirewall), and [services.transmission.performanceNetParameters](options.html#opt-services.transmission.performanceNetParameters).

  `transmission-daemon` is now started with additional systemd sandbox/hardening options for better security. Please [report](https://github.com/NixOS/nixpkgs/issues) any use case where this is not working well. In particular, the `RootDirectory` option newly set forbids uploading or downloading a torrent outside of the default directory configured at [settings.download-dir](options.html#opt-services.transmission.settings). If you really need Transmission to access other directories, you must include those directories into the `BindPaths` of the service:

  ```nix
  {
    systemd.services.transmission.serviceConfig.BindPaths = [ "/path/to/alternative/download-dir" ];
  }
  ```

  Also, connection to the RPC (Remote Procedure Call) of `transmission-daemon` is now only available on the local network interface by default. Use:

  ```nix
  { services.transmission.settings.rpc-bind-address = "0.0.0.0"; }
  ```

  to get the previous behavior of listening on all network interfaces.

- With this release `systemd-networkd` (when enabled through [networking.useNetworkd](options.html#opt-networking.useNetworkd)) has it's netlink socket created through a `systemd.socket` unit. This gives us control over socket buffer sizes and other parameters. For larger setups where networkd has to create a lot of (virtual) devices the default buffer size (currently 128MB) is not enough.

  On a machine with \>100 virtual interfaces (e.g., wireguard tunnels, VLANs, ...), that all have to be brought up during system startup, the receive buffer size will spike for a brief period. Eventually some of the message will be dropped since there is not enough (permitted) buffer space available.

  By having `systemd-networkd` start with a netlink socket created by `systemd` we can configure the `ReceiveBufferSize=` parameter in the socket options (i.e. `systemd.sockets.systemd-networkd.socketOptions.ReceiveBufferSize`) without recompiling `systemd-networkd`.

  Since the actual memory requirements depend on hardware, timing, exact configurations etc. it isn't currently possible to infer a good default from within the NixOS module system. Administrators are advised to monitor the logs of `systemd-networkd` for `rtnl: kernel receive buffer overrun` spam and increase the memory limit as they see fit.

  Note: Increasing the `ReceiveBufferSize=` doesn't allocate any memory. It just increases the upper bound on the kernel side. The memory allocation depends on the amount of messages that are queued on the kernel side of the netlink socket.

- Specifying [mailboxes](options.html#opt-services.dovecot2.mailboxes) in the dovecot2 module as a list is deprecated and will break eval in 21.05. Instead, an attribute-set should be specified where the `name` should be the key of the attribute.

  This means that a configuration like this

  ```nix
  {
    services.dovecot2.mailboxes = [
      {
        name = "Junk";
        auto = "create";
      }
    ];
  }
  ```

  should now look like this:

  ```nix
  {
    services.dovecot2.mailboxes = {
      Junk.auto = "create";
    };
  }
  ```

- netbeans was upgraded to 12.0 and now defaults to OpenJDK 11. This might cause problems if your projects depend on packages that were removed in Java 11.

- nextcloud has been updated to [v19](https://nextcloud.com/blog/nextcloud-hub-brings-productivity-to-home-office/).

  If you have an existing installation, please make sure that you're on nextcloud18 before upgrading to nextcloud19 since Nextcloud doesn't support upgrades across multiple major versions.

- The `nixos-run-vms` script now deletes the previous run machines states on test startup. You can use the `--keep-vm-state` flag to match the previous behaviour and keep the same VM state between different test runs.

- The [nix.buildMachines](options.html#opt-nix.buildMachines) option is now type-checked. There are no functional changes, however this may require updating some configurations to use correct types for all attributes.

- The `fontconfig` module stopped generating config and cache files for fontconfig 2.10.x, the `/etc/fonts/fonts.conf` now belongs to the latest fontconfig, just like on other Linux distributions, and we will [no longer](https://github.com/NixOS/nixpkgs/pull/95358) be versioning the config directories.

  Fontconfig 2.10.x was removed from Nixpkgs since it hasn't been used in any Nixpkgs package for years now.

- Nginx module `nginxModules.fastcgi-cache-purge` renamed to official name `nginxModules.cache-purge`. Nginx module `nginxModules.ngx_aws_auth` renamed to official name `nginxModules.aws-auth`.

- The option `defaultPackages` was added. It installs the packages perl, rsync and strace for now. They were added unconditionally to `systemPackages` before, but are not strictly necessary for a minimal NixOS install. You can set it to an empty list to have a more minimal system. Be aware that some functionality might still have an impure dependency on those packages, so things might break.

- The `undervolt` option no longer needs to apply its settings every 30s. If they still become undone, open an issue and restore the previous behaviour using `undervolt.useTimer`.

- Agda has been heavily reworked.

  - `agda.mkDerivation` has been heavily changed and is now located at agdaPackages.mkDerivation.

  - New top-level packages agda and `agda.withPackages` have been added, the second of which sets up agda with access to chosen libraries.

  - All agda libraries now live under `agdaPackages`.

  - Many broken libraries have been removed.

  See the [new documentation](https://nixos.org/nixpkgs/manual/#agda) for more information.

- The `deepin` package set has been removed from nixpkgs. It was a work in progress to package the [Deepin Desktop Environment (DDE)](https://www.deepin.org/en/dde/), including libraries, tools and applications, and it was still missing a service to launch the desktop environment. It has shown to no longer be a feasible goal due to reasons discussed in [issue \#94870](https://github.com/NixOS/nixpkgs/issues/94870). The package `netease-cloud-music` has also been removed, as it depends on libraries from deepin.

- The `opendkim` module now uses systemd sandboxing features to limit the exposure of the system towards the opendkim service.

- Kubernetes has been upgraded to 1.19.1, which also means that the golang version to build it has been bumped to 1.15. This may have consequences for your existing clusters and their certificates. Please consider [ the release notes for Kubernetes 1.19 carefully ](https://relnotes.k8s.io/?markdown=93264) before upgrading.

- For AMD GPUs, Vulkan can now be used by adding `amdvlk` to `hardware.opengl.extraPackages`.

- Similarly, still for AMD GPUs, the ROCm OpenCL stack can now be used by adding `rocm-opencl-icd` to `hardware.opengl.extraPackages`.

## Contributions {#sec-release-20.09-contributions}

I, Jonathan Ringer, would like to thank the following individuals for their work on nixpkgs. This release could not be done without the hard work of the NixOS community. There were 31282 contributions across 1313 contributors.

1.  2288 Mario Rodas

2.  1837 Frederik Rietdijk

3.  946 Jörg Thalheim

4.  925 Maximilian Bosch

5.  687 Jonathan Ringer

6.  651 Jan Tojnar

7.  622 Daniël de Kok

8.  605 WORLDofPEACE

9.  597 Florian Klink

10. 528 José Romildo Malaquias

11. 281 volth

12. 101 Robert Scott

13. 86 Tim Steinbach

14. 76 WORLDofPEACE

15. 49 Maximilian Bosch

16. 42 Thomas Tuegel

17. 37 Doron Behar

18. 36 Vladimír Čunát

19. 27 Jonathan Ringer

20. 27 Maciej Krüger

I, Jonathan Ringer, would also like to personally thank \@WORLDofPEACE for their help in mentoring me on the release process. Special thanks also goes to Thomas Tuegel for helping immensely with stabilizing Qt, KDE, and Plasma5; I would also like to thank Robert Scott for his numerous fixes and pull request reviews.
