# Nixpkgs 26.05 ("Yarara", 2026.05/??) {#sec-nixpkgs-release-26.05}

## Highlights {#sec-nixpkgs-release-26.05-highlights}
<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- GCC has been updated from GCC 14 to GCC 15.
  This introduces some backwards incompatible changes; Refer to the [upstream porting guide](https://gcc.gnu.org/gcc-15/porting_to.html) for details.

- Node.js default version has been updated from 22 LTS to 24 LTS.
  This introduces some breaking changes; Refer to the [upstream migration article](https://nodejs.org/en/blog/migrations/v22-to-v24) for details.

- The Factor programming language has been updated to Version 0.101 bringing various improvements to UI rendering and HiDPI support as well as support for Unicode 17.0.0.
  Starting from Version 0.100, the Factor VM is compiled with Clang.

  This brings along some backwards compatibility issues in the language further detailed [here](https://re.factorcode.org/2025/12/factor-0-101-now-available.html).
  Additionally, the FUEL Emacs module is no longer part of the `factor-lang` package.
  It is part of the MELPA package set for a while already and must be taken from there.
  This *does not affect* `factor-lang` packages Version 0.99 and 0.100.
  Using the official MELPA package now puts the burden of providing the path to `/lib/factor` in `factor-root-dir` on the user.
  Make sure to use the `extraVocabs` package attribute to compose a special vocabulary tree if necessary.
  You can refer to the generated tree of vocabulary roots via the newly exposed `vocabTree` attribute, as described in the [documentation](#ssec-factor-dev-env).

- Nixpkgs configuration, specified for NixOS using `nixpkgs.config`, or using the `config` argument when importing nixpkgs, has learned to accept a `lib` argument as well as `pkgs`, which allows the configuration to be computed without depending on the `pkgs` fixed point.  If you are referencing licenses in `lib.licenses` by having this configuration be a function taking a `pkgs` arg, you may wish to change to using `lib` for faster computation and to avoid infinite recursion errors if pkgs depends on parts of the computed configuration in future.

    For example, if you currently have configuration that looks like this:

        { pkgs, ... }:
        {
          allowlistedLicenses = [ pkgs.lib.licenses.nasa13 ];
          blocklistedLicenses = with pkgs.lib.licenses; [ gpl3Only gpl3Plus ];
        }

    You may wish to update it to something like this:

        { lib, ... }:
        {
          allowlistedLicenses = [ lib.licenses.nasa13 ];
          blocklistedLicenses = with lib.licenses; [ gpl3Only gpl3Plus ];
        }

    Or, if you need configuration that works with both 26.05 and 25.11:

        { pkgs, lib ? pkgs.lib, ... }:
        {
          allowlistedLicenses = [ lib.licenses.nasa13 ];
          blocklistedLicenses = with lib.licenses; [ gpl3Only gpl3Plus ];
        }

## Backward Incompatibilities {#sec-nixpkgs-release-26.05-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `xfce.mkXfceDerivation` has been deprecated (i.e. conditioned behind `nixpkgs.config.allowAliases`)
  and will be removed in NixOS 26.11, please use `stdenv.mkDerivation` directly. You can migrate by
  adding `pkg-config`, `xfce4-dev-tools`, and `wrapGAppsHook3` to your `nativeBuildInputs` and
  `--enable-maintainer-mode` to your `configureFlags`.

- `cargo-codspeed` has been updated from `3.0.5` to `4.2.0`. Version `4.0.0` includes breaking changes. For more information read the [changelog for 4.0.0](https://github.com/CodSpeedHQ/codspeed-rust/releases/tag/v4.0.0).

- `corepack_latest` has been removed, as Corepack is no longer distributed with Node.js.

- `spoof` has been removed, as there are many issues upstream with it working on modern OS versions, and it appears to be unmaintained.

- `nodePackages.wavedrom-cli` has been removed, as it was unmaintained within nixpkgs.

- `kanata` now requires `karabiner-dk` version 6.0+ or later.
  The package has been updated to use the new `karabiner-dk` package and the `darwinDriver` output stays at the version defined in the package.

- Reloading or restarting systemd units from the NixOS activation script is deprecated, and will be removed in NixOS 26.11. This deprecation is part of a bigger effort to deprecate activation scripts altogether, which will take place over several releases. There are no in-tree usages of the now-deprecated reload/restart functionality.

- `elegant-sddm` has been updated to be Qt6 compatible. Themes for SDDM are slightly different so read the [wiki](https://wiki.nixos.org/wiki/SDDM_Themes) for more.

- `forgejo` has been updated to major version 14. For more information, see the [release blog post](https://forgejo.org/2026-01-release-v14-0/) and [full release notes](https://codeberg.org/forgejo/forgejo/src/branch/forgejo/release-notes-published/14.0.0.md)

- `lima` has been updated from `1.x` to `2.x`. This major update includes several breaking changes, such as `/tmp/lima` no longer being mounted by default.

- `mercure` has been update to `0.21.4` (or later). Version [0.21.0](https://github.com/dunglas/mercure/releases/v0.21.0) and [0.21.2](https://github.com/dunglas/mercure/releases/tag/v0.21.2) introduce breaking changes to the package.

- `n8n` has been updated to version 2. You can find the breaking changes here: https://docs.n8n.io/2-0-breaking-changes/.

- `gurk-rs` has been updated from `0.6.4` to `0.8.0`. Version `0.8.0` includes breaking changes. For more information read the [release notes for 0.8.0](https://github.com/boxdot/gurk-rs/releases/tag/v0.8.0).

- `iroh` has been removed and split up into `iroh-dns-server` and `iroh-relay`.

- the `xorg` package set has been deprecated and will be removed, packages have moved to the top level.

- `python3Packages.pygame` has been been renamed to `python3Packages.pygame-original`, the attribute `python3Packages.pygame` will from python 3.14 default to the more actively maintained `python3Packages.pygame-ce`

- `python3Packages.gradio` has been updated to version 6. See upstream's migration guide at https://www.gradio.app/main/guides/gradio-6-migration-guide.

- `vicinae` has been updated to v0.17. Version 0.17 contains a complete overhaul of the configuration system. For update instructions, see the [release notes for v0.17.0](https://github.com/vicinaehq/vicinae/releases/tag/v0.17.0) and the [upstream configuration documentation](https://docs.vicinae.com/config).

- All Log4Shell vulnerability scanners were removed, as they were all unmaintained upstream and are no longer relevant given that the vulnerability has been fixed upstream for several years.

- Plugins for the JetBrains IDEs have been removed from Nixpkgs.

- `jetbrains.plugins.addPlugins` no longer supports plugin names or ID strings.
  You can still use `addPlugins` with plugin derivations, such as plugins packaged outside of Nixpkgs.

- The `services.yggdrasil` module has been refactored with the following breaking changes:
  - The `services.yggdrasil.configFile` option has been removed. Configuration should now be specified directly via `services.yggdrasil.settings`.
  - The `services.yggdrasil.persistentKeys` option has been removed. To maintain persistent keys and IPv6 addresses across reboots, use `services.yggdrasil.settings.PrivateKeyPath` to securely load your private key from a file via systemd credentials. The private key must be in PEM format (PKCS #8).
  - Storing `PrivateKey` directly in `settings` is now explicitly forbidden to prevent keys from being stored world-readable in the Nix store.
  - If you previously used `configFile`, migrate your configuration to the `settings` option and extract the private key to a separate file referenced by `PrivateKeyPath`.
  - If you previously used `persistentKeys`, convert your keys to PEM format and store them in a secure location accessible only to root, then reference them via `PrivateKeyPath`.

- `pocket-id` has been updated to version 2 that contains [breaking changes](https://pocket-id.org/docs/setup/major-releases/migrate-v2).

- `asio` (standalone version of `boost::asio`) has been updated from 1.24.0 to 1.36.0. Some breaking changes were introduced between these
  two versions, and the one affected most was the removal of `asio::io_service` in favor of `asio::io_context` in 1.33.0. `asio_1_32_0` is
  retained for packages that have not completed migration. `asio_1_10` has been removed as no packages depend on it anymore.
  `asio` also no longer propagates `boost` as it is used independent from `boost` in most cases.

- Ethercalc and its associated module have been removed, as the package is unmaintained and cannot be installed from source with npm now.

- `coreth` has been removed, as upstream has moved it into `avalanchego`.

- `nodePackages.prebuild-install` was removed because it appeared to be unmaintained upstream.
  See [upstream's recommendations for alternatives](https://github.com/prebuild/prebuild-install#note).

- `davis` made changes to the `IMAP_AUTH_URL` option. The flags are now standalone parameters that you need to fill:
  - Before:
    ```env
    IMAP_AUTH_URL={imap.gmail.com:993/imap/ssl/novalidate-cert}
    ```
  - After:
    ```env
    IMAP_AUTH_URL=imap.mydomain.com:993
    IMAP_ENCRYPTION_METHOD=ssl
    IMAP_CERTIFICATE_VALIDATION=false
    ```

- `python3packages.pillow-avif-plugin` has been removed as the functionality is included in `python3packages.pillow` directly since version 11.3.

- `services.openssh.settings.AcceptEnv` now explicitly defined as an option that takes a list of strings, to facilitate option merging. Setting it to a string value is no longer supported.

- All Xfce packages have been moved to top level (e.g. if you previously added `pkgs.xfce.xfce4-whiskermenu-plugin` to `environment.systemPackages`, you will need to change it to `pkgs.xfce4-whiskermenu-plugin`). The `xfce` scope will be removed in NixOS 26.11.

- `vimPlugins.nvim-treesitter` has been updated to `main` branch, which is a full and incompatible rewrite. If you can't or don't want to update, you should use `vimPlugins.nvim-treesitter-legacy`.

## Other Notable Changes {#sec-nixpkgs-release-26.05-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `uptime-kuma` has been updated to v2, which requires an automated migration that can take a few hours. **A backup is highly recommended.**
  If your SQLite database is corrupted, the migration might fail and require [manual intervention](https://github.com/louislam/uptime-kuma/issues/5281).
  See the [migration guide](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) for more information.

- Switch inhibitors were introduced, which add a pre-switch check that compares a list of strings between the previous and the new generation, and refuses to switch into the new generation when there is a difference between the two lists. This allows to avoid switching into a system when for instance the systemd version changed by adding `config.systemd.package.version` to the switch inhibitors for your system. You can still forcefully switch into any generation by setting `NIXOS_NO_CHECK=1`.

- The `services.nextcloud-spreed-signaling` NixOS module has been added to facilitate declarative management of a standalone Spreed signaling server ("High Performance Backend" for Nextcloud Talk).

- `fetchPnpmDeps` and `pnpmConfigHook` were added as top-level attributes, replacing the now deprecated `pnpm.fetchDeps` and `pnpm.configHook` attributes.

- Added `dell-bios-fan-control` package and service.

- `openrgb` was updated to 1.0rc2, which now uses Plugin API version 4.
  Some existing OpenRGB plugins may be incompatible or require updates.

- We now use the upstream wrapper script for Gradle, supporting both the `JAVA_HOME` and `GRADLE_OPTS` environment variables.

## Nixpkgs Library {#sec-nixpkgs-release-26.05-lib}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

### Breaking changes {#sec-nixpkgs-release-26.05-lib-breaking}

- The `nodejs_latest` alias now points to `nodejs_25` instead of `nodejs_24`.

- `mold` is now wrapped by default.


### Deprecations {#sec-nixpkgs-release-26.05-lib-deprecations}

- `mpv-unwrapped.scripts` and `mpv-unwrapped.wrapper` have been removed. Please use `mpvScripts` and `mpv.override` accordingly.

- `fetchFromSavannah` is now deprecated and is expected to be fully removed in a future release. From now on, use `fetchgit` or a Savannah releases mirror when applicable.

### Additions and Improvements {#sec-nixpkgs-release-26.05-lib-additions-improvements}

- The builder `php.buildComposerProject2` for PHP applications has been improved for better reliability and stability.
