# D (Dlang) {#dlang}

Nixpkgs provides multiple D compilers such as `ldc` and `dmd`.
These can be used like any other package during build time.

However, Nixpkgs provides a build helper for compiling packages using the `dub` package manager.

Here's an example:
```nix
{
  lib,
  buildDubPackage,
  fetchFromGitHub,
  ncurses,
  zlib,
}:

buildDubPackage rec {
  pname = "btdu";
  version = "0.5.1";

  src = fetchFromGitHub {
    owner = "CyberShadow";
    repo = "btdu";
    tag = "v${version}";
    hash = "sha256-3sSZq+5UJH02IO0Y1yL3BLHDb4lk8k6awb5ZysBQciE=";
  };

  # generated by dub-to-nix, see below
  dubLock = ./dub-lock.json;

  buildInputs = [
    ncurses
    zlib
  ];

  installPhase = ''
    runHook preInstall
    install -Dm755 btdu -t $out/bin
    runHook postInstall
  '';
}
```

Note that you need to define `installPhase` because `dub` doesn't know where files should go in `$out`.

Also note that running `dub test` is disabled by default. You can enable it by setting `doCheck = true`.

## Lockfiles {#dub-lockfiles}
Nixpkgs has its own lockfile format for `dub` dependencies, because `dub`'s official "lockfile" format (`dub.selections.json`) is not hash-based.

A lockfile can be generated using the `dub-to-nix` helper package.
* Firstly, install `dub-to-nix` into your shell session by running `nix-shell -p dub-to-nix`.
* Then navigate to the root of the source of the program you want to package.
* Finally, run `dub-to-nix`, and it will print the lockfile to stdout. You can pipe stdout into a text file or just copy the output manually into a file.

## `buildDubPackage` parameters {#builddubpackage-parameters}

The `buildDubPackage` function takes an attrset of parameters that are passed on to `stdenv.mkDerivation`.

The following parameters are specific to `buildDubPackage`:

* `dubLock`: A lockfile generated by `dub-to-nix` from the source of the package. Can be either a path to the file, or an attrset already parsed with `lib.importJSON`.
  The latter useful if the package uses `dub` dependencies not already in the lockfile. (e.g. if the package calls `dub run some-dub-package` manually)
* `dubBuildType ? "release"`: The build type to pass to `dub build` as a value for the `--build=` flag.
* `dubFlags ? []`: The flags to pass to `dub build` and `dub test`.
* `dubBuildFlags ? []`: The flags to pass to `dub build`.
* `dubTestFlags ? []`: The flags to pass to `dub test`.
* `compiler ? ldc`: The D compiler to be used by `dub`.
