{
  stdenv,
  lib,
  help2man,
  python3,
  fetchFromGitHub,
}:

stdenv.mkDerivation rec {
  pname = "terminal-colors";
  version = "3.0.2";
  outputs = [
    "out"
    "man"
  ];

  src = fetchFromGitHub {
    owner = "eikenb";
    repo = "terminal-colors";
    rev = "v${version}";
    hash = "sha256-KRoP/Reo5nDKJYG9zVTVpoYL7soAGMNk46vDoaLfnv4=";
  };

  buildInputs = [ python3 ];
  nativeBuildInputs = [ help2man ];

  postPatch =
    # This sed command modifies output of --version command in way that
    # makes manpage generated by help2man(1) prettier.
    ''
      sed -r -i "3s/([0-9.]+)/$pname - \1\\n/" ./$pname
    ''
    # Upstream shebang of "terminal-colors" python script uses
    # /usr/bin/env, which is not present in Nix sandbox, so we need to
    # patch it before running help2man, otherwise it would fail with "no
    # such file or directory".
    + ''
      patchShebangs ./$pname
    '';

  buildPhase = ''
    runHook preBuild

    help2man -n 'display terminal colors' -N ./$pname > $pname.1

    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall

    install -D -m755 ./$pname -t $out/bin
    install -D -m644 ./$pname.1 -t $man/share/man/man1

    runHook postInstall
  '';

  meta = {
    description = "Script displaying terminal colors in various formats";
    homepage = "https://github.com/eikenb/terminal-colors";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ kaction ];
    mainProgram = "terminal-colors";
  };
}
