{
  aseprite,
  clangStdenv,
  expat,
  fetchFromGitHub,
  fetchgit,
  fontconfig,
  gn,
  harfbuzzFull,
  lib,
  libglvnd,
  libjpeg,
  libpng,
  libwebp,
  libX11,
  libgbm,
  ninja,
  python3,
  zlib,
}:

let
  # deps.nix is generated by ./update.sh
  depSrcs = import ./deps.nix { inherit fetchgit; };
in
clangStdenv.mkDerivation (finalAttrs: {
  pname = "skia-aseprite";
  version = "m124-08a5439a6b";

  src = fetchFromGitHub {
    owner = "aseprite";
    repo = "skia";
    rev = finalAttrs.version;
    hash = "sha256-D79Z/deJsDVclcUTZXUrNZdTPW2TFNaVF4mTeHO8I+U=";
  };

  nativeBuildInputs = [
    gn
    ninja
    python3
  ];

  # Using substituteInPlace because no clean upstream backport for GCC 15 exists for this version of Skia, newer versions fix this with large refactorings.
  postPatch = ''
    #include <cstdint>"
    substituteInPlace src/sksl/transform/SkSLTransform.h \
      --replace-fail "#include <vector>" "#include <vector>
    #include <cstdint>"
  '';

  preConfigure = with depSrcs; ''
    mkdir -p third_party/externals
    ln -s ${angle2} third_party/externals/angle2
    ln -s ${dng_sdk} third_party/externals/dng_sdk
    ln -s ${icu} third_party/externals/icu
    ln -s ${icu4x} third_party/externals/icu4x
    ln -s ${piex} third_party/externals/piex
    ln -s ${wuffs} third_party/externals/wuffs
  '';

  configurePhase = ''
    runHook preConfigure
    gn gen lib --args="is_debug=false is_official_build=true skia_use_system_icu=false extra_cflags=[\"-I${harfbuzzFull.dev}/include/harfbuzz\"]"
    runHook postConfigure
  '';

  buildInputs = [
    expat
    fontconfig
    harfbuzzFull
    libglvnd
    libjpeg
    libpng
    libwebp
    libX11
    libgbm
    zlib
  ];

  buildPhase = ''
    runHook preBuild
    ninja -C lib skia modules
    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall
    mkdir -p $out

    # Glob will match all subdirs.
    shopt -s globstar

    # All these paths are used in some way when building Aseprite.
    cp -r --parents -t $out/ \
      include/codec/**/*.h \
      include/config/**/*.h \
      include/core/**/*.h \
      include/effects/**/*.h \
      include/gpu/**/*.h \
      include/private/**/*.h \
      include/utils/**/*.h \
      include/ports/**/*.h \
      include/sksl/**/*.h \
      lib/*.a \
      modules/skshaper/**/*.h \
      modules/skcms/**/*.h \
      modules/skunicode/**/*.h \
      src/core/*.h \
      src/gpu/**/*.h \
      src/image/*.h \
      src/sksl/**/*.h \
      src/base/**/*.h \
      third_party/externals/angle2/include \
      third_party/externals/icu/flutter/icudtl.dat

    runHook postInstall
  '';

  passthru.updateScript = [ ./update.sh ] ++ builtins.attrNames depSrcs;

  meta = {
    description = "Complete 2D graphic library for drawing Text, Geometries, and Images (Aseprite's fork)";
    homepage = "https://skia.org/";
    downloadPage = "https://github.com/aseprite/skia";
    license = lib.licenses.bsd3;
    inherit (aseprite.meta) maintainers;
    platforms = lib.platforms.all;
  };
})
