{
  lib,
  stdenv,
  fetchzip,
  autoPatchelfHook,
  makeWrapper,
  alsa-lib,
  curl,
  gtk3,
  # webkitgtk_4_0,
  zenity,
}:

stdenv.mkDerivation rec {
  pname = "rymcast";
  version = "1.0.6";

  src = fetchzip {
    url = "https://www.inphonik.com/files/rymcast/rymcast-${version}-linux-x64.tar.gz";
    hash = "sha256:0vjjhfrwdibjjgz3awbg30qxkjrzc4cya1f4pigwjh3r0vvrq0ga";
    stripRoot = false;
  };

  nativeBuildInputs = [
    autoPatchelfHook
    makeWrapper
  ];

  buildInputs = [
    alsa-lib
    curl
    gtk3
    (lib.getLib stdenv.cc.cc)
    # webkitgtk_4_0
    zenity
  ];

  installPhase = ''
    mkdir -p "$out/bin"
    cp RYMCast "$out/bin/"
    wrapProgram "$out/bin/RYMCast" \
      --set PATH "${lib.makeBinPath [ zenity ]}"
  '';

  meta = {
    # webkitgtk_4_0 was removed
    broken = true;
    description = "Player for Mega Drive/Genesis VGM files";
    homepage = "https://www.inphonik.com/products/rymcast-genesis-vgm-player/";
    sourceProvenance = with lib.sourceTypes; [ binaryNativeCode ];
    license = lib.licenses.unfree;
    platforms = [ "x86_64-linux" ];
  };
}
