{
  lib,
  fetchFromGitHub,
  python3,
}:

python3.pkgs.buildPythonApplication (finalAttrs: {
  pname = "regexploit";
  version = "1.0.0";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "doyensec";
    repo = "regexploit";
    tag = "v${finalAttrs.version}";
    hash = "sha256-HmR3ObVhdcRQRbEGzkzE9fg3IgYMxmOjGZQC7jV8bnw=";
  };

  build-system = with python3.pkgs; [ setuptools ];

  dependencies = with python3.pkgs; [ pyyaml ];

  nativeCheckInputs = with python3.pkgs; [ pytestCheckHook ];

  pythonImportsCheck = [ "regexploit" ];

  meta = {
    description = "Tool to find regular expressions which are vulnerable to ReDoS";
    homepage = "https://github.com/doyensec/regexploit";
    changelog = "https://github.com/doyensec/regexploit/releases/tag/v${finalAttrs.src.tag}";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ fab ];
  };
})
