{
  lib,
  python3,
  fetchPypi,
  pkgsCross,
  avrdude,
  bootloadhid,
  dfu-programmer,
  dfu-util,
  wb32-dfu-updater,
  gcc-arm-embedded,
  gnumake,
  teensy-loader-cli,
}:

python3.pkgs.buildPythonApplication rec {
  pname = "qmk";
  version = "1.1.8";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-C0Jra/IK61tngGsuEnMD4mySRc/iZVgdYEbMXtwpBZ0=";
  };

  nativeBuildInputs = with python3.pkgs; [
    setuptools
  ];

  propagatedBuildInputs =
    with python3.pkgs;
    [
      dotty-dict
      hid
      hjson
      jsonschema
      milc
      pygments
      pyserial
      pyusb
      pillow
    ]
    ++ [
      # Binaries need to be in the path so this is in propagatedBuildInputs
      avrdude
      bootloadhid
      dfu-programmer
      dfu-util
      wb32-dfu-updater
      teensy-loader-cli
      gcc-arm-embedded
      gnumake
      pkgsCross.avr.buildPackages.binutils
      pkgsCross.avr.buildPackages.binutils.bintools
      pkgsCross.avr.buildPackages.gcc
      pkgsCross.avr.libc
    ];

  # no tests implemented
  doCheck = false;

  meta = {
    homepage = "https://github.com/qmk/qmk_cli";
    description = "Program to help users work with QMK Firmware";
    longDescription = ''
      qmk_cli is a companion tool to QMK firmware. With it, you can:

      - Interact with your qmk_firmware tree from any location
      - Use qmk clone to pull down anyone's qmk_firmware fork
      - Setup and work with your build environment:
        - qmk setup
        - qmk doctor
        - qmk compile
        - qmk console
        - qmk flash
        - qmk lint
      - ... and many more!
    '';
    license = lib.licenses.mit;
    maintainers = [ ];
    mainProgram = "qmk";
  };
}
