{
  lib,
  stdenv,
  fetchFromGitHub,
  cmake,
  pkg-config,
  alsa-lib,
  fontconfig,
  freetype,
  libX11,
  libXcomposite,
  libXcursor,
  libXdmcp,
  libXext,
  libXinerama,
  libXrandr,
  libXtst,
  writableTmpDirAsHomeHook,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "qdelay";
  version = "1.0.6";

  src = fetchFromGitHub {
    owner = "tiagolr";
    repo = "qdelay";
    tag = "v${finalAttrs.version}";
    fetchSubmodules = true;
    hash = "sha256-2fu2eF1SjM1qSwKx/oEAx6EWNbNZ8VeJrtnmvxm/0yU=";
  };

  nativeBuildInputs = [
    cmake
    pkg-config
    writableTmpDirAsHomeHook # fontconfig cache
  ];

  buildInputs = [
    fontconfig
    freetype
  ]
  ++ lib.optionals stdenv.isLinux [
    alsa-lib
    libX11
    libXcomposite
    libXcursor
    libXdmcp
    libXext
    libXinerama
    libXrandr
    libXtst
  ];

  enableParallelBuilding = true;

  cmakeFlags = [
    "-DCOPY_PLUGIN_AFTER_BUILD=FALSE"
  ]
  ++ lib.optionals stdenv.hostPlatform.isDarwin [
    "-DCMAKE_OSX_ARCHITECTURES=${stdenv.hostPlatform.darwinArch}"
  ];

  env.NIX_CFLAGS_COMPILE = lib.optionalString stdenv.hostPlatform.isLinux (toString [
    # juce, compiled in this build as part of a Git submodule, uses `-flto` as
    # a Link Time Optimization flag, and instructs the plugin compiled here to
    # use this flag to. This breaks the build for us. Using _fat_ LTO allows
    # successful linking while still providing LTO benefits. If our build of
    # `juce` was used as a dependency, we could have patched that `-flto` line
    # in our juce's source, but that is not possible because it is used as a
    # Git Submodule.
    "-ffat-lto-objects"
  ]);

  installPhase = ''
    runHook preInstall

    mkdir -p $out/bin $out/lib/vst3

  ''
  + (
    if stdenv.hostPlatform.isDarwin then
      ''
        mkdir -p $out/Applications
        cp -R QDelay_artefacts/Release/Standalone/QDelay.app \
          $out/Applications/QDelay.app
        ln -s \
          $out/Applications/QDelay.app/Contents/MacOS/QDelay \
          $out/bin/QDelay
      ''
    else
      ''
        install -Dm755 \
          QDelay_artefacts/Release/Standalone/QDelay \
          $out/bin/QDelay

        mkdir -p $out/bin $out/lib/lv2
        cp -r "QDelay_artefacts/Release/LV2/QDelay.lv2" $out/lib/lv2
      ''
  )
  + ''
    cp -r "QDelay_artefacts/Release/VST3/QDelay.vst3" $out/lib/vst3

    runHook postInstall
  '';

  meta = {
    description = "Dual delay with more features than it should";
    homepage = "https://github.com/tiagolr/qdelay";
    changelog = "https://github.com/tiagolr/qdelay/releases/tag/v${finalAttrs.version}";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ magnetophon ];
    mainProgram = "QDelay";
    platforms = lib.platforms.all;
  };
})
