{
  lib,
  stdenv,
  fetchpatch,
  fetchFromGitHub,
  nix-update-script,
  qt6Packages,
  # nativeBuildInputs
  pkg-config,
  cmake,
  kdePackages,
  # buildInputs
  sqlite,
  libsecret,
  libre-graph-api-cpp-qt-client,
  kdsingleapplication,
  ## darwin only
  libinotify-kqueue,
}:

stdenv.mkDerivation rec {
  pname = "owncloud-client";
  version = "6.0.2";

  src = fetchFromGitHub {
    owner = "owncloud";
    repo = "client";
    tag = "v${version}";
    hash = "sha256-cqnDe9q7+qQ0MNrt48zTw6TcNYCEFgQmwXkmQCjR1Uc=";
  };

  patches = [
    (fetchpatch {
      url = "https://github.com/owncloud/client/commit/ef0791a727051191f0c0ff7bca78b10d5dd97e1e.patch";
      hash = "sha256-r/TlRjmnZdPWXZ8Kn/9GgcisWiF/qOO5X8m2ReooKWo=";
    })
  ];

  nativeBuildInputs = [
    pkg-config
    cmake
    kdePackages.extra-cmake-modules
    qt6Packages.qttools
    qt6Packages.wrapQtAppsHook
  ];

  buildInputs = [
    sqlite
    libsecret
    qt6Packages.qtbase
    qt6Packages.qtsvg # Needed for the systray icon
    qt6Packages.qtkeychain
    libre-graph-api-cpp-qt-client
    kdsingleapplication
  ]
  ++ lib.optionals stdenv.hostPlatform.isDarwin [
    libinotify-kqueue
  ];

  passthru.updateScript = nix-update-script { };

  meta = {
    description = "Synchronise your ownCloud with your computer using this desktop client";
    homepage = "https://owncloud.org";
    maintainers = with lib.maintainers; [
      qknight
      hellwolf
    ];
    platforms = lib.platforms.unix;
    license = lib.licenses.gpl2Plus;
    changelog = "https://github.com/owncloud/client/releases/tag/v${version}";
  };
}
