{
  lib,
  stdenv,
  fetchFromGitHub,
  boost,
  cmake,
  giflib,
  libjpeg,
  libpng,
  libtiff,
  libwebp,
  libjxl,
  libheif,
  libultrahdr,
  opencolorio,
  openexr,
  openjph,
  robin-map,
  unzip,
  fmt,
  bzip2,
  ptex,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "openimageio";
  version = "3.1.9.0";

  src = fetchFromGitHub {
    owner = "AcademySoftwareFoundation";
    repo = "OpenImageIO";
    tag = "v${finalAttrs.version}";
    hash = "sha256-0XN/Bcmpi3jUBtgvTlcqXLFuMS51UrzbpZ+eAb7QPRI=";
  };

  outputs = [
    "bin"
    "out"
    "dev"
    "doc"
  ];

  nativeBuildInputs = [
    cmake
    unzip
  ];

  buildInputs = [
    boost
    giflib
    libheif
    libjpeg
    libjxl
    libpng
    libtiff
    libwebp
    libultrahdr
    opencolorio
    openexr
    openjph
    robin-map
    bzip2
    ptex
  ];

  propagatedBuildInputs = [
    fmt
  ];

  cmakeFlags = [
    "-DUSE_PYTHON=OFF"
    "-DUSE_QT=OFF"
    # GNUInstallDirs
    "-DCMAKE_INSTALL_LIBDIR=lib" # needs relative path for pkg-config
    # Do not install a copy of fmt header files
    "-DINTERNALIZE_FMT=OFF"
  ];

  postFixup = ''
    substituteInPlace $dev/lib/cmake/OpenImageIO/OpenImageIOTargets-*.cmake \
      --replace "\''${_IMPORT_PREFIX}/lib/lib" "$out/lib/lib"
  '';

  meta = {
    homepage = "https://openimageio.org";
    description = "Library and tools for reading and writing images";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ yzx9 ];
    platforms = lib.platforms.unix;
  };
})
