# generated by zon2nix (https://github.com/Cloudef/zig2nix)

{
  lib,
  linkFarm,
  fetchurl,
  fetchgit,
  runCommandLocal,
  zig,
  name ? "zig-packages",
}:

let
  unpackZigArtifact =
    { name, artifact }:
    runCommandLocal name { nativeBuildInputs = [ zig ]; } ''
      hash="$(zig fetch --global-cache-dir "$TMPDIR" ${artifact})"
      mv "$TMPDIR/p/$hash" "$out"
      chmod 755 "$out"
    '';

  fetchZig =
    {
      name,
      url,
      hash,
    }:
    let
      artifact = fetchurl { inherit url hash; };
    in
    unpackZigArtifact { inherit name artifact; };

  fetchGitZig =
    {
      name,
      url,
      hash,
      rev ? throw "rev is required, remove and regenerate the zon2json-lock file",
    }:
    let
      parts = lib.splitString "#" url;
      url_base = lib.elemAt parts 0;
      url_without_query = lib.elemAt (lib.splitString "?" url_base) 0;
    in
    fetchgit {
      inherit name rev hash;
      url = url_without_query;
      deepClone = false;
    };

  fetchZigArtifact =
    {
      name,
      url,
      hash,
      ...
    }@args:
    let
      parts = lib.splitString "://" url;
      proto = lib.elemAt parts 0;
      path = lib.elemAt parts 1;
      fetcher = {
        "git+http" = fetchGitZig (
          args
          // {
            url = "http://${path}";
          }
        );
        "git+https" = fetchGitZig (
          args
          // {
            url = "https://${path}";
          }
        );
        http = fetchZig {
          inherit name hash;
          url = "http://${path}";
        };
        https = fetchZig {
          inherit name hash;
          url = "https://${path}";
        };
      };
    in
    fetcher.${proto};
in
linkFarm name [
  {
    name = "imgz-0.2.0-BqHzkKdnCwCNWVkntlBIrAD-_DByuc4fQQN7xy0pB-D6";
    path = fetchZigArtifact {
      name = "imgz";
      url = "git+https://github.com/shreyassanthu77/imgz.git#0ab36f0649772a5dd93d9eab9e7a8a22082a9256";
      hash = "sha256-JuYja284173noSQ4r8FkUuVasw7o8eqpRdrd+p7RYRU=";
      rev = "0ab36f0649772a5dd93d9eab9e7a8a22082a9256";
    };
  }
  {
    name = "N-V-__8AAModCAATNPKPcCapFcZFQHw0a8VjUyjAokEkvmW7";
    path = fetchZigArtifact {
      name = "spng_upstream";
      url = "https://github.com/randy408/libspng/archive/refs/tags/v0.7.4.zip";
      hash = "sha256-eokGtSeXby2SYlRVg1HpKosinTLwMwBInGnzGI0xyG4=";
    };
  }
  {
    name = "N-V-__8AAPdUlQAUAx3gzEYFfTSNog15JPi1d6S5uDyDt-qA";
    path = fetchZigArtifact {
      name = "libjpeg_turbo_upstream";
      url = "https://github.com/libjpeg-turbo/libjpeg-turbo/archive/refs/tags/3.1.2.zip";
      hash = "sha256-bgBBn9o4FVDeGE2jxmIEHnvhEgL4Cj7Bd5VNVSIcJ1c=";
    };
  }
  {
    name = "N-V-__8AAM5leQDoUCIdk0aoRB23XUlXRCDajkBojfoAcK9q";
    path = fetchZigArtifact {
      name = "libtiff_upstream";
      url = "https://gitlab.com/libtiff/libtiff/-/archive/57dd777d7f4ec687e067dc51ec99877e774b57fe/libtiff-57dd777d7f4ec687e067dc51ec99877e774b57fe.tar.gz";
      hash = "sha256-ylvL3HHDXhuKy2SI/4U2BZka5w/GBqSSSOhvKp4fhd0=";
    };
  }
  {
    name = "zlib-1.3.1-ZZQ7lbYMAAB1hTSOKSXAKAgHsfDcyWNH_37ojw5WSpgR";
    path = fetchZigArtifact {
      name = "zlib";
      url = "git+https://github.com/allyourcodebase/zlib#61e7df7e996ec5a5f13a653db3c419adb340d6ef";
      hash = "sha256-Z9TlunK+ISlTPbudB63dpkGeQO+5epGdAI4qfBd9ra0=";
      rev = "61e7df7e996ec5a5f13a653db3c419adb340d6ef";
    };
  }
  {
    name = "N-V-__8AAB0eQwD-0MdOEBmz7intriBReIsIDNlukNVoNu6o";
    path = fetchZigArtifact {
      name = "zlib";
      url = "https://github.com/madler/zlib/archive/refs/tags/v1.3.1.tar.gz";
      hash = "sha256-F+iIY/NgBnKrSRgvIXKBtvxNPHYr3jYZNeQ2qVIU0Fw=";
    };
  }
  {
    name = "zstd-1.5.7-KEItkJ8vAAC5_rRlKmLflYQ-eKXbAIQBWZNmmJtS18q0";
    path = fetchZigArtifact {
      name = "zstd";
      url = "git+https://github.com/allyourcodebase/zstd.git?ref=1.5.7#01327d49cbc56dc24c20a167bb0055d7fc23de84";
      hash = "sha256-1w+hR2U9t6R4sNvUMynDsYO0sNAan2svjxjUvxT+x6A=";
      rev = "01327d49cbc56dc24c20a167bb0055d7fc23de84";
    };
  }
  {
    name = "N-V-__8AAGxifwAAGwXwvsnl_aOXFGLZTeYCu0WBhuEXr96u";
    path = fetchZigArtifact {
      name = "zstd";
      url = "git+https://github.com/facebook/zstd.git?ref=v1.5.7#f8745da6ff1ad1e7bab384bd1f9d742439278e99";
      hash = "sha256-tNFWIT9ydfozB8dWcmTMuZLCQmQudTFJIkSr0aG7S44=";
      rev = "f8745da6ff1ad1e7bab384bd1f9d742439278e99";
    };
  }
  {
    name = "N-V-__8AAAgPfAB2dLHqe8Vw--VN8ULPqqYFewfk4tobT8ov";
    path = fetchZigArtifact {
      name = "libwebp_upstream";
      url = "git+https://github.com/webmproject/libwebp.git#23359a1039d054b6e46ca97fa8789a755457fbd5";
      hash = "sha256-CrFA9utsqHc5UE8ue6yqMTlUQCjFDpOMYPK6aB0dRd4=";
      rev = "23359a1039d054b6e46ca97fa8789a755457fbd5";
    };
  }
]
