{
  lib,
  rustPlatform,
  fetchFromGitHub,
  pkg-config,
}:

rustPlatform.buildRustPackage (finalAttrs: {
  pname = "meowpdf";
  version = "1.2.2";

  src = fetchFromGitHub {
    owner = "monoamine11231";
    repo = "meowpdf";
    tag = "v${finalAttrs.version}";
    hash = "sha256-Q3upQj7ppusWzrmESuPJrBO9kLde9lPLKA1b4jXrKQ0=";
  };

  cargoHash = "sha256-qhoTOYR2K49Bhipnar/RxFFHvTTlwx1kS3YArPlYm/I=";

  nativeBuildInputs = [
    pkg-config
    rustPlatform.bindgenHook
  ];

  meta = {
    description = "PDF viewer for the Kitty terminal with GUI-like usage and Vim-like keybindings written in Rust";
    homepage = "https://github.com/monoamine11231/meowpdf";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [
      arthsmn
      cafkafk
    ];
    mainProgram = "meowpdf";
    platforms = lib.platforms.linux;
  };
})
