{
  lib,
  stdenv,
  fetchFromGitHub,
  linuxHeaders,
}:

stdenv.mkDerivation rec {
  pname = "linuxptp";
  version = "4.4";

  src = fetchFromGitHub {
    owner = "nwtime";
    repo = "linuxptp";
    rev = "v${version}";
    hash = "sha256-w1buo+D8Mnd6ytMhQYhvCDqt+RejlNSN/iVjrDR+Khk=";
  };

  outputs = [
    "out"
    "man"
  ];

  postPatch = ''
    substituteInPlace incdefs.sh --replace-fail \
       '/usr/include/linux/' "${linuxHeaders}/include/linux/"
  '';

  makeFlags = [
    "prefix="
    "CROSS_COMPILE=${stdenv.cc.targetPrefix}"
  ];

  preInstall = ''
    export DESTDIR=$out
  '';

  enableParallelBuilding = true;

  meta = {
    description = "Implementation of the Precision Time Protocol (PTP) according to IEEE standard 1588 for Linux";
    homepage = "https://linuxptp.nwtime.org";
    maintainers = [ lib.maintainers.markuskowa ];
    license = lib.licenses.gpl2Only;
    platforms = lib.platforms.linux;
  };
}
