{
  lib,
  stdenv,
  fetchFromGitHub,
  cmake,
  boost,
  curl,
  leatherman,
}:

stdenv.mkDerivation rec {
  pname = "libwhereami";
  version = "0.5.0";

  src = fetchFromGitHub {
    sha256 = "05fc28dri2h858kxbvldk5b6wd5is3fjcdsiqj3nxf95i66bb3xp";
    rev = version;
    repo = "libwhereami";
    owner = "puppetlabs";
  };

  # CMake 2.2.2 is deprecated and no longer supported by CMake > 4
  # https://github.com/NixOS/nixpkgs/issues/445447
  postPatch = ''
    substituteInPlace CMakeLists.txt --replace-fail \
      "cmake_minimum_required(VERSION 3.2.2)" \
      "cmake_minimum_required(VERSION 3.10)"
  '';

  env.NIX_CFLAGS_COMPILE = "-Wno-error";

  nativeBuildInputs = [ cmake ];

  buildInputs = [
    boost
    curl
    leatherman
  ];

  meta = {
    inherit (src.meta) homepage;
    description = "Library to report hypervisor information from inside a VM";
    license = lib.licenses.asl20;
    maintainers = [ lib.maintainers.womfoo ];
    platforms = [
      "i686-linux"
      "x86_64-linux"
      "x86_64-darwin"
    ]; # fails on aarch64
  };

}
