{
  lib,
  stdenv,
  fetchFromGitHub,
  cmake,
  pkg-config,
  libusb1,
}:

stdenv.mkDerivation {
  pname = "libuvc";
  version = "unstable-2020-11-29";

  src = fetchFromGitHub {
    owner = "libuvc";
    repo = "libuvc";
    rev = "5cddef71b17d41f7e98875a840c50d9704c3d2b2";
    sha256 = "0kranb0x1k5qad8rwxnn1w9963sbfj2cfzdgpfmlivb04544m2j7";
  };

  # Upstream doesn't yet support CMake 4, remove once fixed
  postPatch = ''
    substituteInPlace CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 3.1)" "cmake_minimum_required(VERSION 3.5)"
  '';

  nativeBuildInputs = [
    cmake
    pkg-config
  ];

  buildInputs = [ libusb1 ];

  meta = {
    homepage = "https://ken.tossell.net/libuvc/";
    description = "Cross-platform library for USB video devices";
    platforms = lib.platforms.linux;
    license = lib.licenses.lgpl21Plus;
    maintainers = with lib.maintainers; [ prusnak ];
  };
}
