{
  lib,
  stdenv,
  build2,
  fetchurl,
  enableShared ? !stdenv.hostPlatform.isStatic,
  enableStatic ? !enableShared,
}:
stdenv.mkDerivation rec {
  pname = "libodb";
  version = "2.5.0-b.27";

  outputs = [
    "out"
    "dev"
    "doc"
  ];

  src = fetchurl {
    url = "https://pkg.cppget.org/1/beta/odb/libodb-${version}.tar.gz";
    hash = "sha256-04Et/wHYsWvJPLlcL0J2iOPV2SBFC6J32EleGw38K2Q=";
  };

  nativeBuildInputs = [ build2 ];
  build2ConfigureFlags = [
    "config.bin.lib=${build2.configSharedStatic enableShared enableStatic}"
  ];

  doCheck = true;

  meta = {
    description = "Common ODB runtime library";
    longDescription = ''
      ODB is an object-relational mapping (ORM) system for C++. It provides
      tools, APIs, and library support that allow you to persist C++ objects
      to a relational database (RDBMS) without having to deal with tables,
      columns, or SQL and without manually writing any of the mapping code.
      For more information see:

      http://www.codesynthesis.com/products/odb/

      This package contains the common ODB runtime library. Every application
      that includes code generated by the ODB compiler will need to link to
      this library.
    '';
    homepage = "https://www.codesynthesis.com/products/odb/";
    changelog = "https://git.codesynthesis.com/cgit/odb/libodb/tree/NEWS";
    license = lib.licenses.gpl2Only;
    maintainers = with lib.maintainers; [ r-burns ];
    platforms = lib.platforms.all;
  };
}
