{
  lib,
  stdenv,
  fetchurl,
  fetchpatch,
  updateAutotoolsGnuConfigScriptsHook,
  # Note: -static hasn’t work on darwin
  static ? with stdenv.hostPlatform; isStatic && !isDarwin,
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "libev";
  version = "4.33";

  src = fetchurl {
    url = "http://dist.schmorp.de/libev/Attic/${pname}-${version}.tar.gz";
    sha256 = "1sjs4324is7fp21an4aas2z4dwsvs6z4xwrmp72vwpq1s6wbfzjh";
  };

  patches = [
    (fetchpatch {
      url = "https://raw.githubusercontent.com/freebsd/freebsd-ports/21a6f0f5829384117dfc1ed11ad67954562ef7d6/devel/libev/files/patch-ev.c";
      hash = "sha256-jaeJuCYM/U2ZNbbyA/7YOKvo0lj7Dc9L3LNJfZwcaw0=";
      extraPrefix = "";
    })
  ];

  nativeBuildInputs = [ updateAutotoolsGnuConfigScriptsHook ];

  configureFlags = lib.optional static "LDFLAGS=-static";

  makeFlags =
    # doing this in configureFlags causes configure to fail
    lib.optional (!static && stdenv.hostPlatform.isCygwin) "LDFLAGS=-no-undefined";

  meta = {
    description = "High-performance event loop/event model with lots of features";
    maintainers = [ lib.maintainers.raskin ];
    platforms = lib.platforms.all;
    license = lib.licenses.bsd2; # or GPL2+
  };
}
