{
  stdenv,
  lib,
  fetchFromGitHub,
  cmake,
}:

stdenv.mkDerivation rec {
  pname = "libbtbb";
  version = "2020-12-R1";

  src = fetchFromGitHub {
    owner = "greatscottgadgets";
    repo = "libbtbb";
    rev = version;
    sha256 = "1byv8174xam7siakr1p0523x97wkh0fmwmq341sd3g70qr2g767d";
  };

  nativeBuildInputs = [ cmake ];

  postPatch = ''
    # https://github.com/NixOS/nixpkgs/issues/445447
    substituteInPlace CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 2.8)" "cmake_minimum_required(VERSION 3.10)"

    # https://github.com/greatscottgadgets/libbtbb/issues/63
    substituteInPlace lib/libbtbb.pc.in \
      --replace '$'{prefix}/@CMAKE_INSTALL_LIBDIR@ @CMAKE_INSTALL_FULL_LIBDIR@ \
      --replace '$'{prefix}/@CMAKE_INSTALL_INCLUDEDIR@ @CMAKE_INSTALL_FULL_INCLUDEDIR@
  '';

  meta = {
    description = "Bluetooth baseband decoding library";
    homepage = "https://github.com/greatscottgadgets/libbtbb";
    license = lib.licenses.gpl2;
    maintainers = with lib.maintainers; [ oxzi ];
  };
}
