{
  stdenv,
  lib,
  fetchFromGitHub,
  asciidoc,
  cmake,
  docbook_xsl,
  pkg-config,
  bash-completion,
  openssl,
  curl,
  libxml2,
  libxslt,
  fetchpatch,
}:

stdenv.mkDerivation rec {
  pname = "lastpass-cli";
  version = "1.6.1";

  src = fetchFromGitHub {
    owner = "lastpass";
    repo = "lastpass-cli";
    rev = "v${version}";
    sha256 = "sha256-Q0ZG5Ehg29STLeAerMoLfzjaH9JyPk7269RgiPmDJV8=";
  };

  nativeBuildInputs = [
    asciidoc
    cmake
    docbook_xsl
    pkg-config
  ];

  buildInputs = [
    bash-completion
    curl
    openssl
    libxml2
    libxslt
  ];

  installTargets = [
    "install"
    "install-doc"
  ];

  patches = [
    # CMake 3.1 is deprecated and no longer supported by CMake > 4
    # https://github.com/NixOS/nixpkgs/issues/445447
    # The patch comes from https://github.com/lastpass/lastpass-cli/pull/716 while
    # it is not merged and integrated in a new release.
    ./716-bump-cmake-minimum-version.patch
  ];

  postInstall = ''
    install -Dm644 -T ../contrib/lpass_zsh_completion $out/share/zsh/site-functions/_lpass
    install -Dm644 -T ../contrib/completions-lpass.fish $out/share/fish/vendor_completions.d/lpass.fish
    install -Dm755 -T ../contrib/examples/git-credential-lastpass $out/bin/git-credential-lastpass
  '';

  meta = {
    description = "Stores, retrieves, generates, and synchronizes passwords securely";
    homepage = "https://github.com/lastpass/lastpass-cli";
    license = lib.licenses.gpl2Plus;
    platforms = lib.platforms.unix;
    maintainers = with lib.maintainers; [ vinylen ];
  };
}
