{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule rec {
  pname = "kubexit";
  version = "0.3.2";

  src = fetchFromGitHub {
    owner = "karlkfi";
    repo = "kubexit";
    rev = "v${version}";
    hash = "sha256-Kzom+/Xad6SI9czw4xvmTbJ+bNB9mF2oSq37IFn384U=";
  };

  vendorHash = "sha256-RA3+S5Pad+4mNUgcZ2Z0K0FKA3Za5o1ko049GM4yQQ8=";
  ldflags = [
    "-s"
    "-w"
  ];
  meta = {
    description = "Command supervisor for coordinated Kubernetes pod container termination";
    mainProgram = "kubexit";
    homepage = "https://github.com/karlkfi/kubexit/";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ qjoly ];
  };
}
