{
  stdenv,
  lib,
  fetchurl,
  gjs,
  glib,
  gobject-introspection,
  gtk3,
  gtk4,
  gcr_4,
  libadwaita,
  meson,
  ninja,
  pango,
  pkg-config,
  vala,
  desktop-file-utils,
  wrapGAppsHook3,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "gpaste";
  version = "45.3";

  src = fetchurl {
    url = "https://www.imagination-land.org/files/gpaste/GPaste-${finalAttrs.version}.tar.xz";
    hash = "sha256-UU8pw7bqEwg2Vh7S6GTx8swI/2IhlwjQgkGNZCzoMwc=";
  };

  patches = [
    ./fix-paths.patch
  ];

  # TODO: switch to substituteAll with placeholder
  # https://github.com/NixOS/nix/issues/1846
  postPatch = ''
    substituteInPlace src/libgpaste/gpaste/gpaste-settings.c \
      --subst-var-by gschemasCompiled ${glib.makeSchemaPath (placeholder "out") "${finalAttrs.pname}-${finalAttrs.version}"}

    substituteInPlace src/gnome-shell/metadata.json.in --replace-fail \
      '"shell-version": [ "45", "46", "47", "48" ],' \
      '"shell-version": [ "45", "46", "47", "48", "49" ],'
  '';

  nativeBuildInputs = [
    gobject-introspection
    meson
    ninja
    pkg-config
    vala
    desktop-file-utils
    wrapGAppsHook3
  ];

  buildInputs = [
    gjs
    glib
    gtk3
    gtk4
    gcr_4
    libadwaita
    pango
  ];

  mesonFlags = [
    (lib.mesonOption "control-center-keybindings-dir" "${placeholder "out"}/share/gnome-control-center/keybindings")
    (lib.mesonOption "dbus-services-dir" "${placeholder "out"}/share/dbus-1/services")
    (lib.mesonOption "systemd-user-unit-dir" "${placeholder "out"}/etc/systemd/user")
  ];

  postInstall = ''
    # We do not have central location to install typelibs to,
    # let’s ensure GNOME Shell can still find them.
    extensionDir="$out/share/gnome-shell/extensions/GPaste@gnome-shell-extensions.gnome.org"
    mv "$extensionDir/"{extension,.extension-wrapped}.js
    mv "$extensionDir/"{prefs,.prefs-wrapped}.js
    substitute "${./wrapper.js}" "$extensionDir/extension.js" \
      --subst-var-by originalName "extension" \
      --subst-var-by typelibDir "${placeholder "out"}/lib/girepository-1.0"
    substitute "${./wrapper.js}" "$extensionDir/prefs.js" \
      --subst-var-by originalName "prefs" \
      --subst-var-by typelibDir "${placeholder "out"}/lib/girepository-1.0"
  '';

  meta = {
    homepage = "https://github.com/Keruspe/GPaste";
    changelog = "https://github.com/Keruspe/GPaste/blob/v${finalAttrs.version}/NEWS";
    description = "Clipboard management system with GNOME integration";
    mainProgram = "gpaste-client";
    license = lib.licenses.bsd2;
    platforms = lib.platforms.linux;
    teams = [ lib.teams.gnome ];
  };
})
