{
  copyDesktopItems,
  fetchurl,
  glib,
  adwaita-icon-theme,
  gtk3,
  jre,
  lib,
  makeDesktopItem,
  stdenv,
  wrapGAppsHook3,
}:

stdenv.mkDerivation rec {
  pname = "deepgit";
  version = "4.4";

  src = fetchurl {
    url = "https://www.syntevo.com/downloads/deepgit/deepgit-linux-${
      lib.replaceStrings [ "." ] [ "_" ] version
    }.tar.gz";
    hash = "sha256-ILqwXDyW7/hZzoSxxaxv4bF5xsB/JFaOBYAJFb7xmdk=";
  };

  nativeBuildInputs = [
    copyDesktopItems
    wrapGAppsHook3
  ];

  buildInputs = [
    adwaita-icon-theme
    gtk3
    jre
  ];

  preFixup = ''
    gappsWrapperArgs+=(
      --prefix LD_LIBRARY_PATH : ${
        lib.makeLibraryPath [
          glib
          gtk3
        ]
      }
      --set DEEPGIT_JAVA_HOME ${jre}
    )
    patchShebangs bin/deepgit.sh
  '';

  desktopItems = [
    (makeDesktopItem rec {
      name = "deepgit";
      desktopName = "DeepGit";
      keywords = [ "git" ];
      comment = "Git-Client";
      categories = [
        "Development"
        "RevisionControl"
      ];
      terminal = false;
      startupNotify = true;
      startupWMClass = desktopName;
      exec = "deepgit";
      mimeTypes = [
        "x-scheme-handler/deepgit"
        "x-scheme-handler/sourcetree"
      ];
      icon = "deepgit";
    })
  ];

  installPhase = ''
    runHook preInstall

    mkdir -pv $out/{bin,share/icons/hicolor/scalable/apps/}
    cp -a lib license.html $out
    mv bin/deepgit.sh $out/bin/deepgit

    for icon_size in 32 48 64 128 256; do
      path=$icon_size'x'$icon_size
      icon=bin/deepgit-$icon_size.png
      mkdir -p $out/share/icons/hicolor/$path/apps
      cp $icon $out/share/icons/hicolor/$path/apps/deepgit.png
    done

    runHook postInstall
  '';

  meta = {
    description = "Tool to investigate the history of source code";
    homepage = "https://www.syntevo.com/deepgit";
    changelog = "https://www.syntevo.com/deepgit/changelog.txt";
    license = lib.licenses.unfree;
    maintainers = [ ];
    platforms = lib.platforms.linux;
    mainProgram = "deepgit";
  };
}
