{
  lib,
  stdenv,
  fetchurl,
  fetchpatch2,
  makeWrapper,
  pkg-config,
  kronosnet,
  nss,
  nspr,
  libqb,
  systemd,
  dbus,
  rdma-core,
  libstatgrab,
  net-snmp,
  enableDbus ? false,
  enableInfiniBandRdma ? false,
  enableMonitoring ? false,
  enableSnmp ? false,
  nixosTests,
}:

let
  inherit (lib) optional;
in
stdenv.mkDerivation rec {
  pname = "corosync";
  version = "3.1.9";

  src = fetchurl {
    url = "http://build.clusterlabs.org/corosync/releases/${pname}-${version}.tar.gz";
    sha256 = "sha256-IDNUu93uGpezxQoHbq6JxjX0Bt1nTMrvyUu5CSrNlTU=";
  };

  patches = [
    (fetchpatch2 {
      name = "CVE-2025-30472.patch";
      url = "https://github.com/corosync/corosync/commit/7839990f9cdf34e55435ed90109e82709032466a.patch??full_index=1";
      hash = "sha256-EgGTfOM9chjLnb1QWNGp6IQQKQGdetNkztdddXlN/uo=";
    })
  ];

  nativeBuildInputs = [
    makeWrapper
    pkg-config
  ];

  buildInputs = [
    kronosnet
    nss
    nspr
    libqb
    systemd.dev
  ]
  ++ optional enableDbus dbus
  ++ optional enableInfiniBandRdma rdma-core
  ++ optional enableMonitoring libstatgrab
  ++ optional enableSnmp net-snmp;

  configureFlags = [
    "--sysconfdir=/etc"
    "--localstatedir=/var"
    "--with-logdir=/var/log/corosync"
    "--enable-watchdog"
    "--enable-qdevices"
    # allows Type=notify in the systemd service
    "--enable-systemd"
  ]
  ++ optional enableDbus "--enable-dbus"
  ++ optional enableInfiniBandRdma "--enable-rdma"
  ++ optional enableMonitoring "--enable-monitoring"
  ++ optional enableSnmp "--enable-snmp";

  installFlags = [
    "sysconfdir=$(out)/etc"
    "localstatedir=$(out)/var"
    "COROSYSCONFDIR=$(out)/etc/corosync"
    "INITDDIR=$(out)/etc/init.d"
    "LOGROTATEDIR=$(out)/etc/logrotate.d"
  ];

  enableParallelBuilding = true;

  preConfigure = lib.optionalString enableInfiniBandRdma ''
    # configure looks for the pkg-config files
    # of librdmacm and libibverbs
    # Howver, rmda-core does not provide a pkg-config file
    # We give the flags manually here:
    export rdmacm_LIBS=-lrdmacm
    export rdmacm_CFLAGS=" "
    export ibverbs_LIBS=-libverbs
    export ibverbs_CFLAGS=" "
  '';

  postInstall = ''
    wrapProgram $out/bin/corosync-blackbox \
      --prefix PATH ":" "$out/sbin:${libqb}/sbin"
  '';

  passthru.tests = {
    inherit (nixosTests) pacemaker;
  };

  meta = {
    homepage = "https://corosync.org/";
    description = "Group Communication System with features for implementing high availability within applications";
    license = lib.licenses.bsd3;
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [
      montag451
      ryantm
    ];
  };
}
