{
  lib,
  stdenv,
  fetchFromGitHub,
  pkg-config,
  glib,
  glibc,
  libseccomp,
  systemdMinimal,
  nixosTests,
  versionCheckHook,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "conmon";
  version = "2.2.0";

  src = fetchFromGitHub {
    owner = "containers";
    repo = "conmon";
    tag = "v${finalAttrs.version}";
    hash = "sha256-RVzjqTqw1NGAzXwiAKekByXA1aGgFrfwo3RtGKrfODk=";
    leaveDotGit = true;
    postFetch = ''
      cd $out
      git rev-parse HEAD > COMMIT
      rm -rf .git
    '';
  };

  preConfigure = ''
    substituteInPlace Makefile \
      --replace-fail "(GIT_COMMIT)" "(shell cat COMMIT)"
  '';

  nativeBuildInputs = [ pkg-config ];
  buildInputs = [
    glib
    libseccomp
    systemdMinimal
  ]
  ++ lib.optionals (!stdenv.hostPlatform.isMusl) [
    glibc
    glibc.static
  ];

  # manpage requires building the vendored go-md2man
  makeFlags = [
    "bin/conmon"
  ];

  installPhase = ''
    runHook preInstall
    install -D bin/conmon -t $out/bin
    runHook postInstall
  '';

  enableParallelBuilding = true;
  strictDeps = true;

  passthru.tests = { inherit (nixosTests) cri-o podman; };

  doInstallCheck = true;
  nativeInstallCheckInputs = [ versionCheckHook ];
  versionCheckProgramArg = "--version";

  meta = {
    changelog = "https://github.com/containers/conmon/releases/tag/${finalAttrs.src.tag}";
    homepage = "https://github.com/containers/conmon";
    description = "OCI container runtime monitor";
    license = lib.licenses.asl20;
    teams = [ lib.teams.podman ];
    platforms = lib.platforms.linux;
    mainProgram = "conmon";
  };
})
