{
  ballerina,
  lib,
  writeText,
  runCommand,
  makeWrapper,
  fetchzip,
  stdenv,
  openjdk17_headless,
}:
let
  version = "2201.10.3";
  codeName = "swan-lake";
  openjdk = openjdk17_headless;
in
stdenv.mkDerivation {
  pname = "ballerina";
  inherit version;

  src = fetchzip {
    url = "https://dist.ballerina.io/downloads/${version}/ballerina-${version}-${codeName}.zip";
    hash = "sha256-JVwxWRiOQaUZBkvxoLhKvktyQYnBtbCBZXZa6g6hoRQ=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall
    cp -rv distributions/ballerina-${version} $out
    runHook postInstall
  '';
  preFixup = ''
    wrapProgram $out/bin/bal --set JAVA_HOME ${openjdk}
  '';

  passthru.tests.smokeTest =
    let
      helloWorld = writeText "hello-world.bal" ''
        import ballerina/io;
        public function main() {
          io:println("Hello, World!");
        }
      '';
    in
    runCommand "ballerina-${version}-smoketest" { } ''
      ${ballerina}/bin/bal run ${helloWorld} >$out
      read result <$out
      [[ $result = "Hello, World!" ]]
    '';

  meta = {
    description = "Open-source programming language for the cloud";
    mainProgram = "bal";
    license = lib.licenses.asl20;
    platforms = openjdk.meta.platforms;
    maintainers = with lib.maintainers; [ eigengrau ];
    sourceProvenance = with lib.sourceTypes; [ binaryBytecode ];
  };
}
