{
  lib,
  stdenv,
  fetchFromGitHub,
  autoreconfHook,
  fuse,
  git,
}:

stdenv.mkDerivation {
  pname = "aefs";
  version = "unstable-2015-05-06";

  src = fetchFromGitHub {
    owner = "edolstra";
    repo = "aefs";
    rev = "e7a9bf8cfa9166668fe1514cc1afd31fc4e10e9a";
    hash = "sha256-a3YQWxJ7+bYhf1W1kdIykV8U1R4dcDZJ7K3NvNxbF0s=";
  };

  # fix build with c23
  #   ../system/types.h:27:13: error: 'bool' cannot be defined via 'typedef'
  #   input.c:228:31: error: expected identifier before 'true'
  patches = [ ./fix-build-with-c23.patch ];

  # autoconf's AC_CHECK_HEADERS and AC_CHECK_LIBS fail to detect libfuse on
  # Darwin if FUSE_USE_VERSION isn't set at configure time.
  #
  # NOTE: Make sure the value of FUSE_USE_VERSION specified here matches the
  # actual version used in the source code:
  #
  #     $ tar xf "$(nix-build -A aefs.src)"
  #     $ grep -R FUSE_USE_VERSION
  configureFlags = lib.optional stdenv.hostPlatform.isDarwin "CPPFLAGS=-DFUSE_USE_VERSION=26";

  nativeBuildInputs = [
    autoreconfHook
    git
  ];

  buildInputs = [ fuse ];

  meta = {
    homepage = "https://github.com/edolstra/aefs";
    description = "Cryptographic filesystem implemented in userspace using FUSE";
    maintainers = [ ];
    license = lib.licenses.gpl2Plus;
    platforms = lib.platforms.unix;
    broken = stdenv.hostPlatform.isDarwin;
  };
}
