# Release 19.03 ("Koi", 2019/04/11) {#sec-release-19.03}

## Highlights {#sec-release-19.03-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- End of support is planned for end of October 2019, handing over to 19.09.

- The default Python 3 interpreter is now CPython 3.7 instead of CPython 3.6.

- Added the Pantheon desktop environment. It can be enabled through `services.xserver.desktopManager.pantheon.enable`.

  ::: {.note}
  By default, `services.xserver.desktopManager.pantheon` enables LightDM as a display manager, as pantheon's screen locking implementation relies on it.
  Because of that it is recommended to leave LightDM enabled. If you'd like to disable it anyway, set `services.xserver.displayManager.lightdm.enable` to `false` and enable your preferred display manager.
  :::

  Also note that Pantheon's LightDM greeter is not enabled by default, because it has numerous issues in NixOS and isn't optimal for use here yet.

- A major refactoring of the Kubernetes module has been completed. Refactorings primarily focus on decoupling components and enhancing security. Two-way TLS and RBAC has been enabled by default for all components, which slightly changes the way the module is configured. See: [](#sec-kubernetes) for details.

- There is now a set of `confinement` options for `systemd.services`, which allows to restrict services into a chroot 2 ed environment that only contains the store paths from the runtime closure of the service.

## New Services {#sec-release-19.03-new-services}

The following new services were added since the last release:

- `./programs/nm-applet.nix`

- There is a new `security.googleOsLogin` module for using [OS Login](https://cloud.google.com/compute/docs/instances/managing-instance-access) to manage SSH access to Google Compute Engine instances, which supersedes the imperative and broken `google-accounts-daemon` used in `nixos/modules/virtualisation/google-compute-config.nix`.

- `./services/misc/beanstalkd.nix`

- There is a new `services.cockroachdb` module for running CockroachDB databases. NixOS now ships with CockroachDB 2.1.x as well, available on `x86_64-linux` and `aarch64-linux`.

- `./security/duosec.nix`

- The [PAM module for Duo Security](https://duo.com/docs/duounix) has been enabled for use. One can configure it using the `security.duosec` options along with the corresponding PAM option in `security.pam.services.<name?>.duoSecurity.enable`.

## Backward Incompatibilities {#sec-release-19.03-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- The minimum version of Nix required to evaluate Nixpkgs is now 2.0.

  - For users of NixOS 18.03 and 19.03, NixOS defaults to Nix 2.0, but supports using Nix 1.11 by setting `nix.package = pkgs.nix1;`. If this option is set to a Nix 1.11 package, you will need to either unset the option or upgrade it to Nix 2.0.

  - For users of NixOS 17.09, you will first need to upgrade Nix by setting `nix.package = pkgs.nixStable2;` and run `nixos-rebuild switch` as the `root` user.

  - For users of a daemon-less Nix installation on Linux or macOS, you can upgrade Nix by running `curl -L https://nixos.org/nix/install | sh`, or prior to doing a channel update, running `nix-env -iA nix`. If you have already run a channel update and Nix is no longer able to evaluate Nixpkgs, the error message printed should provide adequate directions for upgrading Nix.

  - For users of the Nix daemon on macOS, you can upgrade Nix by running `sudo -i sh -c 'nix-channel --update && nix-env -iA nixpkgs.nix'; sudo launchctl stop org.nixos.nix-daemon; sudo launchctl start org.nixos.nix-daemon`.

- The `buildPythonPackage` function now sets `strictDeps = true` to help distinguish between native and non-native dependencies in order to improve cross-compilation compatibility. Note however that this may break user expressions.

- The `buildPythonPackage` function now sets `LANG = C.UTF-8` to enable Unicode support. The `glibcLocales` package is no longer needed as a build input.

- The Syncthing state and configuration data has been moved from `services.syncthing.dataDir` to the newly defined `services.syncthing.configDir`, which default to `/var/lib/syncthing/.config/syncthing`. This change makes possible to share synced directories using ACLs without Syncthing resetting the permission on every start.

- The `ntp` module now has sane default restrictions. If you're relying on the previous defaults, which permitted all queries and commands from all firewall-permitted sources, you can set `services.ntp.restrictDefault` and `services.ntp.restrictSource` to `[]`.

- Package `rabbitmq_server` is renamed to `rabbitmq-server`.

- The `light` module no longer uses setuid binaries, but udev rules. As a consequence users of that module have to belong to the `video` group in order to use the executable (i.e. `users.users.yourusername.extraGroups = ["video"];`).

- Buildbot now supports Python 3 and its packages have been moved to `pythonPackages`. The options `services.buildbot-master.package` and `services.buildbot-worker.package` can be used to select the Python 2 or 3 version of the package.

- Options `services.znc.confOptions.networks.name.userName` and `services.znc.confOptions.networks.name.modulePackages` were removed. They were never used for anything and can therefore safely be removed.

- Package `wasm` has been renamed `proglodyte-wasm`. The package `wasm` will be pointed to `ocamlPackages.wasm` in 19.09, so make sure to update your configuration if you want to keep `proglodyte-wasm`

- When the `nixpkgs.pkgs` option is set, NixOS will no longer ignore the `nixpkgs.overlays` option. The old behavior can be recovered by setting `nixpkgs.overlays = lib.mkForce [];`.

- OpenSMTPD has been upgraded to version 6.4.0p1. This release makes backwards-incompatible changes to the configuration file format. See `man smtpd.conf` for more information on the new file format.

- The versioned `postgresql` have been renamed to use underscore number separators. For example, `postgresql96` has been renamed to `postgresql_9_6`.

- Package `consul-ui` and passthrough `consul.ui` have been removed. The package `consul` now uses upstream releases that vendor the UI into the binary. See [\#48714](https://github.com/NixOS/nixpkgs/pull/48714#issuecomment-433454834) for details.

- Slurm introduces the new option `services.slurm.stateSaveLocation`, which is now set to `/var/spool/slurm` by default (instead of `/var/spool`). Make sure to move all files to the new directory or to set the option accordingly.

  The slurmctld now runs as user `slurm` instead of `root`. If you want to keep slurmctld running as `root`, set `services.slurm.user = root`.

  The options `services.slurm.nodeName` and `services.slurm.partitionName` are now sets of strings to correctly reflect that fact that each of these options can occur more than once in the configuration.

- The `solr` package has been upgraded from 4.10.3 to 7.5.0 and has undergone some major changes. The `services.solr` module has been updated to reflect these changes. Please review http://lucene.apache.org/solr/ carefully before upgrading.

- Package `ckb` is renamed to `ckb-next`, and options `hardware.ckb.*` are renamed to `hardware.ckb-next.*`.

- The option `services.xserver.displayManager.job.logToFile` which was previously set to `true` when using the display managers `lightdm`, `sddm` or `xpra` has been reset to the default value (`false`).

- Network interface indiscriminate NixOS firewall options (`networking.firewall.allow*`) are now preserved when also setting interface specific rules such as `networking.firewall.interfaces.en0.allow*`. These rules continue to use the pseudo device "default" (`networking.firewall.interfaces.default.*`), and assigning to this pseudo device will override the (`networking.firewall.allow*`) options.

- The `nscd` service now disables all caching of `passwd` and `group` databases by default. This was interfering with the correct functioning of the `libnss_systemd.so` module which is used by `systemd` to manage uids and usernames in the presence of `DynamicUser=` in systemd services. This was already the default behaviour in presence of `services.sssd.enable = true` because nscd caching would interfere with `sssd` in unpredictable ways as well. Because we're using nscd not for caching, but for convincing glibc to find NSS modules in the nix store instead of an absolute path, we have decided to disable caching globally now, as it's usually not the behaviour the user wants and can lead to surprising behaviour. Furthermore, negative caching of host lookups is also disabled now by default. This should fix the issue of dns lookups failing in the presence of an unreliable network.

  If the old behaviour is desired, this can be restored by setting the `services.nscd.config` option with the desired caching parameters.

  ```nix
  {
    services.nscd.config = ''
      server-user             nscd
      threads                 1
      paranoia                no
      debug-level             0

      enable-cache            passwd          yes
      positive-time-to-live   passwd          600
      negative-time-to-live   passwd          20
      suggested-size          passwd          211
      check-files             passwd          yes
      persistent              passwd          no
      shared                  passwd          yes

      enable-cache            group           yes
      positive-time-to-live   group           3600
      negative-time-to-live   group           60
      suggested-size          group           211
      check-files             group           yes
      persistent              group           no
      shared                  group           yes

      enable-cache            hosts           yes
      positive-time-to-live   hosts           600
      negative-time-to-live   hosts           5
      suggested-size          hosts           211
      check-files             hosts           yes
      persistent              hosts           no
      shared                  hosts           yes
    '';
  }
  ```

  See [\#50316](https://github.com/NixOS/nixpkgs/pull/50316) for details.

- GitLab Shell previously used the nix store paths for the `gitlab-shell` command in its `authorized_keys` file, which might stop working after garbage collection. To circumvent that, we regenerated that file on each startup. As `gitlab-shell` has now been changed to use `/var/run/current-system/sw/bin/gitlab-shell`, this is not necessary anymore, but there might be leftover lines with a nix store path. Regenerate the `authorized_keys` file via `sudo -u git -H gitlab-rake gitlab:shell:setup` in that case.

- The `pam_unix` account module is now loaded with its control field set to `required` instead of `sufficient`, so that later PAM account modules that might do more extensive checks are being executed. Previously, the whole account module verification was exited prematurely in case a nss module provided the account name to `pam_unix`. The LDAP and SSSD NixOS modules already add their NSS modules when enabled. In case your setup breaks due to some later PAM account module previously shadowed, or failing NSS lookups, please file a bug. You can get back the old behaviour by manually setting `security.pam.services.<name?>.text`.

- The `pam_unix` password module is now loaded with its control field set to `sufficient` instead of `required`, so that password managed only by later PAM password modules are being executed. Previously, for example, changing an LDAP account's password through PAM was not possible: the whole password module verification was exited prematurely by `pam_unix`, preventing `pam_ldap` to manage the password as it should.

- `fish` has been upgraded to 3.0. It comes with a number of improvements and backwards incompatible changes. See the `fish` [release notes](https://github.com/fish-shell/fish-shell/releases/tag/3.0.0) for more information.

- The ibus-table input method has had a change in config format, which causes all previous settings to be lost. See [this commit message](https://github.com/mike-fabian/ibus-table/commit/f9195f877c5212fef0dfa446acb328c45ba5852b) for details.

- NixOS module system type `types.optionSet` and `lib.mkOption` argument `options` are deprecated. Use `types.submodule` instead. ([\#54637](https://github.com/NixOS/nixpkgs/pull/54637))

- `matrix-synapse` has been updated to version 0.99. It will [no longer generate a self-signed certificate on first launch](https://github.com/matrix-org/synapse/pull/4509) and will be [the last version to accept self-signed certificates](https://matrix.org/blog/2019/02/05/synapse-0-99-0/). As such, it is now recommended to use a proper certificate verified by a root CA (for example Let's Encrypt). The new [manual chapter on Matrix](#module-services-matrix) contains a working example of using nginx as a reverse proxy in front of `matrix-synapse`, using Let's Encrypt certificates.

- `mailutils` now works by default when `sendmail` is not in a setuid wrapper. As a consequence, the `sendmailPath` argument, having lost its main use, has been removed.

- `graylog` has been upgraded from version 2.\* to 3.\*. Some setups making use of extraConfig (especially those exposing Graylog via reverse proxies) need to be updated as upstream removed/replaced some settings. See [Upgrading Graylog](http://docs.graylog.org/en/3.0/pages/upgrade/graylog-3.0.html#simplified-http-interface-configuration) for details.

- The option `users.ldap.bind.password` was renamed to `users.ldap.bind.passwordFile`, and needs to be readable by the `nslcd` user. Same applies to the new `users.ldap.daemon.rootpwmodpwFile` option.

- `nodejs-6_x` is end-of-life. `nodejs-6_x`, `nodejs-slim-6_x` and `nodePackages_6_x` are removed.

## Other Notable Changes {#sec-release-19.03-notable-changes}

- The `services.matomo` module gained the option `services.matomo.package` which determines the used Matomo version.

  The Matomo module now also comes with the systemd service `matomo-archive-processing.service` and a timer that automatically triggers archive processing every hour. This means that you can safely [ disable browser triggers for Matomo archiving ](https://matomo.org/docs/setup-auto-archiving/#disable-browser-triggers-for-matomo-archiving-and-limit-matomo-reports-to-updating-every-hour) at `Administration > System > General Settings`.

  Additionally, you can enable to [ delete old visitor logs ](https://matomo.org/docs/privacy/#step-2-delete-old-visitors-logs) at `Administration > System > Privacy`, but make sure that you run `systemctl start matomo-archive-processing.service` at least once without errors if you have already collected data before, so that the reports get archived before the source data gets deleted.

- `composableDerivation` along with supporting library functions has been removed.

- The deprecated `truecrypt` package has been removed and `truecrypt` attribute is now an alias for `veracrypt`. VeraCrypt is backward-compatible with TrueCrypt volumes. Note that `cryptsetup` also supports loading TrueCrypt volumes.

- The Kubernetes DNS addons, kube-dns, has been replaced with CoreDNS. This change is made in accordance with Kubernetes making CoreDNS the official default starting from [Kubernetes v1.11](https://github.com/kubernetes/kubernetes/blob/master/CHANGELOG-1.11.md#sig-cluster-lifecycle). Please beware that upgrading DNS-addon on existing clusters might induce minor downtime while the DNS-addon terminates and re-initializes. Also note that the DNS-service now runs with 2 pod replicas by default. The desired number of replicas can be configured using: `services.kubernetes.addons.dns.replicas`.

- The quassel-webserver package and module was removed from nixpkgs due to the lack of maintainers.

- The manual gained a [ new chapter on self-hosting `matrix-synapse` and `riot-web` ](#module-services-matrix), the most prevalent server and client implementations for the [Matrix](https://matrix.org/) federated communication network.

- The astah-community package was removed from nixpkgs due to it being discontinued and the downloads not being available anymore.

- The httpd service now saves log files with a .log file extension by default for easier integration with the logrotate service.

- The owncloud server packages and httpd subservice module were removed from nixpkgs due to the lack of maintainers.

- It is possible now to uze ZRAM devices as general purpose ephemeral block devices, not only as swap. Using more than 1 device as ZRAM swap is no longer recommended, but is still possible by setting `zramSwap.swapDevices` explicitly.

  ZRAM algorithm can be changed now.

  Changes to ZRAM algorithm are applied during `nixos-rebuild switch`, so make sure you have enough swap space on disk to survive ZRAM device rebuild. Alternatively, use `nixos-rebuild boot; reboot`.

- Flat volumes are now disabled by default in `hardware.pulseaudio`. This has been done to prevent applications, which are unaware of this feature, setting their volumes to 100% on startup causing harm to your audio hardware and potentially your ears.

  ::: {.note}
  With this change application specific volumes are relative to the master volume which can be adjusted independently, whereas before they were absolute; meaning that in effect, it scaled the device-volume with the volume of the loudest application.
  :::

- The [`ndppd`](https://github.com/DanielAdolfsson/ndppd) module now supports [all config options](options.html#opt-services.ndppd.enable) provided by the current upstream version as service options. Additionally the `ndppd` package doesn't contain the systemd unit configuration from upstream anymore, the unit is completely configured by the NixOS module now.

- New installs of NixOS will default to the Redmine 4.x series unless otherwise specified in `services.redmine.package` while existing installs of NixOS will default to the Redmine 3.x series.

- The [Grafana module](options.html#opt-services.grafana.enable) now supports declarative [datasource and dashboard](http://docs.grafana.org/administration/provisioning/) provisioning.

- The use of insecure ports on kubernetes has been deprecated. Thus options: `services.kubernetes.apiserver.port` and `services.kubernetes.controllerManager.port` has been renamed to `.insecurePort`, and default of both options has changed to 0 (disabled).

- Note that the default value of `services.kubernetes.apiserver.bindAddress` has changed from 127.0.0.1 to 0.0.0.0, allowing the apiserver to be accessible from outside the master node itself. If the apiserver insecurePort is enabled, it is strongly recommended to only bind on the loopback interface. See: `services.kubernetes.apiserver.insecurebindAddress`.

- The option `services.kubernetes.apiserver.allowPrivileged` and `services.kubernetes.kubelet.allowPrivileged` now defaults to false. Disallowing privileged containers on the cluster.

- The kubernetes module does no longer add the kubernetes package to `environment.systemPackages` implicitly.

- The `intel` driver has been removed from the default list of [X.org video drivers](options.html#opt-services.xserver.videoDrivers). The `modesetting` driver should take over automatically, it is better maintained upstream and has less problems with advanced X11 features. This can lead to a change in the output names used by `xrandr`. Some performance regressions on some GPU models might happen. Some OpenCL and VA-API applications might also break (Beignet seems to provide OpenCL support with `modesetting` driver, too). Kernel mode setting API does not support backlight control, so `xbacklight` tool will not work; backlight level can be controlled directly via `/sys/` or with `brightnessctl`. Users who need this functionality more than multi-output XRandR are advised to add \`intel\` to \`videoDrivers\` and report an issue (or provide additional details in an existing one)

- Openmpi has been updated to version 4.0.0, which removes some deprecated MPI-1 symbols. This may break some older applications that still rely on those symbols. An upgrade guide can be found [here](https://www.open-mpi.org/faq/?category=mpi-removed).

  The nginx package now relies on OpenSSL 1.1 and supports TLS 1.3 by default. You can set the protocols used by the nginx service using [services.nginx.sslProtocols](options.html#opt-services.nginx.sslProtocols).

- A new subcommand `nixos-rebuild edit` was added.
