{
  lib,
  fetchFromGitHub,
  rustPlatform,
  libusb-compat-0_1,
}:

let
  version = "0.7.9";
  src = fetchFromGitHub {
    owner = "litex-hub";
    repo = "wishbone-utils";
    rev = "v${version}";
    hash = "sha256-Gl0bxHJ8Y0ytYJxToYAR2tVkD4YNMihk+zRpieSvMGE=";
  };
in
rustPlatform.buildRustPackage {
  pname = "wishbone-tool";
  inherit version;

  inherit src;

  sourceRoot = "${src.name}/wishbone-tool";

  cargoHash = "sha256-YJEsTGnBUkQ35VOwZQeBbO3RZqglLYm2xecmIS4jiZM=";

  buildInputs = [ libusb-compat-0_1 ];

  meta = {
    description = "Manipulate a Wishbone device over some sort of bridge";
    mainProgram = "wishbone-tool";
    homepage = "https://github.com/litex-hub/wishbone-utils";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ edef ];
    platforms = lib.platforms.linux;
  };
}
