{
  lib,
  stdenv,
  fetchFromGitHub,
  copyPkgconfigItems,
  makePkgconfigItem,
  version ? "2.2.0",
}:

stdenv.mkDerivation rec {
  pname = "cadical";
  inherit version;

  src = fetchFromGitHub {
    owner = "arminbiere";
    repo = "cadical";
    rev = "rel-${version}";
    hash =
      {
        "2.2.0" = "sha256-6O0lz0YJzk1eJblQ0/f9PnSYqD8WoendIZioQiGUpCg=";
        "2.1.3" = "sha256-W3kO+6nVzkmJXyHJU+NZWP0oatK3gon4EWF1/03rgL4=";
        "2.0.0" = "sha256-qoeEM9SdpuFuBPeQlCzuhPLcJ+bMQkTUTGiT8QdU8rc=";
      }
      .${version};
  };

  outputs = [
    "out"
    "dev"
    "lib"
  ];
  doCheck = true;

  nativeBuildInputs = [ copyPkgconfigItems ];

  pkgconfigItems = [
    (makePkgconfigItem {
      name = "cadical";
      inherit version;
      cflags = [ "-I\${includedir}" ];
      libs = [
        "-L\${libdir}"
        "-lcadical"
      ];
      variables = {
        includedir = "@includedir@";
        libdir = "@libdir@";
      };
      inherit (meta) description;
    })
  ];

  env = {
    # copyPkgconfigItems will substitute these in the pkg-config file
    includedir = "${placeholder "dev"}/include";
    libdir = "${placeholder "lib"}/lib";
  };

  enableParallelBuilding = true;

  # fix static build
  postPatch = ''
    substituteInPlace makefile.in --replace-fail "ar rc" '$(AR) rc'
  ''
  # Racy/flaky tests that sometimes spontaneously combust on darwin.
  + lib.optionalString (stdenv.hostPlatform.isDarwin && (lib.versionAtLeast version "2.1.1")) ''
    substituteInPlace test/api/run.sh --replace-fail 'run parcompwrite' ""
    substituteInPlace test/api/run.sh --replace-fail 'run example_tracer' ""
  '';

  # the configure script is not generated by autotools and does not accept the
  # arguments that the default configurePhase passes like --prefix and --libdir
  configurePhase = ''
    runHook preConfigure

    ./configure

    runHook postConfigure
  '';

  installPhase = ''
    runHook preInstall

    install -Dm0755 build/cadical "$out/bin/cadical"
    install -Dm0755 build/mobical "$out/bin/mobical"
    install -Dm0644 src/ccadical.h "$dev/include/ccadical.h"
    install -Dm0644 src/cadical.hpp "$dev/include/cadical.hpp"
    install -Dm0644 src/cadical.hpp "$dev/include/cadical/cadical.hpp"
    install -Dm0644 src/tracer.hpp "$dev/include/cadical/tracer.hpp"
    install -Dm0644 build/libcadical.a "$lib/lib/libcadical.a"
    mkdir -p "$out/share/doc/${pname}/"
    install -Dm0755 {LICEN?E,README*,VERSION} "$out/share/doc/${pname}/"

    runHook postInstall
  '';

  meta = {
    description = "Simplified Satisfiability Solver";
    maintainers = with lib.maintainers; [ shnarazk ];
    platforms = lib.platforms.unix;
    license = lib.licenses.mit;
    homepage = "https://fmv.jku.at/cadical/";
  };
}
