# Nixpkgs 26.05 ("Yarara", 2026.05/??) {#sec-nixpkgs-release-26.05}

## Highlights {#sec-nixpkgs-release-26.05-highlights}
<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- Create the first release note entry in this section!

## Backward Incompatibilities {#sec-nixpkgs-release-26.05-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `xfce.mkXfceDerivation` has been deprecated, please use `stdenv.mkDerivation`
  directly. You can migrate by adding `pkg-config`, `xfce4-dev-tools`, and
  `wrapGAppsHook3` to your `nativeBuildInputs` and `--enable-maintainer-mode`
  to your `configureFlags`.

- `corepack_latest` has been removed, as Corepack is no longer distributed with Node.js.

- `spoof` has been removed, as there are many issues upstream with it working on modern OS versions, and it appears to be unmaintained.

- `kanata` now requires `karabiner-dk` version 6.0+ or later.
  The package has been updated to use the new `karabiner-dk` package and the `darwinDriver` output stays at the version defined in the package.

- `elegant-sddm` has been updated to be Qt6 compatible. Themes for SDDM are slightly different so read the [wiki](https://wiki.nixos.org/wiki/SDDM_Themes) for more.

- `iroh` has been removed and split up into `iroh-dns-server` and `iroh-relay`.

- `python3Packages.gradio` has been updated to version 6. See upstream's migration guide at https://www.gradio.app/main/guides/gradio-6-migration-guide.

- `vicinae` has been updated to v0.17. Version 0.17 contains a complete overhaul of the configuration system. For update instructions, see the [release notes for v0.17.0](https://github.com/vicinaehq/vicinae/releases/tag/v0.17.0) and the [upstream configuration documentation](https://docs.vicinae.com/config).

- All Log4Shell vulnerability scanners were removed, as they were all unmaintained upstream and are no longer relevant given that the vulnerability has been fixed upstream for several years.

- Plugins for the JetBrains IDEs have been removed from Nixpkgs.

- `jetbrains.plugins.addPlugins` no longer supports plugin names or ID strings.
  You can still use `addPlugins` with plugin derivations, such as plugins packaged outside of Nixpkgs.

- `asio` (standalone version of `boost::asio`) has been updated from 1.24.0 to 1.36.0. Some breaking changes were introduced between these
  two versions, and the one affected most was the removal of `asio::io_service` in favor of `asio::io_context` in 1.33.0. `asio_1_32_0` is
  retained for packages that have not completed migration. `asio_1_10` has been removed as no packages depend on it anymore.
  `asio` also no longer propagates `boost` as it is used independent from `boost` in most cases.

- Ethercalc and its associated module have been removed, as the package is unmaintained and cannot be installed from source with npm now.

- `nodePackages.prebuild-install` was removed because it appeared to be unmaintained upstream.
  See [upstream's recommendations for alternatives](https://github.com/prebuild/prebuild-install#note).

- `davis` made changes to the `IMAP_AUTH_URL` option. The flags are now standalone parameters that you need to fill:
  - Before:
    ```env
    IMAP_AUTH_URL={imap.gmail.com:993/imap/ssl/novalidate-cert}
    ```
  - After:
    ```env
    IMAP_AUTH_URL=imap.mydomain.com:993
    IMAP_ENCRYPTION_METHOD=ssl
    IMAP_CERTIFICATE_VALIDATION=false
    ```

- `python3packages.pillow-avif-plugin` has been removed as the functionality is included in `python3packages.pillow` directly since version 11.3.

- `services.openssh.settings.AcceptEnv` now explicitly defined as an option that takes a list of strings, to facilitate option merging. Setting it to a string value is no longer supported.

- Xfce panel plugins have been moved to top level (e.g. if you previously added `pkgs.xfce.xfce4-whiskermenu-plugin` to `environment.systemPackages`, you will need to change it to `pkgs.xfce4-whiskermenu-plugin`).

## Other Notable Changes {#sec-nixpkgs-release-26.05-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `uptime-kuma` has been updated to v2, which requires an automated migration that can take a few hours. **A backup is highly recommended.**
  If your SQLite database is corrupted, the migration might fail and require [manual intervention](https://github.com/louislam/uptime-kuma/issues/5281).
  See the [migration guide](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) for more information.

- The `services.nextcloud-spreed-signaling` NixOS module has been added to facilitate declarative management of a standalone Spreed signaling server ("High Performance Backend" for Nextcloud Talk).

- `fetchPnpmDeps` and `pnpmConfigHook` were added as top-level attributes, replacing the now deprecated `pnpm.fetchDeps` and `pnpm.configHook` attributes.

- Added `dell-bios-fan-control` package and service.

- We now use the upstream wrapper script for Gradle, supporting both the `JAVA_HOME` and `GRADLE_OPTS` environment variables.

## Nixpkgs Library {#sec-nixpkgs-release-26.05-lib}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

### Breaking changes {#sec-nixpkgs-release-26.05-lib-breaking}

- The `nodejs_latest` alias now points to `nodejs_25` instead of `nodejs_24`.

- `mold` is now wrapped by default.


### Deprecations {#sec-nixpkgs-release-26.05-lib-deprecations}

- Create the first release note entry in this section!


### Additions and Improvements {#sec-nixpkgs-release-26.05-lib-additions-improvements}

- The builder `php.buildComposerProject2` for PHP applications has been improved for better reliability and stability.
