{
  lib,
  aiohttp,
  buildPythonPackage,
  click,
  fetchPypi,
  jsonpickle,
  requests,
  tabulate,
  xmltodict,
  zeroconf,
}:

buildPythonPackage rec {
  pname = "pyvizio";
  version = "0.1.61";
  format = "setuptools";

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-AtqMWe2zgRqOp5S9oKq7keHNHM8pnTmV1mfGiVzygTc=";
  };

  propagatedBuildInputs = [
    aiohttp
    click
    jsonpickle
    requests
    tabulate
    xmltodict
    zeroconf
  ];

  # Project has no tests
  doCheck = false;
  pythonImportsCheck = [ "pyvizio" ];

  meta = {
    description = "Python client for Vizio SmartCast";
    mainProgram = "pyvizio";
    homepage = "https://github.com/vkorn/pyvizio";
    license = with lib.licenses; [ gpl3Only ];
    maintainers = with lib.maintainers; [ fab ];
  };
}
