{
  lib,
  buildPythonPackage,
  chardet,
  docker,
  entrypoints,
  escapism,
  fetchFromGitHub,
  iso8601,
  jinja2,
  pkgs-docker,
  python-json-logger,
  pythonOlder,
  requests,
  ruamel-yaml,
  semver,
  setuptools,
  toml,
  traitlets,
}:

buildPythonPackage rec {
  pname = "jupyter-repo2docker";
  version = "2025.08.0";
  pyproject = true;

  disabled = pythonOlder "3.6";

  src = fetchFromGitHub {
    owner = "jupyterhub";
    repo = "repo2docker";
    tag = version;
    hash = "sha256-vqLZbqshEl3xC5hcE4OkWfZpPSlSfv70oygEYPFqyFE=";
  };

  nativeBuildInputs = [ setuptools ];

  propagatedBuildInputs = [
    chardet
    docker
    entrypoints
    escapism
    iso8601
    jinja2
    pkgs-docker
    python-json-logger
    requests
    ruamel-yaml
    semver
    toml
    traitlets
  ];

  # Tests require a running Docker instance
  doCheck = false;

  pythonImportsCheck = [
    "repo2docker"
    "repo2docker.app"
    "repo2docker.utils"
    "repo2docker.contentproviders.base"
  ];

  meta = {
    description = "Turn code repositories into Jupyter enabled Docker Images";
    homepage = "https://repo2docker.readthedocs.io/";
    changelog = "https://github.com/jupyterhub/repo2docker/blob/${src.tag}/docs/source/changelog.md";
    license = lib.licenses.bsd3;
    maintainers = [ ];
  };
}
