{
  lib,
  stdenv,
  fetchFromGitHub,
  cmake,
  qttools,
  qtbase,
  qtsvg,
  kcolorpicker,
}:

let
  isQt6 = lib.versions.major qtbase.version == "6";
in
stdenv.mkDerivation rec {
  pname = "kimageannotator";
  version = "0.7.2";

  src = fetchFromGitHub {
    owner = "ksnip";
    repo = "kImageAnnotator";
    rev = "v${version}";
    hash = "sha256-SKNNsBXmaS0ZnbMP7cKSfr+MM+ICdvYQ0k2h5s9SDcE=";
  };

  nativeBuildInputs = [
    cmake
    qttools
  ];
  buildInputs = [
    qtbase
    qtsvg
  ];
  propagatedBuildInputs = [ kcolorpicker ];

  cmakeFlags = [
    (lib.cmakeBool "BUILD_WITH_QT6" isQt6)
    (lib.cmakeBool "BUILD_SHARED_LIBS" true)
  ];

  # Library only
  dontWrapQtApps = true;

  meta = {
    description = "Tool for annotating images";
    homepage = "https://github.com/ksnip/kImageAnnotator";
    license = lib.licenses.lgpl3Plus;
    maintainers = with lib.maintainers; [ fliegendewurst ];
    platforms = lib.platforms.linux;
  };
}
