{ config, pkgs, ... }:
{
  imports = [
    ./vpsadminos.nix
  ];

  environment.systemPackages = with pkgs; [
    vim
  ];

  services.openssh = {
    enable = true;

    # Allow root login with password, needed for passwords set through vpsAdmin
    settings.PermitRootLogin = "yes";

    # Needed for public keys deployed through vpsAdmin, can be disabled if you
    # authorize your keys in configuration
    authorizedKeysInHomedir = true;
  };

  # Add your public keys
  #users.users.root.openssh.authorizedKeys.keys =
  #  [ "..." ];

  systemd.settings.Manager = {
    DefaultTimeoutStartSec = "900s";
  };

  time.timeZone = "Europe/Amsterdam";

  system.stateVersion = "26.05";
}
