{
  lib,
  stdenv,
  fetchurl,
  file,
  zlib,
  libgnurx,
  updateAutotoolsGnuConfigScriptsHook,
  testers,
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation (finalAttrs: {
  pname = "file";
  version = "5.45";

  src = fetchurl {
    urls = [
      "https://astron.com/pub/file/file-${finalAttrs.version}.tar.gz"
      "https://distfiles.macports.org/file/file-${finalAttrs.version}.tar.gz"
    ];
    hash = "sha256-/Jf1ECm7DiyfTjv/79r2ePDgOe6HK53lwAKm0Jx4TYI=";
  };

  outputs = [
    "out"
    "dev"
    "man"
  ];

  patches = [
    # Upstream patch to fix 32-bit tests.
    #
    # It is included in 5.46+, but we are not updating to it or a later version until:
    #
    # https://bugs.astron.com/view.php?id=622
    # https://bugs.astron.com/view.php?id=638
    #
    # are resolved. See also description of the 1st bug here:
    #
    # https://github.com/NixOS/nixpkgs/pull/402318#issuecomment-2881163359
    ./32-bit-time_t.patch
  ];

  strictDeps = true;
  enableParallelBuilding = true;

  nativeBuildInputs = [
    updateAutotoolsGnuConfigScriptsHook
  ]
  ++ lib.optional (stdenv.hostPlatform != stdenv.buildPlatform) file;
  buildInputs = [ zlib ] ++ lib.optional stdenv.hostPlatform.isMinGW libgnurx;

  # https://bugs.astron.com/view.php?id=382
  doCheck = !stdenv.buildPlatform.isMusl;

  makeFlags = lib.optional stdenv.hostPlatform.isWindows "FILE_COMPILE=file";

  passthru.tests.pkg-config = testers.testMetaPkgConfig finalAttrs.finalPackage;

  meta = with lib; {
    homepage = "https://darwinsys.com/file";
    description = "Program that shows the type of files";
    maintainers = with maintainers; [ doronbehar ];
    license = licenses.bsd2;
    pkgConfigModules = [ "libmagic" ];
    platforms = platforms.all;
    mainProgram = "file";
  };
})
