# Release 24.11 (“Vicuña”, 2024.11/28) {#sec-release-24.11}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Highlights {#sec-release-24.11-highlights}

- Nix was updated to 2.24, which brings a lot of improvements and fixes. See the release notes for
    [2.19](https://nix.dev/manual/nix/latest/release-notes/rl-2.19),
    [2.20](https://nix.dev/manual/nix/latest/release-notes/rl-2.20),
    [2.21](https://nix.dev/manual/nix/latest/release-notes/rl-2.21),
    [2.22](https://nix.dev/manual/nix/latest/release-notes/rl-2.22),
    [2.23](https://nix.dev/manual/nix/latest/release-notes/rl-2.23),
    [2.24](https://nix.dev/manual/nix/latest/release-notes/rl-2.24).
  Notable changes include improvements to Git fetching, documentation comment support in `nix-repl> :doc`, as well as many quality of life additions.

- There have been significant changes to macOS support.
  - The build environment has been redesigned to be closer to a native Xcode toolchain, enabling us to provide all SDKs from macOS Sierra 10.12 to macOS Sequoia 15, simplify build definitions, and build more software without hacks or patching.
    Although compatibility shims for the old SDK scheme are provided, some builds may break, and the old mechanisms will be removed by 25.11 at the latest.
    See the [Darwin section](https://nixos.org/manual/nixpkgs/stable/#sec-darwin) of the Nixpkgs manual for details of the new scheme and how to use it, and [the announcement on Discourse](https://discourse.nixos.org/t/the-darwin-sdks-have-been-updated/55295) for more information on the changes and benefits.

  - **This will be the last release of Nixpkgs to support macOS Sierra 10.12 to macOS Catalina 10.15.**
    Starting with release 25.05, the minimum supported version will be macOS Big Sur 11, and we cannot guarantee that packages will continue to work on older versions of macOS.
    Users on old macOS versions should consider upgrading to a supported version (potentially using [OpenCore Legacy Patcher](https://dortania.github.io/OpenCore-Legacy-Patcher/) for old hardware) or installing NixOS.
    If neither of those options are viable and you require new versions of software, [MacPorts](https://www.macports.org/) supports versions back to Mac OS X Snow Leopard 10.6.

- This will be the last release of Nixpkgs to support versions of CUDA prior to CUDA 12.0.
  These versions only work with old compiler versions that will be unsupported by the time of the Nixpkgs 25.05 release.
  In the future, users should expect CUDA versions to be dropped as the compiler versions they require leave upstream support windows.

- Convenience options for `amdgpu`, the open source driver for Radeon cards, are now available under [`hardware.amdgpu`](#opt-hardware.amdgpu.initrd.enable).

- [AMDVLK](https://github.com/GPUOpen-Drivers/AMDVLK), AMD's open source Vulkan driver, is now available to be configured under the {option}`hardware.amdgpu.amdvlk` option.
  This also allows configuring runtime settings for AMDVLK, including enabling experimental features.

- The `moonlight-qt` package (for [Moonlight game streaming](https://moonlight-stream.org/)) now has HDR support on Linux systems.

- [Sched-ext](https://github.com/sched-ext/scx), a Linux kernel feature to run schedulers in userspace, is now available [`services.scx`](options.html#opt-services.scx.enable).
  Requires Linux kernel version 6.12 or later.

- PostgreSQL now defaults to major version 16.

- GNOME has been updated to version 47. Refer to the [release notes](https://release.gnome.org/47/) for more details.

- `authelia` has been upgraded to version 4.38. This version brings several features and improvements which are detailed in the [release blog post](https://www.authelia.com/blog/4.38-release-notes/).
  This release also deprecates some configuration keys which are likely to be removed in version 5.0.0.

- `netbird` has been updated to 0.31.1. This adds a built-in relay server which is not yet supported by the NixOS module, as well as a metrics endpoint for both the management and signal services. The default metrics port for the `signal` service has been changed from `9090` to `9091` to prevent a port conflict with the management server. This can be changed with their respective `metricsPort` as needed. Refer to the [release notes](https://github.com/netbirdio/netbird/releases/tag/v0.31.1) and [this pull request](https://github.com/NixOS/nixpkgs/pull/354032#issuecomment-2480925927) for more information.

- `compressDrv` can compress selected files in a derivation. `compressDrvWeb` compresses files for common web server usage (`.gz` with `zopfli`, `.br` with `brotli`).

- [`hardware.display`](#opt-hardware.display.edid.enable) is a new module implementing workarounds for misbehaving monitors
  by setting up custom EDID files and forcing kernel/framebuffer modes.

- [`services.displayManager.ly`](#opt-services.displayManager.ly.enable) is a new module for configuring the display manager [ly](https://github.com/fairyglade/ly),
  a TUI-based replacement for SDDM and LightDM meant for window manager users.

- `srcOnly` was rewritten to be more readable, have additional warnings in the event that something is probably wrong, use the `stdenv` provided by the derivation, and Noogle-compatible documentation was added.

- The default sound server for most graphical sessions has been switched from PulseAudio to PipeWire.
  Users that want to keep using PulseAudio will want to set `services.pipewire.enable = false;` and `hardware.pulseaudio.enable = true;`.
  There is currently no plan to fully deprecate and remove PulseAudio, however, PipeWire should generally be preferred for new installs.

- The Rust rewrite of the `switch-to-configuration` program is now used for system activation by default.
  If you experience any issues, please report them.
  The original Perl script is deprecated and is planned for removal in the 25.05 release. It will remain accessible until then by setting `system.switch.enableNg` to `false`.

- Support for mounting filesystems from block devices protected with [dm-verity](https://docs.kernel.org/admin-guide/device-mapper/verity.html)
  was added through the [`boot.initrd.systemd.dmVerity`](#opt-boot.initrd.systemd.dmVerity.enable) option.

- The [Xen Project Hypervisor](https://xenproject.org) is once again available as a virtualisation option under [`virtualisation.xen`](#opt-virtualisation.xen.enable).
  - This release includes Xen [4.19.0](https://wiki.xenproject.org/wiki/Xen_Project_4.19_Release_Notes) and support for booting the hypervisor on EFI systems.
  ::: {.warning}
    Booting into the Xen Project Hypervisor through a legacy BIOS bootloader or with the legacy script-based Stage 1 initrd have been **deprecated**. Only EFI booting and the new systemd-based Stage 1 initrd are supported.
  :::
  - The `qemu-xen-traditional` component has been deprecated by the upstream Xen Project, and is no longer included in the Xen build.
  - The OCaml-based Xen Store can now be configured using  [`virtualisation.xen.store.settings`](#opt-virtualisation.xen.store.settings).
  - The `virtualisation.xen.bridge` options have been deprecated in this release cycle. Users who need network bridges are encouraged to set up their own networking configurations.

- A new option [`systemd.enableStrictShellChecks`](#opt-systemd.enableStrictShellChecks) has been added. When enabled, all systemd scripts generated by NixOS will
  be checked with [shellcheck](https://www.shellcheck.net) and any errors or warnings will cause the build to fail.
  This affects all scripts that have been created through the `script`, `reload`, `preStart`, `postStart`, `preStop` and `postStop` options for systemd services.
  This does not affect commandlines passed directly to `ExecStart`, `ExecReload`, `ExecStartPre`, `ExecStartPost`, `ExecStop` or `ExecStopPost`.
  It therefore also does not affect systemd units that are coming from packages and that are not defined through the NixOS config.
  This option is disabled by default, and although some services have already been fixed, it is still likely that you will encounter build failures when enabling this.
  We encourage people to enable this option when they are willing and able to submit fixes for potential build failures to nixpkgs.
  The option can also be enabled or disabled for individual services using the `enableStrictShellChecks` option on the service itself, which will take precedence over the global setting.

## New Modules {#sec-release-24.11-new-modules}

- [hardware.block](options.html#hardware-block.defaultScheduler) allows configuration of I/O schedulers for block devices.

- [KMonad](https://github.com/kmonad/kmonad), an advanced keyboard remapping utility. Available as [services.kmonad](#opt-services.kmonad.enable).

- [Coral](https://coral.ai/), hardware support for Coral.ai Edge TPU devices. Available as [hardware.coral.usb.enable](#opt-hardware.coral.usb.enable) and [hardware.coral.pcie.enable](#opt-hardware.coral.pcie.enable).

- [Cyrus IMAP](https://github.com/cyrusimap/cyrus-imapd), an email, contacts and calendar server. Available as [services.cyrus-imap](#opt-services.cyrus-imap.enable) service.

- [TaskChampion Sync-Server](https://github.com/GothenburgBitFactory/taskchampion-sync-server), a [Taskwarrior 3](https://taskwarrior.org/docs/upgrade-3/) sync server. Available as [services.taskchampion-sync-server](#opt-services.taskchampion-sync-server.enable).

- [FlareSolverr](https://github.com/FlareSolverr/FlareSolverr), a proxy server to bypass Cloudflare protection. Available as [services.flaresolverr](#opt-services.flaresolverr.enable).

- [Whisparr](https://wiki.servarr.com/en/whisparr), an adult movie collection manager for Usenet and BitTorrent users. Available as [services.whisparr](#opt-services.whisparr.enable).

- [Gancio](https://gancio.org/), a shared agenda for local communities. Available as [services.gancio](#opt-services.gancio.enable).

- [Goatcounter](https://www.goatcounter.com/), an easy web analytics platform with no tracking of personal data. Available as [services.goatcounter](options.html#opt-services.goatcounter.enable).

- [Privatebin](https://github.com/PrivateBin/PrivateBin/), a minimalist, open source online pastebin where the server has zero knowledge of pasted data. Available as [services.privatebin](#opt-services.privatebin.enable).

- [UWSM](https://github.com/Vladimir-csp/uwsm), a wayland session manager to wrap Wayland compositors into useful systemd units such as `graphical-session.target`. Available as [programs.uwsm](#opt-programs.uwsm.enable).

- [Open-WebUI](https://github.com/open-webui/open-webui), a user-friendly WebUI for LLMs. Available as [services.open-webui](#opt-services.open-webui.enable).

- [Quickwit](https://quickwit.io), a sub-second search & analytics engine on cloud storage. Available as [services.quickwit](options.html#opt-services.quickwit.enable).

- [Userborn](https://github.com/nikstur/userborn), a service for declarative
  user management. This can be used instead of the `update-users-groups.pl`
  Perl script and/or systemd-sysusers. This is now recommended over
  systemd-sysusers to achieve a system without Perl, as it can create normal
  users and change passwords. Available as [services.userborn](#opt-services.userborn.enable).

- [g810-led](https://github.com/MatMoul/g810-led), a LED controller for Logitech G keyboards. Available as [services.g810-led](options.html#opt-services.g810-led.enable).

- [Hatsu](https://github.com/importantimport/hatsu), a self-hosted bridge that interacts with Fediverse on behalf of your static site. Available as [services.hatsu](options.html#opt-services.hatsu.enable).

- [Soteria](https://github.com/ImVaskel/soteria), a polkit authentication agent to handle elevated prompts for any desktop environment. Normally this should only be used on DEs or WMs that do not provide a graphical polkit frontend on their own. Available as [`security.soteria`](#opt-security.soteria.enable).

- [Flood](https://flood.js.org/), a beautiful WebUI for various torrent clients. Available as [services.flood](options.html#opt-services.flood.enable).

- [Niri](https://github.com/YaLTeR/niri), a scrollable-tiling Wayland compositor. Available as [programs.niri](options.html#opt-programs.niri.enable).

- [Firefly-iii Data Importer](https://github.com/firefly-iii/data-importer), a data importer for Firefly-III. Available as [services.firefly-iii-data-importer](options.html#opt-services.firefly-iii-data-importer.enable).

- [Dashy](https://dashy.to), an open source, highly customizable, easy to use, privacy-respecting dashboard app. Available as [services.dashy](options.html#opt-services.dashy).

- [QGroundControl], a ground station support and configuration manager for the PX4 and APM Flight Stacks. Available as [programs.qgroundcontrol](options.html#opt-programs.qgroundcontrol.enable).

- [Eintopf](https://eintopf.info), a community event and calendar web application. Available as [services.eintopf](options.html#opt-services.eintopf.enable).

- [`pay-respects`](https://codeberg.org/iff/pay-respects), a terminal command correction program, alternative to `thefuck`, written in Rust. Available as [programs.pay-respects](options.html#opt-programs.pay-respects).

- [Radicle](https://radicle.xyz), an open source, peer-to-peer code collaboration stack built on Git. Available as [services.radicle](#opt-services.radicle.enable).

- [Ordinal](https://github.com/snu-sf/Ordinal), A library for ordinal numbers in the Coq proof assistant.

- [ddns-updater](https://github.com/qdm12/ddns-updater), a service with a WebUI to update DNS records periodically for many providers. Available as [services.ddns-updater](#opt-services.ddns-updater.enable).

- [Immersed](https://immersed.com/), a closed-source coworking platform. Available as [programs.immersed](#opt-programs.immersed.enable).

- [HomeBox](https://github.com/sysadminsmedia/homebox), an inventory and organization system built for the home user. Available as [services.homebox](#opt-services.homebox.enable).

- [evremap](https://github.com/wez/evremap), a keyboard input remapper for Linux/Wayland systems. Available as [services.evremap](options.html#opt-services.evremap).

- [matrix-hookshot](https://matrix-org.github.io/matrix-hookshot), a Matrix bot for connecting to external services. Available as [services.matrix-hookshot](#opt-services.matrix-hookshot.enable).

- [Renovate](https://github.com/renovatebot/renovate), a dependency updating tool for various Git forges and language ecosystems. Available as [services.renovate](#opt-services.renovate.enable).

- [Music Assistant](https://music-assistant.io/), a music library manager for your offline and online music sources that can stream to a wide range of supported players. Available as [services.music-assistant](#opt-services.music-assistant.enable).

- [zeronsd](https://github.com/zerotier/zeronsd), a DNS server for ZeroTier users. Available with [services.zeronsd.servedNetworks](#opt-services.zeronsd.servedNetworks).

- [Collabora Online](https://www.collaboraonline.com/), a collaborative online office suite based on LibreOffice technology. Available as [services.collabora-online](options.html#opt-services.collabora-online.enable).

- [wg-access-server](https://github.com/freifunkMUC/wg-access-server/), an all-in-one WireGuard VPN solution with a WebUI for connecting devices. Available as [services.wg-access-server](#opt-services.wg-access-server.enable).

- [Pingvin Share](https://github.com/stonith404/pingvin-share), a self-hosted file sharing platform and an alternative for WeTransfer. Available as [services.pingvin-share](#opt-services.pingvin-share.enable).

- [Envision](https://gitlab.com/gabmus/envision), a UI for building, configuring and running Monado, the open source OpenXR runtime. Available as [programs.envision](#opt-programs.envision.enable).

- [Localsend](https://localsend.org/), an open source cross-platform alternative to AirDrop. Available as [programs.localsend](#opt-programs.localsend.enable).

- [Gatus](https://github.com/TwiN/gatus), an automated developer-oriented status page. Available as [services.gatus](#opt-services.gatus.enable).

- [cryptpad](https://cryptpad.org/), a privacy-oriented collaborative office suite, has been added back. Available as [services.cryptpad](#opt-services.cryptpad.enable).

- [realm](https://github.com/zhboner/realm), a simple, high performance relay server written in Rust. Available as [services.realm](#opt-services.realm.enable).

- [Gotenberg](https://gotenberg.dev), an API server for converting files to PDFs that can be used alongside Paperless-ngx. Available as [services.gotenberg](options.html#opt-services.gotenberg.enable).

- [Suricata](https://suricata.io/), a free and open source, mature, fast and robust network threat detection engine. Available as [services.suricata](options.html#opt-services.suricata.enable).

- [Playerctld](https://github.com/altdesktop/playerctl), a daemon to track media player activity. Available as [services.playerctld](options.html#opt-services.playerctld.enable).

- [Glance](https://github.com/glanceapp/glance), a self-hosted dashboard that puts all your feeds in one place. Available as [services.glance](options.html#opt-services.glance.enable).

- [Apache Tika](https://github.com/apache/tika), a toolkit that detects and extracts metadata and text from over a thousand different file types. Available as [services.tika](options.html#opt-services.tika.enable).

- [Misskey](https://misskey-hub.net/en/), an interplanetary microblogging platform. Available as [services.misskey](options.html#opt-services.misskey.enable).

- [Improved File Manager (IFM)](https://github.com/misterunknown/ifm), a single-file web-based file manager. Available as [services.ifm](options.html#opt-services.ifm.enable).

- [OpenGFW](https://github.com/apernet/OpenGFW), an implementation of the Great Firewall on Linux. Available as [services.opengfw](#opt-services.opengfw.enable).

- [Rathole](https://github.com/rapiz1/rathole), a lightweight and high-performance reverse proxy for NAT traversal. Available as [services.rathole](#opt-services.rathole.enable).

- [Proton Mail bridge](https://proton.me/mail/bridge), a desktop application that runs in the background, encrypting and decrypting messages as they enter and leave your computer. Available as [services.protonmail-bridge](#opt-services.protonmail-bridge.enable).

- [chromadb](https://www.trychroma.com/), an open-source AI application database with batteries included. Available as [services.chromadb](options.html#opt-services.chromadb.enable).

- [bitmagnet](https://bitmagnet.io/), a self-hosted BitTorrent indexer, DHT crawler, content classifier and torrent search engine with WebUI, GraphQL API and Servarr stack integration. Available as [services.bitmagnet](options.html#opt-services.bitmagnet.enable).

- [Wakapi](https://wakapi.dev/), a time tracking software for programmers. Available as [services.wakapi](#opt-services.wakapi.enable).

- [foot](https://codeberg.org/dnkl/foot), a fast, lightweight and minimalistic Wayland terminal emulator. Available as [programs.foot](#opt-programs.foot.enable).

- [ToDesk](https://www.todesk.com/linux.html), a remote desktop application. Available as [services.todesk](#opt-services.todesk.enable).

- [Dependency Track](https://dependencytrack.org/), an intelligent Component Analysis platform that allows organizations to identify and reduce risk in the software supply chain. Available as [services.dependency-track](options.html#opt-services.dependency-track.enable).

- [Immich](https://github.com/immich-app/immich), a self-hosted photo and video backup solution. Available as [services.immich](#opt-services.immich.enable).

- [saunafs](https://saunafs.com), a distributed POSIX file system. Available as [services.saunafs](options.html#opt-services.saunafs.enable).

- [obs-studio](https://obsproject.com/), a free and open source software for video recording and live streaming. Available as [programs.obs-studio](#opt-programs.obs-studio.enable).

- [Veilid](https://veilid.com), a privacy-focused, headless server for data sharing and messaging on a peer-to-peer network. Available as [services.veilid](#opt-services.veilid.enable).

- [Fedimint](https://github.com/fedimint/fedimint), a module based system for building federated applications (Federated E-Cash Mint). Available as [services.fedimintd](#opt-services.fedimintd).

- [tiny-dfr](https://github.com/WhatAmISupposedToPutHere/tiny-dfr), a dynamic function row daemon for the Touch Bar found on some Apple laptops. Available as [hardware.apple.touchBar.enable](options.html#opt-hardware.apple.touchBar.enable).

- [Swapspace](https://github.com/Tookmund/Swapspace), a dynamic swap space manager that turns your unused free space into swap automatically. Available as [services.swapspace](#opt-services.swapspace.enable).

- [Zapret](https://github.com/bol-van/zapret), a DPI bypass tool. Available as [services.zapret](options.html#opt-services.zapret.enable).

- [Glances](https://github.com/nicolargo/glances), an open-source system cross-platform monitoring tool. Available as [services.glances](options.html#opt-services.glances).

## Backward Incompatibilities {#sec-release-24.11-incompatibilities}

- Nixpkgs now requires Nix 2.3.17 or newer to allow for zstd compressed binary artifacts.

- The `sound` options have been removed or renamed, as they had a lot of unintended side effects. See [below](#sec-release-24.11-migration-sound) for details.

- The NVIDIA driver no longer defaults to the proprietary kernel module with versions >= 560. You will need to manually set `hardware.nvidia.open` to select the proprietary or open modules.

- The `intel` driver for the X server (`services.xserver.videoDrives = [ "intel" ]`) is no longer functional due to incompatibilities with the latest Mesa version.
  All users are strongly encouraged to switch to the generic `modesetting` driver (the default one) whenever possible, for more information see the manual chapter on [Intel Graphics](#sec-x11--graphics-cards-intel) and issue [#342763](https://github.com/NixOS/nixpkgs/issues/342763).

- The `intel-compute-runtime` package dropped support for older GPUs, and only supports 12th Gen and newer from now on.
  Intel GPUs from Gen 8,9 and 11 need to use the `intel-compute-runtime-legacy1` package in `hardware.graphics.extraPackages`.

- The `(buildPythonPackage { ... }).override` and `(buildPythonPackage { ... }).overrideDerivation` attributes is now deprecated and removed in favour of `overridePythonAttrs` and `lib.overrideDerivation`.
  This change does not affect the override interface of most Python packages, as [`<pkg>.override`](https://nixos.org/manual/nixpkgs/unstable/#sec-pkg-override) provided by `callPackage` shadows such a locally-defined `override` attribute.
  The `<pkg>.overrideDerivation` attribute of Python packages called with `callPackage` will also remain available after this change.

- All Cinnamon and XApp packages have been moved to top-level (i.e., `cinnamon.nemo` is now `nemo`).

- All GNOME packages have been moved to top-level (i.e., `gnome.nautilus` is now `nautilus`).

- `transmission` has been aliased with a `trace` warning to `transmission_3`, since [Transmission 4 has been released last year](https://github.com/transmission/transmission/releases/tag/4.0.0) and Transmission 3 will eventually go away -- this is meant to make people aware of the new version. `services.transmission.package` now also defaults to `transmission_3`, as the upgrade can cause data loss in some cases (examples: [#5153](https://github.com/transmission/transmission/issues/5153), [#6796](https://github.com/transmission/transmission/issues/6796)). Please make sure to back up to your data directory if you may be affected:
  - `transmission-gtk`: `~/.config/transmission`
  - `transmission-daemon` using NixOS module: `${config.services.transmission.home}/.config/transmission-daemon` (defaults to `/var/lib/transmission/.config/transmission-daemon`)

- The default `mongodb` version has been updated from 5.0 to 7.0.
  For more information, see the compatibility changes for MongoDB [6.0](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/) and [7.0](https://www.mongodb.com/docs/manual/release-notes/7.0-compatibility/).

- `unifi` has been updated to UniFi 8.
  `unifi7` was removed as it is vulnerable to CVE-2024-42025 and required a version of MongoDB that has reached end of life.

- `androidenv.androidPkgs_9_0` has been removed. It is replaced with `androidenv.androidPkgs` for a more complete Android SDK, including support for Android 9 and later.

- The VirtualBox demo installer appliance has been removed.
  Please use the standard installer ISOs instead.

- `grafana` has been updated to version 11.3. This version doesn't support setting `http_addr` to a hostname anymore, an IP address is expected.

- `deno` has been updated to Deno 2, which has breaking changes.
  See the [migration guide](https://docs.deno.com/runtime/reference/migration_guide/) for details.

- `gogs` has been removed. Upstream development has stalled and it has several
  [critical vulnerabilities](https://github.com/gogs/gogs/issues/7777) that weren't addressed
  within a year. Consider migrating to `forgejo` or `gitea`.

- `knot-dns` has been updated to version 3.4.x. Check the [migration guide](https://www.knot-dns.cz/docs/latest/html/migration.html#upgrade-3-3-x-to-3-4-x) for breaking changes.

- `mutmut` has been updated to version 3.0.5.

- `services.kubernetes.kubelet.clusterDns` now accepts a list of DNS resolvers rather than a single string, bringing the module more in line with the upstream Kubelet configuration schema.

- `bluemap` has changed the format used to store map tiles, and the database layout has been heavily modified. Upstream recommends a clean reinstallation: <https://github.com/BlueMap-Minecraft/BlueMap/releases/tag/v5.2>. Unless you are using an SQL storage backend, this should only entail deleting the contents of `config.services.bluemap.coreSettings.data` (defaults to `/var/lib/bluemap`) and `config.services.bluemap.webRoot` (defaults to `/var/lib/bluemap/web`).

- `wstunnel` has had a major version upgrade that entailed rewriting the program in Rust.
  The module was updated to accommodate for breaking changes and breaking changes to the
  module options were minimised as much as possible. Nonetheless, some were inevitable due
  to changes in the upstream CLI. Certain options were moved from separate CLI arguments into
  the forward specifications, and those options were also removed from the module's options.
  Please consult the wstunnel man page for more details.
  Also be aware that if you have set additional options in `services.wstunnel.{clients,servers}.<name>.extraArgs`,
  they may have been modified or removed upstream.

- `gnat` and `gnatPackages` now use GNAT 13 instead of GNAT 12. This matches
  the default `gcc` version.

- `percona-server_8_4` and `mysql84` now have password authentication via the deprecated `mysql_native_password` disabled by default. This authentication plugin can be enabled via a CLI argument again, for detailed instructions and alternative authentication methods [see upstream documentation](https://dev.mysql.com/doc/refman/8.4/en/native-pluggable-authentication.html). The config file directive `default_authentication_plugin` has been removed.

- Percona has decided not to follow the LTS/ Innovation release scheme of upstream MySQL and thus [will only create releases for MySQL LTS versions](https://www.percona.com/blog/no-mysql-9-x-innovation-releases-from-percona/). Hence, the package names `percona-server_lts`, `percona-server_innovation`, `percona-xtrabackup_lts` and `percona-xtrabackup_innovation` are deprecated.
  - `percona-server` and `percona-server_lts` now point towards the new LTS release `percona-server_8_4`. The previous LTS continues to be supported and is available as `percona-server_8_0`. The same is true for the supporting `percona-xtrabackup` tooling.

- `clang-tools_<version>` packages have been moved into `llvmPackages_<version>` (i.e. `clang-tools_18` is now `llvmPackages_18.clang-tools`).
  - For convenience, the top-level `clang-tools` attribute remains and is now bound to `llvmPackages.clang-tools`.
  - Top-level `clang_tools_<version>` attributes are now aliases; these will be removed in a future release.

- `buildbot` was updated to 4.0 and the AngularJS frontend replaced by a React frontend. See the [upstream release notes](https://docs.buildbot.net/current/manual/upgrading/4.0-upgrade.html).

- `headscale` has been updated to version 0.23.0 which reworked large parts of the configuration, including DNS, Magic DNS prefixes and ACL policy files. See the [upstream changelog](https://github.com/juanfont/headscale/releases/tag/v0.23.0) for details.

- `nginx` package no longer includes the `gd` and `geoip` dependencies. To re-enable them, override `nginx` with the options `withImageFilter = true;` and `withGeoIP = true;`.

- `systemd.enableUnifiedCgroupHierarchy` has been removed.
  In systemd 256, support for cgroup v1 ('legacy' and 'hybrid' hierarchies) is now considered obsolete and systemd will refuse to boot under it by default.
  To forcibly re-enable cgroup v1 support, you can set `boot.kernelParams = [ "systemd.unified_cgroup_hierarchy=0" "SYSTEMD_CGROUP_ENABLE_LEGACY_FORCE=1" ]`.
  This is not an officially supported configuration and might cause your system to become unbootable in future versions. You are on your own.

- `nrfutil` -- which previously pointed to the now-deprecated `pc-nrfutil` Python package -- has been repackaged under the same name with the new nrfutil tool.

- `openssh` and `openssh_hpn` are now compiled without Kerberos 5 / GSSAPI support in an effort to reduce the attack surface of the components. Users needing this support can
  use the new `opensshWithKerberos` and `openssh_hpnWithKerberos` package flavors (e.g. `programs.ssh.package = pkgs.openssh_gssapi`).

- `security.ipa.ipaHostname` now defaults to the value of `networking.fqdn` if
  it is set, instead of the previous hardcoded default of
  `${networking.hostName}.${security.ipa.domain}`.

- The `MSMTP_QUEUE` and `MSMTP_LOG` environment variables accepted by `msmtpq` have been renamed to `MSMTPQ_Q` and `MSMTPQ_LOG` respectively.

- The logrotate service has been hardened and now requires enabling `allowNetworking` if network access is required.

- `mautrix-whatsapp` has been updated to version 0.11.0, which is a major rewrite of the bridge. Config file changes are required.

- qBittorrent has been updated to major version 5, which drops support for Qt 5.
  The `qbittorrent-qt5` package has been removed.

- The fcgiwrap module now allows multiple instances running as distinct users.
  The option `services.fgciwrap` now takes an attribute set of the
  configuration of each individual instance.
  This requires migrating any previous configuration keys from
  `services.fcgiwrap.*` to `services.fcgiwrap.instances.some-instance.*`.
  The ownership and mode of the UNIX sockets created by this service are now
  configurable and private by default.
  Processes also now run as a dynamically allocated user by default instead of
  root.

- The `mautrix-signal` module was adapted to incorporate the configuration changes that resulted from the update to the mautrix bridgev2 architecture. Pre-0.7.0 configurations should continue to work.
  In case you want to update your configuration, make sure to check the NixOS manual.

- `cargo-tauri` has been updated to major version 2. Please review [the migration guide](https://tauri.app/start/migrate/from-tauri-1/).
  v1 of `cargo-tauri` is still available as `cargo-tauri_1`, but will be removed in future releases.

- The nvidia driver no longer defaults to the proprietary driver starting with version 560. You will need to manually set `hardware.nvidia.open` to select the proprietary or open driver.

- `postgresql_12` has been removed since it reached its end of life.

- `postgresql` no longer accepts the `enableSystemd` override. Use `systemdSupport` instead.

- `postgresql` was split into default and -dev outputs. To make this work without circular dependencies, the output of the `pg_config` system view has been removed. The `pg_config` binary is provided in the -dev output and still works as expected.

- The arguments from [](#opt-services.postgresql.initdbArgs) now get shell-escaped.

- `postgresql` is now [hardened by default](#module-services-postgres-hardening) using the common `systemd` settings for that.

- The dhcpcd service (`networking.useDHCP`) has been hardened and now runs exclusively as the "dhcpcd" user.
  Users that were relying on the root privileges in `networking.dhcpcd.runHook` will have to write specific [sudo](security.sudo.extraRules) or [polkit](security.polkit.extraConfig) rules to allow dhcpcd to perform privileged actions.

  As part of these changes, the DHCP lease files directory has also been moved from `/var/db/dhcpcd` to `/var/lib/dhcpcd`. This migration is performed automatically, but users may have to update their backup configuration.

- `singularity-tools` have the `storeDir` argument removed from its override interface and use `builtins.storeDir` instead.

- The `mkLayer` and `shellScript` build helpers in `singularity-tools` are deprecated, as they are no longer involved in image-building. Maintainers will remove them in future releases.

- The `rust.toTargetArch`, `rust.toTargetOs`, `rust.toTargetFamily`, `rust.toTargetVendor`, `rust.toRustTarget`, `rust.toRustTargetSpec`, `rust.toRustTargetSpecShort`, and `rust.IsNoStdTarget` functions are deprecated in favour of the `rust.platform.arch`, `rust.platform.os`, `rust.platform.target-family`, `rust.platform.vendor`, `rust.rustcTarget`, `rust.rustcTargetSpec`, `rust.cargoShortTarget`, `rust.cargoEnvVarTarget`, and `rust.isNoStdTarget` platform attributes respectively.

- All Budgie and `budgiePlugins` packages have been moved to top-level (i.e.,
  `budgie.budgie-desktop` is now `budgie-desktop` and `budgiePlugins.budgie-media-player-applet`
  is now `budgie-media-player-applet`).

- The method of safely handling secrets in the `networking.wireless` module has been changed to benefit from a [new feature](https://w1.fi/cgit/hostap/commit/?id=e680a51e94a33591f61edb210926bcb71217a21a) of `wpa_supplicant`.
  The syntax to refer to secrets has changed slightly and the option `networking.wireless.environmentFile` has been replaced by `networking.wireless.secretsFile`; see the description of the latter for how to upgrade.

- NetBox was updated to `>= 4.1.0`.
  Have a look at the breaking changes
  of the [4.0 release](https://github.com/netbox-community/netbox/releases/tag/v4.0.0)
  and the [4.1 release](https://github.com/netbox-community/netbox/releases/tag/v4.1.0),
  make the required changes to your database, if needed,
  then upgrade by setting `services.netbox.package = pkgs.netbox_4_1;`
  in your configuration.

- `services.cgit` now runs as the cgit user by default instead of root.
  This change requires granting access to the repositories to this user or
  setting the appropriate one through `services.cgit.some-instance.user`.

- All Oracle JDKs and JREs (`oraclejdk`, `oraclejdk8`, `oraclejre`, `oraclejre8`,
  `jrePlugin`, `jre8Plugin`, `jdkdistro`, `oraclejdk8distro`, and `oraclejdk11`)
  were dropped due to being unmaintained and heavily insecure. OpenJDK provides
  compatible replacements for JDKs and JREs.

- `gradle_6` was removed due to being [unsupported upstream as of 10 Feb 2023](https://endoflife.date/gradle).
  Additionally, it had numerous security vulnerabilities that were only patched
  in later versions, such as [CVE-2021-29429](https://nvd.nist.gov/vuln/detail/CVE-2021-32751),
  [CVE-2021-29427](https://nvd.nist.gov/vuln/detail/CVE-2021-29427), [CVE-2021-29428](https://nvd.nist.gov/vuln/detail/CVE-2021-29428), and [CVE-2021-32751](https://nvd.nist.gov/vuln/detail/CVE-2021-32751).

- `nvimpager` was updated to version 0.13.0, which changes the order of user and
  nvimpager settings: user commands in `-c` and `--cmd` now override the
  respective default settings because they are executed later.

- `javacard-devkit` was dropped due to having a dependency on the Oracle JDK,
  as well as being several years out-of-date.

- Kubernetes `featureGates` have changed from a `listOf str` to `attrsOf bool`.
  This refactor makes it possible to also disable feature gates, without having
  to use `extraOpts` flags.

  A previous configuration may have looked like this:

  ```nix
  {
    featureGates = [ "EphemeralContainers" ];
    extraOpts = pkgs.lib.concatStringsSep " " ([ ''--feature-gates="CSIMigration=false"'' ]);
  }
  ```

  Using an attribute set instead, the new configuration would be:

  ```nix
  {
    featureGates = {
      EphemeralContainers = true;
      CSIMigration = false;
    };
  }
  ```

- `pkgs.nextcloud27` has been removed as it has reached EOL.

- The `environment.noXlibs` option has been removed. It was a common source of unexpected rebuilds and breakage that was often hard to diagnose.
  If you need to disable certain libraries, you're encouraged to add your own overlay to your configuration that targets the packages you care about.

- `frigate` was updated past 0.14.0. This release includes various breaking changes, so please review the [release notes](https://github.com/blakeblackshear/frigate/releases/tag/v0.14.0).
   Most prominently, access to the web interface and API are now protected by authentication. Retrieve the auto-created
   admin account from the `frigate.service` journal after upgrading.

- `nodePackages.coc-python` was dropped, as [its upstream is unmaintained](https://github.com/neoclide/coc-python). The associated `vimPlugins.coc-python` was also dropped.
  The upstream project recommends using `coc-pyright` or `coc-jedi` as replacements.

- `forgejo` has been upgraded from version 7.0 to version 9.0, see the release notes for [8.0](https://codeberg.org/forgejo/forgejo/src/branch/forgejo/RELEASE-NOTES.md#8-0-0) and [9.0](https://codeberg.org/forgejo/forgejo/milestone/7235).

- `services.forgejo.mailerPasswordFile` has been deprecated by the drop-in replacement `services.forgejo.secrets.mailer.PASSWD`,
  which is part of the new free-form `services.forgejo.secrets` option.
  `services.forgejo.secrets` is a small wrapper over systemd's `LoadCredential=`. It has the same structure (sections/keys) as
  `services.forgejo.settings` but takes file paths that will be read before service startup instead of some plaintext value.
  `services.forgejo.package` now defaults to `forgejo-lts`, the Long Term Support version of Forgejo.

- `forgejo` and `forgejo-lts` no longer support the opt-in feature [PAM (Pluggable Authentication Module)](https://forgejo.org/docs/latest/user/authentication/#pam-pluggable-authentication-module).

- `gitea` no longer supports the opt-in feature [PAM (Pluggable Authentication Module)](https://docs.gitea.com/usage/authentication#pam-pluggable-authentication-module).

- `vuze` was removed because it is unmaintained upstream and insecure (CVE-2018-13417).
  BiglyBT is a maintained fork.

- `services.ddclient.use` has been deprecated: `ddclient` now supports separate IPv4 and IPv6 configuration. Use `services.ddclient.usev4` and `services.ddclient.usev6` instead.

- `services.pgbouncer` systemd service is now configured with `Type=notify-reload` and allows reloading configuration without process restart. PgBouncer configuration options were moved to the freeform type option under [`services.pgbouncer.settings`](#opt-services.pgbouncer.settings).

- Docear was removed because it was unmaintained upstream.
  JabRef, Zotero, or Mendeley are potential replacements.

- `nodePackages.coc-metals` was removed due to being deprecated upstream.
  `vimPlugins.nvim-metals` is its official replacement.

- `matrix-sliding-sync` was removed because it has been replaced by the simplified sliding sync functionality introduced in matrix-synapse 114.0.

- `nodePackages.coc-tslint`, `vimPlugins.coc-tslint`, `nodePackages.coc-tslint-plugin`,
  and `vimPlugins.coc-tslint-plugin` were removed due to being deprecated upstream. The
  `nodePackages.coc-eslint` and `vimPlugins.coc-eslint` packages offer comparable
  features for `eslint`, which replaced `tslint`.

- Tcl packages have been moved into the `tclPackages` scope.

- `teleport` has been upgraded from major version 15 to major version 16.
  Refer to upstream [upgrade instructions](https://goteleport.com/docs/management/operations/upgrading/)
  and [release notes for v16](https://goteleport.com/docs/changelog/#1600-061324).

- `tests.overriding`'s `passthru.tests` has been restructured as an attribute set instead of a list, making individual tests accessible by their names.

- `skk-dict` was split into multiple packages under `skkDictionaries`.
  If in doubt of what to use, try `skkDictionaries.l`. As part of this change, the dictionaries
  were moved from `$out/share` to `$out/share/skk`. The dictionaries also won't
  be converted to UTF-8 unless the `useUtf8` package option is enabled; UTF-8
  converted dictionaries will have the .utf8 suffix appended to its filename.

- `vaultwarden` lost the capability to bind to privileged ports. If you rely on
   this behavior, override the systemd unit to allow `CAP_NET_BIND_SERVICE` in
   your configuration.

- `services.invoiceplane.sites.<name>.extraConfig` was removed. Configuration must now be done
  through the structured `services.invoiceplane.sites.<name>.settings` option.

- `services.ollama.sandbox` has been replaced with options to configure
  a static `user` and `group`. The `writablePaths` option has also been removed and
  the models directory is now always exempt from sandboxing.

- The `gns3-server` service now runs under the `gns3` system user
  instead of a dynamically created one via `DynamicUser`.
  The use of SUID wrappers is incompatible with SystemD's `DynamicUser` setting,
  and GNS3 requires calling ubridge through its SUID wrapper to function properly.
  This change requires to manually move the following directories:
    * from `/var/lib/private/gns3` to `/var/lib/gns3`
    * from `/var/log/private/gns3` to `/var/log/gns3`
  and to change the ownership of these directories and their contents to `gns3` (including `/etc/gns3`).

- Legacy package `stalwart-mail_0_6` was dropped, please note the
  [manual upgrade process](https://github.com/stalwartlabs/mail-server/blob/main/UPGRADING.md)
  before changing the package to `pkgs.stalwart-mail` in
  [`services.stalwart-mail.package`](#opt-services.stalwart-mail.package).

- `nomad_1_5` and `nomad_1_6` were dropped, as [they have reached end-of-life upstream](https://support.hashicorp.com/hc/en-us/articles/360021185113-Support-Period-and-End-of-Life-EOL-Policy). Evaluating them will throw an error.

- The default `nomad` package has been updated to 1.8.x. For more information, see [breaking changes for Nomad 1.8](https://developer.hashicorp.com/nomad/docs/upgrade/upgrade-specific#nomad-1-8-0)

- `androidndkPkgs` has been updated to `androidndkPkgs_26`.

- Android NDK version 26 and SDK version 33 are now the default versions used for cross compilation to android.

- `ankisyncd` package and its `services.ankisyncd` have been removed. Use [`services.anki-sync-server`](#opt-services.anki-sync-server.enable) instead.

- `nodePackages.vscode-css-languageserver-bin`, `nodePackages.vscode-html-languageserver-bin`,
  and `nodePackages.vscode-json-languageserver-bin` were dropped due to an unmaintained upstream.
  The `vscode-langservers-extracted` package is a maintained drop-in replacement.

- `nodePackages.prisma` has been replaced by `prisma`.

- `fetchNextcloudApp` has been rewritten to use `fetchurl` rather than
  `fetchzip`. This invalidates all existing hashes, but you can restore the old
  behavior by passing it `unpack = true`.

- `haskell.lib.compose.justStaticExecutables` now disallows references to GHC in its
  output by default to alert users to closure size issues caused by
  [#164630](https://github.com/NixOS/nixpkgs/issues/164630). See ["Packaging
  Helpers" in the Haskell section of the Nixpkgs
  manual](https://nixos.org/manual/nixpkgs/unstable/#haskell-packaging-helpers)
  for information on working around `output '...' is not allowed to refer to
  the following paths` errors caused by this change.

- `services.stalwart-mail` now runs under the `stalwart-mail` system user
  instead of a dynamic one via `DynamicUser` in order to avoid automatic
  ownership changes on its large file store on service restart.
  This change requires to manually move the state directory from
  `/var/lib/private/stalwart-mail` to `/var/lib/stalwart-mail`, and to
  change the ownership of the directory and its content to `stalwart-mail`.

- `services.stalwart-mail` now uses RocksDB as the default storage backend
  for `stateVersion` ≥ 24.11. It was previously using SQLite for structured
  data and the filesystem for blobs.

- `services.stargazer` has been hardened to improve security, but these
  changes make break certain setups, particularly around traditional CGI.

  - `services.stargazer.allowCgiUser` has been added, enabling
    Stargazer's `cgi-user` option to work, which was previously broken.

- `services.shiori` now requires the HTTP secret value `SHIORI_HTTP_SECRET_KEY` to be provided as an environment variable. `services.shiori.environmentFile` has been introduced to handle this:

  ```
  # This is how a environment file can be generated:
  # $ printf "SHIORI_HTTP_SECRET_KEY=%s\n" "$(openssl rand -hex 16)" > /path/to/env-file
  services.shiori.environmentFile = "/path/to/env-file";
  ```

- `/share/nano` is now only linked when `programs.nano.enable` is enabled.

- PPD files for Utax printers were renamed (spaces replaced by underscores) in the newest `foomatic-db` package. Users of Utax printers might need to adapt their `hardware.printers.ensurePrinters.*.model` value to account for this.

- `sqldeveloper` was dropped due to being severely out-of-date and having a dependency on
  JavaFX for Java 8, which we do not support.

- The `kvdo` kernel module package was removed as it was upstreamed in kernel version 6.9, where it is now called `dm-vdo`.

- `libe57format` has been updated to `>= 3.0.0`, which contains some backward-incompatible API changes. See the [release note](https://github.com/asmaloney/libE57Format/releases/tag/v3.0.0) for more details.

- `gitlab` deprecated support for *runner registration tokens* in GitLab 16.0, disabled their support in GitLab 17.0 and will
  ultimately remove it in GitLab 18.0 (as outlined in the
  [documentation](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#estimated-time-frame-for-planned-changes)).
  After upgrading to GitLab >= 17.0, it is possible to re-enable support for registration tokens in the UI until GitLab 18.0.
  Refer to the manual on [using registration tokens after GitLab 17.0](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#using-registration-tokens-after-gitlab-170).
  GitLab administrators should migrate to the [new runner registration workflow](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#using-registration-tokens-after-gitlab-170)
  with *runner authentication tokens* until the release of GitLab 18.0.

- `gitlab` has been updated from 16.x to 17.x and requires `postgresql` >= 14.9, as stated in the [documentation](https://docs.gitlab.com/17.1/ee/install/requirements.html#postgresql-requirements). Check the [upgrade guide](#module-services-postgres-upgrading) in the NixOS manual on how to upgrade your PostgreSQL installation.

- `gitaly` (part of `gitlab`) is now using the bundled `git` package instead of `pkgs.git`, to maintain compatibility with GitLab.

- `nixos/gitlab` no longer adds `pkgs.git` to `environment.systemPackages` by default.

- The `replay-sorcery` package and module was removed as it unmaintained upstream. Consider using `gpu-screen-recorder` or `obs-studio` instead.

- A few options of `services.samba` have been moved from `extraConfig` and `configText` to the new freeform option `settings` and renamed, e.g.:
  - `services.samba.invalidUsers` to `services.samba.settings.global."invalid users"`
  - `services.samba.securityType` to `services.samba.settings.global."security type"`
  - `services.samba.shares` to `services.samba.settings`
  - `services.samba.enableWinbindd` to `services.samba.winbindd.enable`
  - `services.samba.enableNmbd` to `services.samba.nmbd.enable`

- `zx` was updated to v8, which introduces several breaking changes.
  See the [v8 changelog](https://github.com/google/zx/releases/tag/8.0.0) for more information.

- `feishin` removed support for Navidrome `< v0.53.2` due to an API change. See the [v0.10.0 release notes](https://github.com/jeffvli/feishin/releases/tag/v0.10.0) for more information.

- `services.dnscrypt-wrapper` was removed, as the project has been effectively unmaintained since 2018. Moreover, the NixOS module had to rely on an abandoned version of `dnscrypt-proxy` v1 for the rotation of keys.
  To wrap a resolver with DNSCrypt, you can instead use `dnsdist`. See `services.dnsdist.dnscrypt`

- The `portunus` package and service do not support weak password hashes anymore.
  If you installed Portunus on NixOS 23.11 or earlier, upgrade to NixOS 24.05 first to get support for strong password hashing.
  Then, follow the instructions on the [upstream release notes](https://github.com/majewsky/portunus/releases/tag/v2.0.0) to upgrade all existing user accounts to strong password hashes.
  If you need to upgrade to 24.11 without having completed the migration, consider the security implications of weak password hashes on your user accounts, and add the following to your configuration:
  ```nix
  {
    services.portunus.package = pkgs.portunus.override { libxcrypt = pkgs.libxcrypt-legacy; };
    services.portunus.ldap.package = pkgs.openldap.override { libxcrypt = pkgs.libxcrypt-legacy; };
  }
  ```

- The default value of `services.kubernetes.kubelet.hostname` is now lowercased.
  Explicitly set `kubelet.hostname` to `networking.fqdnOrHostName` to get back
  the old default behavior.

- Docker now defaults to 27.x, as version 24.x stopped receiving security updates and bug fixes after [February 1, 2024](https://github.com/moby/moby/pull/46772#discussion_r1686464084).

- `keycloak` was updated to version 25, which introduces new hostname related options.
  See [Upgrading Guide](https://www.keycloak.org/docs/25.0.1/upgrading/#migrating-to-25-0-0) for instructions.

- `programs.vim.defaultEditor` now only works if `programs.vim.enable` is enabled.

- `services.mautrix-meta` was updated to [0.4](https://github.com/mautrix/meta/releases/tag/v0.4.0). This release makes significant changes to the settings format. If you have custom settings you should migrate them to the new format. Unfortunately upstream provides little guidance for how to do this, but [the auto-migration code](https://github.com/mautrix/meta/blob/f5440b05aac125b4c95b1af85635a717cbc6dd0e/cmd/mautrix-meta/legacymigrate.go#L23) may serve as a useful reference. The NixOS module should warn you if you still have any old settings configured.

- The `nodePackages.shout` package has been removed because it was deprecated upstream in favor of `thelounge`.
  The `shout` top-level attribute was an alias to this package.
  The associated `services.shout` module has also been removed.

- `prometheus-openldap-exporter` was removed, as it was unmaintained both upstream and in nixpkgs.

- The `indi-full` package no longer contains non-free drivers.
  To get the old collection of drivers use `indi-full-nonfree` or create your own collection of drivers by overriding indi-with-drivers.
  E.g.: `pkgs.indi-with-drivers.override {extraDrivers = with pkgs.indi-3rdparty; [indi-gphoto];}`

- `/share/vim-plugins` now only gets linked if `programs.vim.enable` is enabled

- The `services.guix` module now manages trusted substitute servers
  declaratively. Instead of `guix archive --authorize`, list keys with
  `services.guix.substituters.authorizedKeys`. Default substitute servers can be
  set via `services.guix.substituters.urls`.

- The `tracy` package no longer works on X11, since it's moved to Wayland
  support, which is the intended default behavior by Tracy maintainers.
  X11 users have to switch to the new package `tracy-x11`.

- `gollum` has been upgraded to major version 6. Please review their [migration notes](https://github.com/gollum/gollum/wiki/6.0-Release-Notes).

- `services.prometheus.exporters.minio` option has been removed, as it's upstream implementation was broken and unmaintained.
  Minio now has built-in [Prometheus metrics exposure](https://min.io/docs/minio/linux/operations/monitoring/collect-minio-metrics-using-prometheus.html), which can be used instead.

- The `services.prometheus.exporters.tor` option has been removed, as its upstream implementation was broken and unmaintained.

- `services.patroni.raft` has been removed, as Raft has been [deprecated by upstream since 3.0.0](https://github.com/patroni/patroni/blob/master/docs/releases.rst#version-300).

- The `jd-cli` package was removed due to an inactive upstream and a dependency on the shut down
  JCenter JAR repository.
  Java decompilers already packaged in Nixpkgs include `bytecode-viewer` (GUI), `cfr` (CLI), and `procyon` (CLI).

- The `jd-gui` package was removed due to an inactive upstream and a dependency on the end-of-life Gradle 6.
  Java decompilers already packaged in Nixpkgs include `bytecode-viewer` (GUI), `cfr` (CLI), and `procyon` (CLI).

- `services.roundcube.maxAttachmentSize` will multiply the value set with `1.37` to offset overhead introduced by the base64 encoding applied to attachments.

- `services.mxisd` has been removed as both [mxisd](https://github.com/kamax-matrix/mxisd) and [ma1sd](https://github.com/ma1uta/ma1sd) are no longer maintained.
  Consequently, the package `ma1sd` has also been removed.

- The `rss-bridge` service drops the support to load a configuration file from `${config.services.rss-bridge.dataDir}/config.ini.php`.
  Consider using the `services.rss-bridge.config` option instead.

- `mikutter` has been removed, as the package was broken and had no maintainers in nixpkgs.

- `xdg.portal.gtkUsePortal` has been removed, as it had been deprecated for over 2 years. Using the `GTK_USE_PORTAL` environment variable in this manner is not intended nor encouraged by the GTK developers, but can still be done manually via `environment.sessionVariables`.

- Support for the legacy CUPS browsing and LDAP have been removed from `services.printing`. If `cups` or `ldap` are in the `BrowseRemoteProtocols` setting in `services.printing.browsedConf`, it needs to be removed.

- `services.trust-dns` has been renamed to `services.hickory-dns`.

- `services.prometheus.exporters.pgbouncer.connectionStringFile` has been removed since
  it leaked the connection string (and thus potentially the DB password) into the cmdline
  of process making it effectively world-readable.

  Use [`services.prometheus.exporters.pgbouncer.connectionEnvFile`](#opt-services.prometheus.exporters.pgbouncer.connectionEnvFile) instead.

- `lsh` and `services.lshd` have been removed as they had no maintainer in Nixpkgs and no upstream release in over a decade. It is recommended to migrate to `openssh` and `services.openssh`.

- `ceph` has been upgraded to v19. See the [Ceph "squid" release notes](https://docs.ceph.com/en/latest/releases/squid/#v19-2-0-squid) for details and recommended upgrade procedure.

- `services.frr` has been refactored to use upstream service scripts. The per-daemon configurations
  have been removed in favour of an `integrated-vtysh-config` style config. The daemon submodules
  now use the daemon name (e.g. `ospfd`) instead of the protocol name (`ospf`). The daemons `zebra`,
  `mgmtd` and `staticd` are always enabled if a config is present. The `vtyListenAddress` and
  `vtyListenPort` options have been removed; use `options` or `extraOptions` instead, respectively.

- `opencv2` and `opencv3` have been removed, as they are obsolete and
  were not used by any other package. External users are encouraged to
  migrate to OpenCV 4.

- `tvheadend` package and the `services.tvheadend` module have been
  removed due to lack of maintenance in Nixpkgs and being stuck on
  an unmaintained version that required FFmpeg 4. Please see the related [pull
  request #332259](https://github.com/NixOS/nixpkgs/pull/332259) if you
  are interested in maintaining a newer version.

- `antennas` and `services.antennas` have been removed as they only work with `tvheadend` (see above).

- `system.build.brightboxImage` has been removed as it no longer built and has not seen any maintenance in over 7 years (excluding tree-wide changes).

- `services.syncplay` now exposes all currently available command-line arguments for `syncplay-server` as options, as well as a `useACMEHost` option for easy TLS setup.
  The systemd service now uses `DynamicUser`/`StateDirectory` and the `user` and `group` options have been deprecated.

- `openlens` was removed. It is recommended to use `lens-desktop` instead.

- `services.dnsmasq.extraConfig` has been removed, as it had been deprecated for over 2 years. This option has been replaced by `services.dnsmasq.settings`.

- The NixOS installation media no longer support the ReiserFS or JFS file systems by default.

- Minimal installer ISOs are no longer built on the small channel.
  Please obtain installer images from the full release channels.

- The default FFmpeg version is now 7.1, and FFmpeg 5 has been removed.
  Please prefer using the package variants without a version suffix,
  or pin FFmpeg 6 or 4 if necessary for compatibility.
  Note that we keep old versions around only as required
  to support packages in the tree,
  and FFmpeg 4 especially should be avoided in favour of newer versions
  as it may be removed soon.

- `openssl` now defaults to the latest version line `3.3.x`, instead of `3.0.x` before. While there should be no major code incompatibilities, newer OpenSSL versions typically strengthen the default security level. This means that you may have to explicitly allow weak ciphers, hashes and key lengths if necessary. See: [OpenSSL security level documentation](https://docs.openssl.org/3.3/man3/SSL_CTX_set_security_level/).

- `isync` has been updated to version `1.5.0`, which introduces some breaking changes. See the [compatibility concerns](https://sourceforge.net/projects/isync/files/isync/1.5.0/) for more details.

- Two new packages -- `gpauth` and `gpclient` from the 2.x version of the
  GlobalProtect-openconnect project -- are added in parallel to
  `globalprotect-openconnect`. The GUI components related to the project are
  non-free and not packaged.

- Compatible string matching for `hardware.deviceTree.overlays` has been changed to a more correct behavior. See [below](#sec-release-24.11-migration-dto-compatible) for details.

- `rustic` was upgraded to `0.9.0`, which contains [breaking changes to the config file format](https://github.com/rustic-rs/rustic/releases/tag/v0.9.0).

- `pkgs.formats.ini` and `pkgs.formats.iniWithGlobalSection` with
  `listsAsDuplicateKeys` or `listToValue` no longer merge non-list values into
  lists by default. Backwards-compatible behavior can be enabled with
  `atomsCoercedToLists`.

- Atlassian Server products have been removed, as support for the Atlassian Server
  products ended in February 2024 and there was insufficient interest in
  maintaining the Atlassian Data Center replacements:
  - The `atlassian-bamboo` package
  - The `atlassian-confluence` package and its `services.confluence` NixOS module
  - The `atlassian-crowd` package and its `services.crowd` NixOS module
  - The `atlassian-jira` package and its `services.jira` NixOS module

- `python3Packages.nose` has been removed, as it has been deprecated and unmaintained for almost a decade and does not work on Python 3.12.
  Please switch to `pytest` or another test runner/framework.

- `dotnet-sdk`, `dotnet-runtime`, and all other dotnet packages now use a
  wrapper package containing `bin/dotnet`, build hooks, etc. If you need to
  reference the underlying dotnet distribution (DOTNET_ROOT) you should use e.g.
  `dotnet-runtime.unwrapped`.

- The root of dotnet distribution packages (DOTNET_ROOT) is now under e.g.
  `${dotnet-sdk.unwrapped}/share/dotnet` instead of directly in the package
  root. This is consistent with packaging guidelines and more friendly for FHS
  environments.

- `dotnet-sdk`, `dotnet-runtime`, and `dotnet-aspnetcore` now point to dotnet 8
  rather than dotnet 6. For packages that still need dotnet 6, use
  `dotnet-sdk_6`, etc.

- torq has been removed because upstreamed went closed source.

## Other Notable Changes {#sec-release-24.11-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- The `zerocallusedregs` hardening flag is enabled by default on compilers that support it.

- The `stackclashprotection` hardening flag has been added, though disabled by default.

- The `pacret` hardening flag has been added, though disabled by default.

- `cargoSha256` in `rustPlatform.buildRustPackage` has been deprecated in favor
  of `cargoHash` which supports SRI hashes. See
  [buildRustPackage: Compiling Rust applications with Cargo](https://nixos.org/manual/nixpkgs/unstable/#compiling-rust-applications-with-cargo)
  for more information.

- The `vendorHash` of Go packages built with `buildGoModule` can now be overridden with `overrideAttrs`.
  `goModules`, `modRoot`, `vendorHash`, `deleteVendor`, and `proxyVendor` are now passed as derivation attributes.
  `goModules` and `vendorHash` are no longer placed under `passthru`.

- `buildFlags`/`buildFlagsArray` on `buildGoModule` have been deprecated. 24.11 is the last release where `buildGoModule` accepts these flags (while throwing a warning).
  Use the [`ldflags`](https://nixos.org/manual/nixpkgs/unstable/#var-go-ldflags) and/or [`tags`](https://nixos.org/manual/nixpkgs/unstable/#var-go-tags) attributes or
  [the environment](https://nixos.org/manual/nixpkgs/unstable/#ssec-go-environment) instead.

- `buildGoPackage` has been deprecated. 24.11 is the last release with `buildGoPackage` available.

- `hareHook` has been added as the language framework for Hare. From now on, it,
  not the `hare` package, should be added to `nativeBuildInputs` when building
  Hare programs.

- `virtualisation.docker.liveRestore` has been renamed to `virtualisation.docker.daemon.settings."live-restore"` and turned off by default for state versions of at least 24.11.

- Tailscale's `authKeyFile` can now have its corresponding parameters set through `config.services.tailscale.authKeyParameters`, allowing for non-ephemeral unsupervised deployment and more.
  See [Registering new nodes using OAuth credentials](https://tailscale.com/kb/1215/oauth-clients#registering-new-nodes-using-oauth-credentials) for the supported options.

- `nixosTests` now provide a working IPv6 setup for VLAN 1 by default.

- Kanidm can now be provisioned using the new [`services.kanidm.provision`] option, but requires using a patched version available via `pkgs.kanidm.withSecretProvisioning`.

- Kanidm previously had an incorrect systemd service type, causing dependent units with an `after` and `requires` directive to start before `kanidm*` finished startup. The module has now been updated in line with upstream recommendations.

- [`services.jupyter`](#opt-services.jupyter.enable) is now compatible with `Jupyter Notebook 7`. See [the migration guide](https://jupyter-notebook.readthedocs.io/en/latest/migrate_to_notebook7.html) for details.

- The kubelet configuration file can now be amended with arbitrary additional content using the `services.kubernetes.kubelet.extraConfig` option.

- The `services.seafile` module was updated to major version 11.
  - As part of this upgrade, the database backend will be migrated to MySQL.
    This process should be automatic, but in case of a botched migration,
    old sqlite files are not removed and can be used to manually migrate the database.
  - Additionally, the updated CSRF protection may prevent some users from logging in.
    Specific origin addresses can be whitelisted using the `services.seafile.seahubExtraConf` option
    (e.g. `services.seafile.seahubExtraConf = ''CSRF_TRUSTED_ORIGINS = ["https://example.com"]'';`).
    Note that first solution of the [official FAQ answer](https://cloud.seatable.io/dtable/external-links/7b976c85f504491cbe8e/?tid=0000&vid=0000&row-id=BQhH-2HSQs68Nq2EW91DBA)
    is not allowed by the `services.nginx` module's config-checker.

- The new option `boot.binfmt.addEmulatedSystemsToNixSandbox` allows you to skip adding the emulated systems to `nix.settings.extra-platforms`. Now you can emulate foreign binaries locally while only building them on native remote builders.

- The latest available version of Nextcloud is v30 (available as `pkgs.nextcloud30`). The installation logic is as follows:
  - If [`services.nextcloud.package`](#opt-services.nextcloud.package) is specified explicitly, this package will be installed (**recommended**)
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=24.05, `pkgs.nextcloud29` will be installed by default.
  - If [`system.stateVersion`](#opt-system.stateVersion) is >=24.11, `pkgs.nextcloud30` will be installed by default.
  - Please note that an upgrade from v28 (or older) to v30 directly is not possible. Please upgrade to `nextcloud29` (or earlier) first. Nextcloud prohibits skipping major versions while upgrading. You can upgrade by declaring [`services.nextcloud.package = pkgs.nextcloud29;`](options.html#opt-services.nextcloud.package).

- To facilitate dependency injection, the `imgui` package now builds a static archive using vcpkg' CMake rules.
  The derivation now installs "impl" headers selectively instead of by a wildcard.
  Use `imgui.src` if you just want to access the unpacked sources.

- The new `boot.loader.systemd-boot.windows` option makes setting up dual-booting with Windows on a different drive easier.

- The `boot.loader.raspberryPi` options were marked as deprecated in 23.11 and have now been removed.

- Linux 4.19 has been removed because it will reach its end of life within the lifespan of 24.11.

- Unprivileged access to the kernel syslog via `dmesg` is now restricted by default. Users wanting to keep an
  unrestricted access to it can set `boot.kernel.sysctl."kernel.dmesg_restrict" = false`.

- The `i18n.inputMethod` module introduces two new properties:
  `enable` and `type`, for declaring whether to enable an alternative input method and defining which input method respectfully. The options available in `type` are the same as the existing `enabled` option. `enabled` is now deprecated, and will be removed in a future release.

- `security.pam.u2f` now uses freeform options; all module options are now configurable through `security.pam.u2f.settings`.

- `mikutter` was removed as the package was broken and had no maintainers.

- `services.getty.autologinOnce` was added to limit the automatic login to once per boot and on the first tty only.
  When using full disk encryption, this option allows to unlock the system without retyping the passphrase while keeping the other ttys protected.

- Gollum was upgraded to major version 6. Read their [migration notes](https://github.com/gollum/gollum/wiki/6.0-Release-Notes).

- The hooks `yarnConfigHook` and `yarnBuildHook` were added. These should replace `yarn2nix.mkYarnPackage` and other `yarn2nix` related tools. The motivation to get rid of `yarn2nix` tools is the fact that they are too complex and hard to maintain, and they rely upon too much Nix evaluation which is problematic if import-from-derivation is not allowed (see more details at [#296856](https://github.com/NixOS/nixpkgs/issues/296856). The transition from `mkYarnPackage` to `yarn{Config,Build}Hook` is tracked at [#324246](https://github.com/NixOS/nixpkgs/issues/324246).

- `services.timesyncd.servers` now defaults to `null`, allowing systemd-timesyncd to use NTP servers advertised by DHCP.

- `services.timesyncd.fallbackServers` was added and defaults to `networking.timeServers`.

- Cinnamon has been updated to 6.2. Please check [upstream announcement](https://www.linuxmint.com/rel_wilma_whatsnew.php) for more details.
  Following Mint 22 defaults, the Cinnamon module no longer ships `geary` and `hexchat` by default.

- `zfs.latestCompatibleLinuxPackages` is deprecated and is now pointing at the default kernel. If using the stable LTS kernel (default `linuxPackages` is not possible then you must explicitly pin a specific kernel release. For example, `boot.kernelPackages = pkgs.linuxPackages_6_6`. Please be aware that non-LTS kernels are likely to go EOL before ZFS supports the latest supported non-LTS release, requiring manual intervention.

- The `shadowstack` hardening flag has been added, though disabled by default.

- `writeReferencesToFile` has been removed after its deprecation in 24.05. Use the trivial build helper `writeClosure` instead.

- `xxd` is now provided by the `tinyxxd` package rather than `vim.xxd` to reduce closure size and vulnerability impact. Since it has the same options and semantics as Vim's `xxd` utility, there is no user impact. Vim's `xxd` remains available as the `vim.xxd` package.

- `restic` module now has an option for inhibiting system sleep while backups are running, defaulting to off (not inhibiting sleep). Available as [`services.restic.backups.<name>.inhibitsSleep`](#opt-services.restic.backups._name_.inhibitsSleep).

- Mattermost has been updated from 9.5 to 9.11 ESR. See the [changelog](https://docs.mattermost.com/about/mattermost-v9-changelog.html#release-v9-11-extended-support-release) for more details.

- `cargo-tauri.hook` was introduced to help users build [Tauri](https://tauri.app/) projects. It is meant to be used alongside
  `rustPlatform.buildRustPackage` and Node hooks such as `npmConfigHook`, `pnpm.configHook`, and the new `yarnConfig`

- `power.ups` now powers off UPSs during a power outage event.
  This saves UPS battery and ensures that host(s) get back up again when power comes back, even in the scenario when the UPS would have had enough capacity to keep power on during the whole power outage.
  If you like the old behaviour of keeping the UPSs on (and emptying the battery) after the host(s) have shut down, and risk not getting a power cycle event to get the host(s) back up, set `power.ups.upsmon.settings.POWERDOWNFLAG = null;`.

- `nixos-firewall-tool` now supports nftables in addition to iptables and is installed by default when NixOS firewall is enabled.

- Support for *runner registration tokens* has been [deprecated](https://gitlab.com/gitlab-org/gitlab/-/issues/380872)
  in `gitlab-runner` 15.6 and is expected to be removed in `gitlab-runner` 18.0. Configuration of existing runners
  should be changed to using *runner authentication tokens* by configuring
  {option}`services.gitlab-runner.services.<name>.authenticationTokenConfigFile` instead of the former
  {option}`services.gitlab-runner.services.<name>.registrationConfigFile` option.

- `iproute2` now has libbpf support.

  If you use extensions that are not packaged in nixpkgs, please review whether it still works
  with the current settings and adjust accordingly if needed.

- `nix.channel.enable = false` no longer implies `nix.settings.nix-path = []`.
  Since Nix 2.13, a `nix-path` set in `nix.conf` cannot be overridden by the `NIX_PATH` configuration variable.

- ZFS now imports its pools in `postResumeCommands` rather than `postDeviceCommands`. If you had `postDeviceCommands` scripts that depended on ZFS pools being imported, those now need to be in `postResumeCommands`.

- `services.automatic-timezoned.enable = true` will now set `time.timeZone = null`.
  This is to avoid silently shadowing a user's explicitly defined timezone without recognition on the user's part.

- `services.localtimed.enable = true` will now set `time.timeZone = null`.
  This is to avoid silently shadowing a user's explicitly defined timezone without recognition on the user's part.

- `qgis` and `qgis-ltr` are now built without `grass` by default. `grass` support can be enabled with `qgis.override { withGrass = true; }`.

- `virtualisation.incus` module gained new `incus-user.service` and `incus-user.socket` systemd units. It is now possible to add a user to `incus` group instead of `incus-admin` for increased security.

- `buildDotnetModule` now uses JSON-based instead of nix-based lockfiles.
  Support for nix-based lockfiles has been deprecated and will be dropped on release 25.11.

- `buildDotnetModule.fetch-deps` now generates a JSON lockfile by default.
  A nix-based lockfile will be generated if one existed before for compatibility, however it has been deprecated and will be dropped on release 25.11.

- `freecad` now supports addons and custom configuration in nix-way, which can be used by calling `freecad.customize`.

- `buildNimSbom` was added as an alternative to `buildNimPackage`. `buildNimSbom` uses [SBOMs](https://cyclonedx.org/) to generate packages whereas `buildNimPackage` uses a custom JSON lockfile format.

## Detailed Migration Information {#sec-release-24.11-migration}

### `sound` options removal {#sec-release-24.11-migration-sound}

The `sound` options have been largely removed, as they are unnecessary for most modern setups, and cause issues when enabled.

If you set `sound.enable` in your configuration:
  - If you are using Pulseaudio or PipeWire, simply remove that option
  - If you are not using an external sound server, and want volumes to be persisted across shutdowns, set `hardware.alsa.enablePersistence = true` instead

If you set `sound.enableOSSEmulation` in your configuration:
  - Make sure it is still necessary, as very few applications actually use OSS
  - If necessary, set `boot.kernelModules = [ "snd_pcm_oss" ]`

If you set `sound.extraConfig` in your configuration:
  - If you are using another sound server, like Pulseaudio, JACK or PipeWire, migrate your configuration to that
  - If you are not using an external sound server, set `environment.etc."asound.conf".text = yourExtraConfig` instead

If you set `sound.mediaKeys` in your configuration:
  - Preferably switch to handling media keys in your desktop environment/compositor
  - If you want to maintain the exact behavior of the option, use the following snippet

```nix
{
  services.actkbd =
    let
      volumeStep = "1%";
    in
    {
      enable = true;
      bindings = [
        # "Mute" media key
        {
          keys = [ 113 ];
          events = [ "key" ];
          command = "${alsa-utils}/bin/amixer -q set Master toggle";
        }

        # "Lower Volume" media key
        {
          keys = [ 114 ];
          events = [
            "key"
            "rep"
          ];
          command = "${alsa-utils}/bin/amixer -q set Master ${volumeStep}- unmute";
        }

        # "Raise Volume" media key
        {
          keys = [ 115 ];
          events = [
            "key"
            "rep"
          ];
          command = "${alsa-utils}/bin/amixer -q set Master ${volumeStep}+ unmute";
        }

        # "Mic Mute" media key
        {
          keys = [ 190 ];
          events = [ "key" ];
          command = "${alsa-utils}/bin/amixer -q set Capture toggle";
        }
      ];
    };
}
```

### `hardware.deviceTree.overlays` compatible string matching {#sec-release-24.11-migration-dto-compatible}

The original compatible string implementation in older NixOS versions relied on substring matching,
which is incorrect for overlays with multiple compatible strings and other cases.

The new behavior is consistent with what other tools already do - the overlay is considered applicable if,
and only if, _any_ of the compatible strings in the overlay match _any_ of the compatible strings in the DT.

To provide some examples:

| Overlay `compatible` | DT `compatible` | Pre-24.11 behavior | Correct behavior | Notes                                      |
|----------------------|-----------------|--------------------|------------------|--------------------------------------------|
| `"foo"`              | `"foo", "bar"`  | match              | match            | Most common use case does not change       |
| `"foo"`              | `"foobar"`      | match              | no match         | Substrings should not be matched           |
| `"foo bar"`          | `"foo", "bar"`  | match              | no match         | Separators should not be matched to spaces |
| `"foo", "bar"`       | `"baz", "bar"`  | no match           | match            | One compatible string matching is enough   |

Note that this also allows writing overlays that explicitly apply to multiple boards.

## Nixpkgs Library {#sec-release-24.11-lib}

### Breaking changes {#sec-release-24.11-lib-breaking}

- [`lib.escapeShellArg`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.strings.escapeShellArg) and [`lib.escapeShellArgs`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.strings.escapeShellArgs): Arguments that don't need to be escaped won't be anymore, which is not breaking according to the functions documentation, but it can cause breakages if used for the non-intended use cases.
- [`lib.warn msg val`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.warn) (and its relatives [`lib.warnIf`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.warnIf) and [`lib.warnIfNot`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.warnIfNot)) now require `msg` to be a string to match the behavior of the new [`builtins.warn`](https://nix.dev/manual/nix/2.25/language/builtins.html?highlight=warn#builtins-warn).
- `lib.mdDoc`: Removed after deprecation in the previous release.

### Additions and Improvements {#sec-release-24.11-lib-additions-improvements}

New and extended interfaces:
- [`lib.fromHexString`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.fromHexString): Convert a hexadecimal string to it's integer representation.
- `lib.network.ipv6.fromString`: Parse an IPv6 address.
- [`lib.getLicenseFromSpdxIdOr`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.meta.getLicenseFromSpdxIdOr): Get the corresponding attribute in `lib.licenses` from an SPDX ID or fall back to the given default value.
- [`lib.licensesSpdx`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.meta.licensesSpdx): Mapping of SPDX ID to the attributes in `lib.licenses`.
- [`lib.getFirstOutput`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.attrsets.getFirstOutput): Like `getOutput` but with a list of fallback output names.
- [`lib.getInclude`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.attrsets.getInclude) and [`lib.getStatic`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.attrsets.getStatic): Get a package’s `include`/`static` output.
- [`lib.trim`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.strings.trim) and [`lib.trimWith`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.strings.trimWith): Remove leading and trailing whitespace from a string.
- [`lib.meta.defaultPriority`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.meta.defaultPriority): The default priority of packages in Nix.
- [`lib.toExtension`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.fixedPoints.toExtension): Convert to an extending function (overlay).
- `lib.fetchers.normalizeHash`: Convert an attrset containing one of `hash`, `sha256` or `sha512` into one containing `outputHash{,Algo}` as accepted by `mkDerivation`.
- `lib.fetchers.withNormalizedHash`: Wraps a function which accepts `outputHash{,Algo}` into one which accepts `hash`, `sha256` or `sha512`.
- Various builtins are now reexported in a more standard way:
  - `lib.map` -> `lib.lists.map` -> `builtins.map`
  - `lib.intersectAttrs` -> `lib.attrsets.intersectAttrs` -> `builtins.intersectAttrs`
  - `lib.removeAttrs` -> `lib.attrsets.removeAttrs` -> `builtins.removeAttrs`
  - `lib.match` -> `lib.strings.match` -> `builtins.match`
  - `lib.split` -> `lib.strings.split` -> `builtins.split`
  - `lib.typeOf` -> `builtins.typeOf`
  - `lib.unsafeGetAttrPos` -> `builtins.unsafeGetAttrPos`
- [`lib.cli.toGNUCommandLine`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.cli.toGNUCommandLine) now supports the `optionValueSeparator` argument attribute to control the key-value separator for arguments.

Documentation improvements:
- Much of the documentation has been migrated to the [standard doc-comment format](https://github.com/NixOS/rfcs/pull/145), including [`lib.derivations`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-derivations), [`lib.fixedPoints`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-fixedPoints), [`lib.gvariant`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-gvariant), [`lib.filesystem`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-filesystem), [`lib.strings`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-strings), [`lib.meta`](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-meta).
- [`lib.generators` documentation](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-generators) is now improved and rendered in the manual.
- [`lib.cli` documentation](https://nixos.org/manual/nixpkgs/unstable/#sec-functions-library-cli) is now improved and rendered in the manual.
- [`lib.composeExtensions`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.fixedPoints.composeExtensions) and [`lib.composeManyExtensions`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.fixedPoints.composeManyExtensions) documentation is now improved.
- [`lib.importTOML`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.importTOML) and [`lib.importJSON`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.importJSON)'s documentation now have an example.

Module System:
- `lib.importApply`: New function, imports a Nix expression file much like the module system would, after passing an extra positional argument to the function in the file.
- Improve error message when accessing an option that isn't defined.
- `lib.types.anything`: Don't fail to merge when specifying the same list multiple times.
- Improve error when loading a flake as a module.

### Deprecations {#sec-release-24.11-lib-deprecations}

- `lib.options.mkPackageOptionMD` is now obsolete; use the identical [`lib.options.mkPackageOption`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.options.mkPackageOption) instead.
- `lib.misc.mapAttrsFlatten` is now formally deprecated and will be removed in future releases; use the identical [`lib.attrsets.mapAttrsToList`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.attrsets.mapAttrsToList) instead.
- `lib.isInOldestRelease`: Renamed to [`oldestSupportedReleaseIsAtLeast`](https://nixos.org/manual/nixpkgs/unstable/#function-library-lib.trivial.oldestSupportedReleaseIsAtLeast) and deprecated.

## NixOS Wiki {#sec-release-24.11-wiki}

The official NixOS Wiki at [wiki.nixos.org](https://wiki.nixos.org/) was launched in April 2024, featuring
content initially copied from the community wiki. The wiki enhances the official documentation, linking to
existing resources and providing a categorization system for easy navigation, and is guided by a new "Manual
of Style" — a contribution guide and enhanced templates. It offers a wealth of new information, including
articles on applications, desktop environments, and a growing number of translations in multiple languages.
