{
  lib,
  stdenv,
  fetchFromGitHub,
  zlib,
  autoreconfHook,
  pkg-config,
  perl,
}:

stdenv.mkDerivation rec {
  pname = "vcftools";
  version = "0.1.17";

  src = fetchFromGitHub {
    repo = "vcftools";
    owner = "vcftools";
    rev = "v${version}";
    sha256 = "sha256-IiePgDpaL/6XOpQsOn90clB6ST7F/37sztmHrC7Ysbw=";
  };

  nativeBuildInputs = [
    pkg-config
    autoreconfHook
  ];
  buildInputs = [
    zlib
    perl
  ];

  meta = with lib; {
    description = "Set of tools written in Perl and C++ for working with VCF files, such as those generated by the 1000 Genomes Project";
    license = licenses.lgpl3;
    platforms = platforms.linux;
    homepage = "https://vcftools.github.io/index.html";
    maintainers = [ maintainers.rybern ];
  };
}
