{
  lib,
  rustPlatform,
  fetchFromGitHub,
  installShellFiles,
  pkg-config,
  oniguruma,
  stdenv,
}:

rustPlatform.buildRustPackage rec {
  pname = "termbook-cli";
  version = "1.4.6";

  src = fetchFromGitHub {
    owner = "Byron";
    repo = "termbook";
    rev = "v${version}";
    sha256 = "Bo3DI0cMXIfP7ZVr8MAW/Tmv+4mEJBIQyLvRfVBDG8c=";
  };

  cargoPatches = [
    # update dependencies to fix build failure caused by unaligned packed structs
    # generated by running `cargo update tendril`
    ./bump-tendril.patch
  ];

  cargoHash = "sha256-CVZpOaRXCSuU739Ef8ObLQBvry7C9iRWWnM+4ATufQA=";

  nativeBuildInputs = [
    installShellFiles
    pkg-config
  ];

  buildInputs = [
    oniguruma
  ];

  env = {
    RUSTONIG_SYSTEM_LIBONIG = true;
  };

  postInstall = lib.optionalString (stdenv.buildPlatform.canExecute stdenv.hostPlatform) ''
    installShellCompletion --cmd termbook \
      --bash <($out/bin/termbook completions bash) \
      --fish <($out/bin/termbook completions fish) \
      --zsh <($out/bin/termbook completions zsh)
  '';

  meta = with lib; {
    description = "Runner for `mdbooks` to keep your documentation tested";
    mainProgram = "termbook";
    homepage = "https://github.com/Byron/termbook/";
    changelog = "https://github.com/Byron/termbook/blob/${src.rev}/CHANGELOG.md";
    license = licenses.asl20;
    maintainers = with maintainers; [ phaer ];
  };
}
