{
  lib,
  python3Packages,
  fetchFromGitHub,
  writableTmpDirAsHomeHook,
  nixosTests,
}:

python3Packages.buildPythonApplication rec {
  pname = "blint";
  version = "3.0.2";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "owasp-dep-scan";
    repo = "blint";
    tag = "v${version}";
    hash = "sha256-ell0/opQso7/qD6d6i18vU55TfTgdcZwVFXD+yZg9/g=";
  };

  build-system = [
    python3Packages.poetry-core
  ];

  dependencies = with python3Packages; [
    pyyaml
    appdirs
    apsw
    ar
    custom-json-diff
    defusedxml
    email-validator
    lief
    oras
    orjson
    packageurl-python
    pydantic
    rich
    symbolic
  ];

  pythonRelaxDeps = [
    "apsw"
    "symbolic"
  ];

  pythonImportsCheck = [
    "blint"
  ];

  nativeCheckInputs = with python3Packages; [
    pytestCheckHook
    pytest-cov-stub
    writableTmpDirAsHomeHook
  ];

  # only runs on windows and fails, obviously
  disabledTests = [
    "test_demangle"
  ];

  passthru.tests = { inherit (nixosTests) blint; };

  meta = {
    description = "Binary Linter to check the security properties, and capabilities in executables";
    homepage = "https://github.com/owasp-dep-scan/blint";
    changelog = "https://github.com/owasp-dep-scan/blint/releases/tag/v${version}";
    license = lib.licenses.mit;
    platforms = lib.platforms.unix;
    maintainers = with lib.maintainers; [ ethancedwards8 ];
    teams = with lib.teams; [ ngi ];
    mainProgram = "blint";
  };
}
